/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.importer;

import java.util.Objects;

class NormalizedResourceName {
    private final String resourceName;

    private NormalizedResourceName(String resourceName) {
        this.resourceName = resourceName.replace('\\', '/').replaceAll("^/*", "").replaceAll("/*$", "");
    }

    static NormalizedResourceName from(String resourceName) {
        return new NormalizedResourceName(resourceName);
    }

    boolean isStartOf(String string) {
        return string.startsWith(this.resourceName);
    }

    public boolean startsWith(NormalizedResourceName prefix) {
        return this.equals(prefix) || this.isAncestorPath(prefix);
    }

    private boolean isAncestorPath(NormalizedResourceName prefix) {
        return this.resourceName.startsWith(prefix.resourceName) && this.resourceName.substring(prefix.resourceName.length()).startsWith("/");
    }

    String toAbsolutePath() {
        String result = "/" + this.resourceName;
        if (!result.endsWith(".class") && !result.endsWith("/")) {
            result = result + "/";
        }
        return result;
    }

    boolean belongsToClassFile() {
        return this.resourceName.endsWith(".class");
    }

    String toEntryName() {
        return this.toAbsolutePath().substring(1);
    }

    public int hashCode() {
        return Objects.hash(this.resourceName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NormalizedResourceName other = (NormalizedResourceName)obj;
        return Objects.equals(this.resourceName, other.resourceName);
    }

    public String toString() {
        return this.resourceName;
    }
}

