/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.importer;

import com.tngtech.archunit.base.Optional;
import com.tngtech.archunit.core.domain.JavaCodeUnit;
import com.tngtech.archunit.core.importer.DomainBuilders;
import com.tngtech.archunit.core.importer.GenericMemberTypeProcessor;
import com.tngtech.archunit.core.importer.SignatureTypeParameterProcessor;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.org.objectweb.asm.signature.SignatureReader;
import com.tngtech.archunit.thirdparty.org.objectweb.asm.signature.SignatureVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JavaCodeUnitSignatureImporter {
    private static final Logger log = LoggerFactory.getLogger(JavaCodeUnitSignatureImporter.class);

    JavaCodeUnitSignatureImporter() {
    }

    public static JavaCodeUnitSignature parseAsmMethodSignature(String signature) {
        if (signature == null) {
            return JavaCodeUnitSignature.ABSENT;
        }
        log.trace("Analyzing method signature: {}", (Object)signature);
        SignatureProcessor signatureProcessor = new SignatureProcessor();
        new SignatureReader(signature).accept(signatureProcessor);
        return signatureProcessor.getParsedSignature();
    }

    static class JavaCodeUnitSignature {
        static final JavaCodeUnitSignature ABSENT = new JavaCodeUnitSignature(Collections.emptyList(), Collections.emptyList(), Optional.empty());
        private final List<DomainBuilders.JavaTypeParameterBuilder<JavaCodeUnit>> typeParameterBuilders;
        private final List<DomainBuilders.JavaTypeCreationProcess<JavaCodeUnit>> parameterTypes;
        private final Optional<DomainBuilders.JavaTypeCreationProcess<JavaCodeUnit>> returnType;

        private JavaCodeUnitSignature(List<DomainBuilders.JavaTypeParameterBuilder<JavaCodeUnit>> typeParameterBuilders, List<DomainBuilders.JavaTypeCreationProcess<JavaCodeUnit>> parameterTypes, Optional<DomainBuilders.JavaTypeCreationProcess<JavaCodeUnit>> returnType) {
            this.typeParameterBuilders = Preconditions.checkNotNull(typeParameterBuilders);
            this.parameterTypes = parameterTypes;
            this.returnType = Preconditions.checkNotNull(returnType);
        }

        List<DomainBuilders.JavaTypeParameterBuilder<JavaCodeUnit>> getTypeParameterBuilders() {
            return this.typeParameterBuilders;
        }

        List<DomainBuilders.JavaTypeCreationProcess<JavaCodeUnit>> getParameterTypes() {
            return this.parameterTypes;
        }

        Optional<DomainBuilders.JavaTypeCreationProcess<JavaCodeUnit>> getReturnType() {
            return this.returnType;
        }
    }

    private static class SignatureProcessor
    extends SignatureVisitor {
        private final SignatureTypeParameterProcessor<JavaCodeUnit> typeParameterProcessor = new SignatureTypeParameterProcessor();
        private final List<GenericMemberTypeProcessor<JavaCodeUnit>> genericMethodParameterTypeProcessors = new ArrayList<GenericMemberTypeProcessor<JavaCodeUnit>>();
        private final GenericMemberTypeProcessor<JavaCodeUnit> genericMethodReturnTypeProcessor = new GenericMemberTypeProcessor();

        SignatureProcessor() {
            super(589824);
        }

        @Override
        public void visitFormalTypeParameter(String name) {
            log.trace("Encountered type parameter {}", (Object)name);
            this.typeParameterProcessor.addTypeParameter(name);
        }

        @Override
        public SignatureVisitor visitClassBound() {
            return this.typeParameterProcessor;
        }

        @Override
        public SignatureVisitor visitInterfaceBound() {
            return this.typeParameterProcessor;
        }

        @Override
        public SignatureVisitor visitParameterType() {
            GenericMemberTypeProcessor parameterTypeProcessor = new GenericMemberTypeProcessor();
            this.genericMethodParameterTypeProcessors.add(parameterTypeProcessor);
            return parameterTypeProcessor;
        }

        @Override
        public SignatureVisitor visitReturnType() {
            return this.genericMethodReturnTypeProcessor;
        }

        public JavaCodeUnitSignature getParsedSignature() {
            ArrayList<DomainBuilders.JavaTypeCreationProcess<JavaCodeUnit>> parameterTypes = new ArrayList<DomainBuilders.JavaTypeCreationProcess<JavaCodeUnit>>();
            for (GenericMemberTypeProcessor<JavaCodeUnit> parameterTypeProcessor : this.genericMethodParameterTypeProcessors) {
                if (!parameterTypeProcessor.getType().isPresent()) continue;
                parameterTypes.add(parameterTypeProcessor.getType().get());
            }
            return new JavaCodeUnitSignature(this.typeParameterProcessor.getTypeParameterBuilders(), parameterTypes, this.genericMethodReturnTypeProcessor.getType());
        }
    }
}

