/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.importer;

import com.tngtech.archunit.core.domain.JavaClassDescriptor;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import com.tngtech.archunit.thirdparty.org.objectweb.asm.Type;
import java.util.List;

class JavaClassDescriptorImporter {
    JavaClassDescriptorImporter() {
    }

    static JavaClassDescriptor createFromAsmObjectTypeName(String objectTypeName) {
        return JavaClassDescriptor.From.name(Type.getObjectType(objectTypeName).getClassName());
    }

    static JavaClassDescriptor importAsmType(Object type) {
        return JavaClassDescriptorImporter.importAsmType((Type)type);
    }

    private static JavaClassDescriptor importAsmType(Type type) {
        return JavaClassDescriptor.From.name(type.getClassName());
    }

    static boolean isAsmType(Object value) {
        return value instanceof Type;
    }

    static Object importAsmTypeIfPossible(Object value) {
        return JavaClassDescriptorImporter.isAsmType(value) ? JavaClassDescriptorImporter.importAsmType(value) : value;
    }

    static JavaClassDescriptor importAsmTypeFromDescriptor(String typeDescriptor) {
        return JavaClassDescriptorImporter.importAsmType(Type.getType(typeDescriptor));
    }

    static List<JavaClassDescriptor> importAsmMethodArgumentTypes(String methodDescriptor) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (Type type : Type.getArgumentTypes(methodDescriptor)) {
            result.add(JavaClassDescriptorImporter.importAsmType(type));
        }
        return result.build();
    }

    static JavaClassDescriptor importAsmMethodReturnType(String methodDescriptor) {
        return JavaClassDescriptorImporter.importAsmType(Type.getReturnType(methodDescriptor));
    }
}

