/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.importer;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.core.importer.Location;
import com.tngtech.archunit.thirdparty.com.google.common.base.Predicate;
import com.tngtech.archunit.thirdparty.com.google.common.base.Predicates;
import java.util.regex.Pattern;

@PublicAPI(usage=PublicAPI.Usage.INHERITANCE)
public interface ImportOption {
    public boolean includes(Location var1);

    public static final class DoNotIncludeArchives
    implements ImportOption {
        @Override
        public boolean includes(Location location) {
            return !location.isArchive();
        }
    }

    public static final class DoNotIncludeJars
    implements ImportOption {
        @Override
        public boolean includes(Location location) {
            return !location.isJar();
        }
    }

    public static final class OnlyIncludeTests
    implements ImportOption {
        @Override
        public boolean includes(Location location) {
            return Predefined.TEST_LOCATION.apply(location);
        }
    }

    public static final class DoNotIncludeTests
    implements ImportOption {
        @Override
        public boolean includes(Location location) {
            return Predefined.NO_TEST_LOCATION.apply(location);
        }
    }

    public static enum Predefined implements ImportOption
    {
        DO_NOT_INCLUDE_TESTS{
            private final DoNotIncludeTests doNotIncludeTests = new DoNotIncludeTests();

            @Override
            public boolean includes(Location location) {
                return this.doNotIncludeTests.includes(location);
            }
        }
        ,
        ONLY_INCLUDE_TESTS{
            private final OnlyIncludeTests onlyIncludeTests = new OnlyIncludeTests();

            @Override
            public boolean includes(Location location) {
                return this.onlyIncludeTests.includes(location);
            }
        }
        ,
        DO_NOT_INCLUDE_JARS{
            private final DoNotIncludeJars doNotIncludeJars = new DoNotIncludeJars();

            @Override
            public boolean includes(Location location) {
                return this.doNotIncludeJars.includes(location);
            }
        }
        ,
        DO_NOT_INCLUDE_ARCHIVES{
            private final DoNotIncludeArchives doNotIncludeArchives = new DoNotIncludeArchives();

            @Override
            public boolean includes(Location location) {
                return this.doNotIncludeArchives.includes(location);
            }
        };

        static final PatternPredicate MAVEN_TEST_PATTERN;
        static final PatternPredicate GRADLE_TEST_PATTERN;
        static final PatternPredicate INTELLIJ_TEST_PATTERN;
        static final Predicate<Location> TEST_LOCATION;
        static final Predicate<Location> NO_TEST_LOCATION;

        static {
            MAVEN_TEST_PATTERN = new PatternPredicate(".*/target/test-classes/.*");
            GRADLE_TEST_PATTERN = new PatternPredicate(".*/build/classes/([^/]+/)?test/.*");
            INTELLIJ_TEST_PATTERN = new PatternPredicate(".*/out/test/classes/.*");
            TEST_LOCATION = Predicates.or(MAVEN_TEST_PATTERN, GRADLE_TEST_PATTERN, INTELLIJ_TEST_PATTERN);
            NO_TEST_LOCATION = Predicates.not(TEST_LOCATION);
        }

        private static class PatternPredicate
        implements Predicate<Location> {
            private final Pattern pattern;

            PatternPredicate(String pattern) {
                this.pattern = Pattern.compile(pattern);
            }

            @Override
            public boolean apply(Location input) {
                return input.matches(this.pattern);
            }
        }
    }
}

