/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.importer;

import com.tngtech.archunit.base.HasDescription;
import com.tngtech.archunit.base.Optional;
import com.tngtech.archunit.core.importer.DomainBuilders;
import com.tngtech.archunit.core.importer.JavaClassDescriptorImporter;
import com.tngtech.archunit.core.importer.SignatureTypeArgumentProcessor;
import com.tngtech.archunit.thirdparty.org.objectweb.asm.signature.SignatureVisitor;

class GenericMemberTypeProcessor<T extends HasDescription>
extends SignatureVisitor {
    private DomainBuilders.JavaParameterizedTypeBuilder<T> parameterizedType;
    private DomainBuilders.JavaTypeCreationProcess<T> typeCreationProcess;
    private DomainBuilders.JavaTypeCreationProcess.JavaTypeFinisher typeFinisher = DomainBuilders.JavaTypeCreationProcess.JavaTypeFinisher.IDENTITY;

    GenericMemberTypeProcessor() {
        super(589824);
    }

    Optional<DomainBuilders.JavaTypeCreationProcess<T>> getType() {
        return Optional.ofNullable(this.typeCreationProcess);
    }

    @Override
    public void visitClassType(String internalObjectName) {
        this.updateType(new DomainBuilders.JavaParameterizedTypeBuilder(JavaClassDescriptorImporter.createFromAsmObjectTypeName(internalObjectName)));
    }

    @Override
    public void visitBaseType(char descriptor) {
        this.visitClassType(String.valueOf(descriptor));
    }

    @Override
    public void visitInnerClassType(String name) {
        this.updateType(this.parameterizedType.forInnerClass(name));
    }

    @Override
    public void visitTypeArgument() {
        this.parameterizedType.addTypeArgument(new SignatureTypeArgumentProcessor.NewJavaTypeCreationProcess(new DomainBuilders.JavaWildcardTypeBuilder()));
    }

    @Override
    public SignatureVisitor visitTypeArgument(char wildcard) {
        return SignatureTypeArgumentProcessor.create(wildcard, this.parameterizedType, DomainBuilders.JavaTypeCreationProcess.JavaTypeFinisher.IDENTITY);
    }

    @Override
    public SignatureVisitor visitArrayType() {
        this.typeFinisher = this.typeFinisher.after(DomainBuilders.JavaTypeCreationProcess.JavaTypeFinisher.ARRAY_CREATOR);
        return this;
    }

    @Override
    public void visitTypeVariable(String name) {
        this.typeCreationProcess = new SignatureTypeArgumentProcessor.ReferenceCreationProcess<T>(name, this.typeFinisher);
    }

    private void updateType(DomainBuilders.JavaParameterizedTypeBuilder<T> type) {
        this.parameterizedType = type;
        this.typeCreationProcess = new SignatureTypeArgumentProcessor.NewJavaTypeCreationProcess<T>(this.parameterizedType, this.typeFinisher);
    }
}

