/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.importer;

import com.tngtech.archunit.Internal;
import com.tngtech.archunit.base.Function;
import com.tngtech.archunit.base.HasDescription;
import com.tngtech.archunit.base.Optional;
import com.tngtech.archunit.core.domain.AccessTarget;
import com.tngtech.archunit.core.domain.DomainObjectCreationContext;
import com.tngtech.archunit.core.domain.Formatters;
import com.tngtech.archunit.core.domain.InstanceofCheck;
import com.tngtech.archunit.core.domain.JavaAnnotation;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaClassDescriptor;
import com.tngtech.archunit.core.domain.JavaCodeUnit;
import com.tngtech.archunit.core.domain.JavaConstructor;
import com.tngtech.archunit.core.domain.JavaConstructorCall;
import com.tngtech.archunit.core.domain.JavaEnumConstant;
import com.tngtech.archunit.core.domain.JavaField;
import com.tngtech.archunit.core.domain.JavaFieldAccess;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.core.domain.JavaMethodCall;
import com.tngtech.archunit.core.domain.JavaModifier;
import com.tngtech.archunit.core.domain.JavaParameter;
import com.tngtech.archunit.core.domain.JavaParameterizedType;
import com.tngtech.archunit.core.domain.JavaStaticInitializer;
import com.tngtech.archunit.core.domain.JavaType;
import com.tngtech.archunit.core.domain.JavaTypeVariable;
import com.tngtech.archunit.core.domain.JavaWildcardType;
import com.tngtech.archunit.core.domain.ReferencedClassObject;
import com.tngtech.archunit.core.domain.Source;
import com.tngtech.archunit.core.domain.ThrowsClause;
import com.tngtech.archunit.core.domain.properties.HasName;
import com.tngtech.archunit.core.domain.properties.HasTypeParameters;
import com.tngtech.archunit.core.importer.ImportedClasses;
import com.tngtech.archunit.core.importer.JavaClassDescriptorImporter;
import com.tngtech.archunit.core.importer.RawInstanceofCheck;
import com.tngtech.archunit.core.importer.RawReferencedClassObject;
import com.tngtech.archunit.core.importer.SourceDescriptor;
import com.tngtech.archunit.thirdparty.com.google.common.base.Joiner;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.base.Supplier;
import com.tngtech.archunit.thirdparty.com.google.common.collect.FluentIterable;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableMap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import com.tngtech.archunit.thirdparty.com.google.common.collect.SetMultimap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Internal
public final class DomainBuilders {
    private DomainBuilders() {
    }

    static <T extends HasDescription> Map<String, JavaAnnotation<T>> buildAnnotations(T owner, Set<JavaAnnotationBuilder> annotations, ImportedClasses importedClasses) {
        ImmutableMap.Builder<String, JavaAnnotation<T>> result = ImmutableMap.builder();
        for (JavaAnnotationBuilder annotationBuilder : annotations) {
            JavaAnnotation<T> javaAnnotation = annotationBuilder.build(owner, importedClasses);
            result.put(javaAnnotation.getRawType().getName(), javaAnnotation);
        }
        return result.build();
    }

    private static Set<JavaTypeVariable<?>> allTypeParametersInEnclosingContextOf(JavaCodeUnit codeUnit) {
        JavaClass declaringClass = codeUnit.getOwner();
        return FluentIterable.from(DomainBuilders.getTypeParametersOf(declaringClass)).append((Iterable<JavaTypeVariable<?>>)DomainBuilders.allTypeParametersInEnclosingContextOf(declaringClass)).toSet();
    }

    private static List<JavaTypeVariable<?>> getTypeParametersOf(HasTypeParameters<?> hasTypeParameters) {
        List<JavaTypeVariable<?>> result = hasTypeParameters.getTypeParameters();
        return result;
    }

    private static Set<JavaTypeVariable<?>> allTypeParametersInEnclosingContextOf(JavaClass javaClass) {
        HashSet result = new HashSet();
        while (javaClass.getEnclosingClass().isPresent()) {
            if (javaClass.getEnclosingCodeUnit().isPresent()) {
                result.addAll(javaClass.getEnclosingCodeUnit().get().getTypeParameters());
            }
            result.addAll(javaClass.getEnclosingClass().get().getTypeParameters());
            javaClass = javaClass.getEnclosingClass().get();
        }
        return result;
    }

    private static <OWNER> List<JavaType> buildJavaTypes(List<? extends JavaTypeCreationProcess<OWNER>> typeCreationProcesses, OWNER owner, Iterable<JavaTypeVariable<?>> allGenericParametersInContext, ImportedClasses classes) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (JavaTypeCreationProcess<OWNER> typeCreationProcess : typeCreationProcesses) {
            result.add(typeCreationProcess.finish(owner, allGenericParametersInContext, classes));
        }
        return result.build();
    }

    private static JavaClass getUnboundErasureType(List<JavaType> upperBounds, ImportedClasses importedClasses) {
        return upperBounds.size() > 0 ? upperBounds.get(0).toErasure() : importedClasses.getOrResolve(Object.class.getName());
    }

    @Internal
    public static final class JavaAnnotationBuilder {
        private JavaClassDescriptor type;
        private final Map<String, ValueBuilder> values = new LinkedHashMap<String, ValueBuilder>();
        private ImportedClasses importedClasses;

        JavaAnnotationBuilder() {
        }

        JavaAnnotationBuilder withType(JavaClassDescriptor type) {
            this.type = type;
            return this;
        }

        String getFullyQualifiedClassName() {
            return this.type.getFullyQualifiedClassName();
        }

        JavaAnnotationBuilder addProperty(String key, ValueBuilder valueBuilder) {
            this.values.put(key, valueBuilder);
            return this;
        }

        public JavaClass getType() {
            return this.importedClasses.getOrResolve(this.type.getFullyQualifiedClassName());
        }

        public <T extends HasDescription> Map<String, Object> getValues(T owner) {
            ImmutableMap.Builder<String, Object> result = ImmutableMap.builder();
            for (Map.Entry<String, ValueBuilder> entry : this.values.entrySet()) {
                Optional<Object> value = entry.getValue().build(owner, this.importedClasses);
                if (!value.isPresent()) continue;
                result.put(entry.getKey(), value.get());
            }
            return result.build();
        }

        public <T extends HasDescription> JavaAnnotation<T> build(T owner, ImportedClasses importedClasses) {
            this.importedClasses = importedClasses;
            return DomainObjectCreationContext.createJavaAnnotation(owner, this);
        }

        static abstract class ValueBuilder {
            ValueBuilder() {
            }

            abstract <T extends HasDescription> Optional<Object> build(T var1, ImportedClasses var2);

            static ValueBuilder ofFinished(final Object value) {
                return new ValueBuilder(){

                    @Override
                    <T extends HasDescription> Optional<Object> build(T owner, ImportedClasses unused) {
                        return Optional.of(value);
                    }
                };
            }

            static ValueBuilder from(JavaAnnotationBuilder builder) {
                return new ValueBuilder(){

                    @Override
                    <T extends HasDescription> Optional<Object> build(T owner, ImportedClasses importedClasses) {
                        return Optional.of(JavaAnnotationBuilder.this.build(owner, importedClasses));
                    }
                };
            }
        }
    }

    static interface JavaTypeCreationProcess<OWNER> {
        public JavaType finish(OWNER var1, Iterable<JavaTypeVariable<?>> var2, ImportedClasses var3);

        public static abstract class JavaTypeFinisher {
            static JavaTypeFinisher IDENTITY = new JavaTypeFinisher(){

                @Override
                JavaType finish(JavaType input, ImportedClasses classes) {
                    return input;
                }

                @Override
                String getFinishedName(String name) {
                    return name;
                }
            };
            static final JavaTypeFinisher ARRAY_CREATOR = new JavaTypeFinisher(){

                @Override
                public JavaType finish(JavaType componentType, ImportedClasses classes) {
                    JavaClassDescriptor erasureType = JavaClassDescriptor.From.javaClass(componentType.toErasure()).toArrayDescriptor();
                    if (componentType instanceof JavaClass) {
                        return classes.getOrResolve(erasureType.getFullyQualifiedClassName());
                    }
                    JavaClass erasure = classes.getOrResolve(erasureType.getFullyQualifiedClassName());
                    return DomainObjectCreationContext.createGenericArrayType(componentType, erasure);
                }

                @Override
                String getFinishedName(String name) {
                    return name + "[]";
                }
            };

            private JavaTypeFinisher() {
            }

            abstract JavaType finish(JavaType var1, ImportedClasses var2);

            abstract String getFinishedName(String var1);

            JavaTypeFinisher after(final JavaTypeFinisher other) {
                return new JavaTypeFinisher(){

                    @Override
                    JavaType finish(JavaType input, ImportedClasses classes) {
                        return JavaTypeFinisher.this.finish(other.finish(input, classes), classes);
                    }

                    @Override
                    String getFinishedName(String name) {
                        return JavaTypeFinisher.this.getFinishedName(other.getFinishedName(name));
                    }
                };
            }
        }
    }

    private static class ImportedParameterizedType
    implements JavaParameterizedType {
        private final JavaType type;
        private final List<JavaType> typeArguments;

        ImportedParameterizedType(JavaType type, List<JavaType> typeArguments) {
            Preconditions.checkArgument(typeArguments.size() > 0, "Parameterized type cannot be created without type arguments. This is likely a bug.");
            this.type = type;
            this.typeArguments = typeArguments;
        }

        @Override
        public String getName() {
            return this.type.getName() + this.formatTypeArguments();
        }

        @Override
        public JavaClass toErasure() {
            return this.type.toErasure();
        }

        @Override
        public List<JavaType> getActualTypeArguments() {
            return this.typeArguments;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{" + this.getName() + '}';
        }

        private String formatTypeArguments() {
            ArrayList<String> formatted = new ArrayList<String>();
            for (JavaType typeArgument : this.typeArguments) {
                formatted.add(Formatters.ensureCanonicalArrayTypeName(typeArgument.getName()));
            }
            return "<" + Joiner.on(", ").join(formatted) + ">";
        }
    }

    @Internal
    public static final class MethodCallTargetBuilder
    extends CodeUnitCallTargetBuilder<MethodCallTargetBuilder> {
        private Supplier<Set<JavaMethod>> methods;

        MethodCallTargetBuilder() {
        }

        MethodCallTargetBuilder withMethods(Supplier<Set<JavaMethod>> methods) {
            this.methods = methods;
            return this;
        }

        public Supplier<Set<JavaMethod>> getMethods() {
            return this.methods;
        }

        AccessTarget.MethodCallTarget build() {
            return DomainObjectCreationContext.createMethodCallTarget(this);
        }
    }

    @Internal
    public static final class ConstructorCallTargetBuilder
    extends CodeUnitCallTargetBuilder<ConstructorCallTargetBuilder> {
        private Supplier<Optional<JavaConstructor>> constructor;

        ConstructorCallTargetBuilder() {
            this.withName("<init>");
        }

        ConstructorCallTargetBuilder withConstructor(Supplier<Optional<JavaConstructor>> constructor) {
            this.constructor = constructor;
            return (ConstructorCallTargetBuilder)this.self();
        }

        public Supplier<Optional<JavaConstructor>> getConstructor() {
            return this.constructor;
        }

        AccessTarget.ConstructorCallTarget build() {
            return DomainObjectCreationContext.createConstructorCallTarget(this);
        }
    }

    @Internal
    public static abstract class CodeUnitCallTargetBuilder<SELF extends CodeUnitCallTargetBuilder<SELF>>
    extends AccessTargetBuilder<SELF> {
        private List<JavaClass> parameters;
        private JavaClass returnType;

        private CodeUnitCallTargetBuilder() {
        }

        SELF withParameters(List<JavaClass> parameters) {
            this.parameters = parameters;
            return (SELF)((CodeUnitCallTargetBuilder)this.self());
        }

        SELF withReturnType(JavaClass returnType) {
            this.returnType = returnType;
            return (SELF)((CodeUnitCallTargetBuilder)this.self());
        }

        public List<JavaClass> getParameters() {
            return this.parameters;
        }

        public JavaClass getReturnType() {
            return this.returnType;
        }

        public String getFullName() {
            return Formatters.formatMethod(this.getOwner().getName(), this.getName(), HasName.Utils.namesOf(this.parameters));
        }
    }

    @Internal
    public static final class FieldAccessTargetBuilder
    extends AccessTargetBuilder<FieldAccessTargetBuilder> {
        private JavaClass type;
        private Supplier<Optional<JavaField>> field;

        FieldAccessTargetBuilder() {
        }

        FieldAccessTargetBuilder withType(JavaClass type) {
            this.type = type;
            return this;
        }

        FieldAccessTargetBuilder withField(Supplier<Optional<JavaField>> field) {
            this.field = field;
            return this;
        }

        public JavaClass getType() {
            return this.type;
        }

        public Supplier<Optional<JavaField>> getField() {
            return this.field;
        }

        public String getFullName() {
            return this.getOwner().getName() + "." + this.getName();
        }

        AccessTarget.FieldAccessTarget build() {
            return DomainObjectCreationContext.createFieldAccessTarget(this);
        }
    }

    static abstract class AccessTargetBuilder<SELF extends AccessTargetBuilder<SELF>> {
        private JavaClass owner;
        private String name;

        private AccessTargetBuilder() {
        }

        SELF withOwner(JavaClass owner) {
            this.owner = owner;
            return this.self();
        }

        SELF withName(String name) {
            this.name = name;
            return this.self();
        }

        public JavaClass getOwner() {
            return this.owner;
        }

        public String getName() {
            return this.name;
        }

        SELF self() {
            return (SELF)this;
        }
    }

    @Internal
    public static class JavaConstructorCallBuilder
    extends JavaAccessBuilder<AccessTarget.ConstructorCallTarget, JavaConstructorCallBuilder> {
        JavaConstructorCallBuilder() {
        }

        JavaConstructorCall build() {
            return DomainObjectCreationContext.createJavaConstructorCall(this);
        }
    }

    @Internal
    public static final class JavaMethodCallBuilder
    extends JavaAccessBuilder<AccessTarget.MethodCallTarget, JavaMethodCallBuilder> {
        JavaMethodCallBuilder() {
        }

        JavaMethodCall build() {
            return DomainObjectCreationContext.createJavaMethodCall(this);
        }
    }

    @Internal
    public static class JavaFieldAccessBuilder
    extends JavaAccessBuilder<AccessTarget.FieldAccessTarget, JavaFieldAccessBuilder> {
        private JavaFieldAccess.AccessType accessType;

        JavaFieldAccessBuilder() {
        }

        JavaFieldAccessBuilder withAccessType(JavaFieldAccess.AccessType accessType) {
            this.accessType = accessType;
            return this;
        }

        public JavaFieldAccess.AccessType getAccessType() {
            return this.accessType;
        }

        JavaFieldAccess build() {
            return DomainObjectCreationContext.createJavaFieldAccess(this);
        }
    }

    @Internal
    public static abstract class JavaAccessBuilder<TARGET extends AccessTarget, SELF extends JavaAccessBuilder<TARGET, SELF>> {
        private JavaCodeUnit origin;
        private TARGET target;
        private int lineNumber;

        private JavaAccessBuilder() {
        }

        SELF withOrigin(JavaCodeUnit origin) {
            this.origin = origin;
            return this.self();
        }

        SELF withTarget(TARGET target) {
            this.target = target;
            return this.self();
        }

        SELF withLineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
            return this.self();
        }

        public JavaCodeUnit getOrigin() {
            return this.origin;
        }

        public TARGET getTarget() {
            return this.target;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        private SELF self() {
            return (SELF)this;
        }
    }

    @Internal
    static interface BuilderWithBuildParameter<PARAMETER, VALUE> {
        public VALUE build(PARAMETER var1, ImportedClasses var2);

        @Internal
        public static class BuildFinisher {
            static <PARAMETER, VALUE> Set<VALUE> build(Set<? extends BuilderWithBuildParameter<PARAMETER, ? extends VALUE>> builders, PARAMETER parameter, ImportedClasses importedClasses) {
                Preconditions.checkNotNull(builders);
                Preconditions.checkNotNull(parameter);
                ImmutableSet.Builder result = ImmutableSet.builder();
                for (BuilderWithBuildParameter<PARAMETER, VALUE> builder : builders) {
                    result.add(builder.build(parameter, importedClasses));
                }
                return result.build();
            }
        }
    }

    static class JavaParameterizedTypeBuilder<OWNER extends HasDescription>
    implements JavaTypeBuilder<OWNER> {
        private final JavaClassDescriptor type;
        private final List<JavaTypeCreationProcess<OWNER>> typeArgumentCreationProcesses = new ArrayList<JavaTypeCreationProcess<OWNER>>();

        JavaParameterizedTypeBuilder(JavaClassDescriptor type) {
            this.type = type;
        }

        void addTypeArgument(JavaTypeCreationProcess<OWNER> typeCreationProcess) {
            this.typeArgumentCreationProcesses.add(typeCreationProcess);
        }

        @Override
        public JavaType build(OWNER owner, Iterable<JavaTypeVariable<?>> allTypeParametersInContext, ImportedClasses classes) {
            List typeArguments = DomainBuilders.buildJavaTypes(this.typeArgumentCreationProcesses, owner, allTypeParametersInContext, classes);
            return typeArguments.isEmpty() ? classes.getOrResolve(this.type.getFullyQualifiedClassName()) : new ImportedParameterizedType(classes.getOrResolve(this.type.getFullyQualifiedClassName()), typeArguments);
        }

        String getTypeName() {
            return this.type.getFullyQualifiedClassName();
        }

        JavaParameterizedTypeBuilder<OWNER> forInnerClass(String simpleInnerClassName) {
            return new JavaParameterizedTypeBuilder<OWNER>(JavaClassDescriptorImporter.createFromAsmObjectTypeName(this.type.getFullyQualifiedClassName() + '$' + simpleInnerClassName));
        }
    }

    @Internal
    public static final class JavaWildcardTypeBuilder<OWNER extends HasDescription>
    implements JavaTypeBuilder<OWNER> {
        private final List<JavaTypeCreationProcess<OWNER>> lowerBoundCreationProcesses = new ArrayList<JavaTypeCreationProcess<OWNER>>();
        private final List<JavaTypeCreationProcess<OWNER>> upperBoundCreationProcesses = new ArrayList<JavaTypeCreationProcess<OWNER>>();
        private OWNER owner;
        private Iterable<JavaTypeVariable<?>> allTypeParametersInContext;
        private ImportedClasses importedClasses;

        JavaWildcardTypeBuilder() {
        }

        public JavaWildcardTypeBuilder<OWNER> addLowerBound(JavaTypeCreationProcess<OWNER> boundCreationProcess) {
            this.lowerBoundCreationProcesses.add(boundCreationProcess);
            return this;
        }

        public JavaWildcardTypeBuilder<OWNER> addUpperBound(JavaTypeCreationProcess<OWNER> boundCreationProcess) {
            this.upperBoundCreationProcesses.add(boundCreationProcess);
            return this;
        }

        @Override
        public JavaWildcardType build(OWNER owner, Iterable<JavaTypeVariable<?>> allTypeParametersInContext, ImportedClasses importedClasses) {
            this.owner = owner;
            this.allTypeParametersInContext = allTypeParametersInContext;
            this.importedClasses = importedClasses;
            return DomainObjectCreationContext.createWildcardType(this);
        }

        public List<JavaType> getUpperBounds() {
            return DomainBuilders.buildJavaTypes(this.upperBoundCreationProcesses, this.owner, this.allTypeParametersInContext, this.importedClasses);
        }

        public List<JavaType> getLowerBounds() {
            return DomainBuilders.buildJavaTypes(this.lowerBoundCreationProcesses, this.owner, this.allTypeParametersInContext, this.importedClasses);
        }

        public JavaClass getUnboundErasureType(List<JavaType> upperBounds) {
            return DomainBuilders.getUnboundErasureType(upperBounds, this.importedClasses);
        }
    }

    static interface JavaTypeBuilder<OWNER extends HasDescription> {
        public JavaType build(OWNER var1, Iterable<JavaTypeVariable<?>> var2, ImportedClasses var3);
    }

    static class JavaCodeUnitTypeParametersBuilder
    extends AbstractTypeParametersBuilder<JavaCodeUnit> {
        JavaCodeUnitTypeParametersBuilder(List<JavaTypeParameterBuilder<JavaCodeUnit>> typeParameterBuilders) {
            super(typeParameterBuilders);
        }

        @Override
        Set<JavaTypeVariable<?>> typeParametersFromEnclosingContextOf(JavaCodeUnit codeUnit) {
            return DomainBuilders.allTypeParametersInEnclosingContextOf(codeUnit);
        }
    }

    static class JavaClassTypeParametersBuilder
    extends AbstractTypeParametersBuilder<JavaClass> {
        JavaClassTypeParametersBuilder(List<JavaTypeParameterBuilder<JavaClass>> typeParameterBuilders) {
            super(typeParameterBuilders);
        }

        @Override
        Set<JavaTypeVariable<?>> typeParametersFromEnclosingContextOf(JavaClass javaClass) {
            return DomainBuilders.allTypeParametersInEnclosingContextOf(javaClass);
        }
    }

    private static abstract class AbstractTypeParametersBuilder<OWNER extends HasDescription> {
        private final List<JavaTypeParameterBuilder<OWNER>> typeParameterBuilders;

        AbstractTypeParametersBuilder(List<JavaTypeParameterBuilder<OWNER>> typeParameterBuilders) {
            this.typeParameterBuilders = typeParameterBuilders;
        }

        final List<JavaTypeVariable<OWNER>> build(OWNER owner, ImportedClasses ImportedClasses2) {
            if (this.typeParameterBuilders.isEmpty()) {
                return Collections.emptyList();
            }
            LinkedHashMap<JavaTypeVariable<OWNER>, JavaTypeParameterBuilder<OWNER>> typeArgumentsToBuilders = new LinkedHashMap<JavaTypeVariable<OWNER>, JavaTypeParameterBuilder<OWNER>>();
            for (JavaTypeParameterBuilder<OWNER> builder : this.typeParameterBuilders) {
                typeArgumentsToBuilders.put(builder.build(owner, ImportedClasses2), builder);
            }
            Sets.SetView<JavaTypeVariable<?>> allGenericParametersInContext = Sets.union(this.typeParametersFromEnclosingContextOf(owner), typeArgumentsToBuilders.keySet());
            for (Map.Entry typeParameterToBuilder : typeArgumentsToBuilders.entrySet()) {
                List<JavaType> upperBounds = ((JavaTypeParameterBuilder)typeParameterToBuilder.getValue()).getUpperBounds(allGenericParametersInContext);
                DomainObjectCreationContext.completeTypeVariable((JavaTypeVariable)typeParameterToBuilder.getKey(), upperBounds);
            }
            return ImmutableList.copyOf(typeArgumentsToBuilders.keySet());
        }

        abstract Set<JavaTypeVariable<?>> typeParametersFromEnclosingContextOf(OWNER var1);
    }

    @Internal
    public static final class JavaTypeParameterBuilder<OWNER extends HasDescription> {
        private final String name;
        private final List<JavaTypeCreationProcess<OWNER>> upperBounds = new ArrayList<JavaTypeCreationProcess<OWNER>>();
        private OWNER owner;
        private ImportedClasses importedClasses;

        JavaTypeParameterBuilder(String name) {
            this.name = Preconditions.checkNotNull(name);
        }

        void addBound(JavaTypeCreationProcess<OWNER> bound) {
            this.upperBounds.add(bound);
        }

        public JavaTypeVariable<OWNER> build(OWNER owner, ImportedClasses importedClasses) {
            this.owner = owner;
            this.importedClasses = importedClasses;
            return DomainObjectCreationContext.createTypeVariable(this.name, owner, this.importedClasses.getOrResolve(Object.class.getName()));
        }

        String getName() {
            return this.name;
        }

        public List<JavaType> getUpperBounds(Iterable<? extends JavaTypeVariable<?>> allGenericParametersInContext) {
            return DomainBuilders.buildJavaTypes(this.upperBounds, this.owner, allGenericParametersInContext, this.importedClasses);
        }
    }

    @Internal
    public static final class JavaStaticInitializerBuilder
    extends JavaCodeUnitBuilder<JavaStaticInitializer, JavaStaticInitializerBuilder> {
        JavaStaticInitializerBuilder() {
            this.withReturnType(Optional.empty(), JavaClassDescriptor.From.name(Void.TYPE.getName()));
            this.withParameterTypes(Collections.emptyList(), Collections.emptyList());
            this.withName("<clinit>");
            this.withDescriptor("()V");
            this.withModifiers(Collections.emptySet());
            this.withThrowsClause(Collections.emptyList());
        }

        @Override
        JavaStaticInitializer construct(JavaStaticInitializerBuilder builder, ImportedClasses importedClasses) {
            return DomainObjectCreationContext.createJavaStaticInitializer(builder);
        }
    }

    @Internal
    public static final class JavaClassBuilder {
        private Optional<SourceDescriptor> sourceDescriptor = Optional.empty();
        private Optional<String> sourceFileName = Optional.empty();
        private JavaClassDescriptor descriptor;
        private boolean isInterface;
        private boolean isEnum;
        private boolean isAnnotation;
        private boolean isRecord;
        private boolean isAnonymousClass;
        private boolean isMemberClass;
        private Set<JavaModifier> modifiers = new HashSet<JavaModifier>();

        JavaClassBuilder() {
        }

        JavaClassBuilder withSourceDescriptor(SourceDescriptor sourceDescriptor) {
            this.sourceDescriptor = Optional.of(sourceDescriptor);
            return this;
        }

        JavaClassBuilder withSourceFileName(String sourceFileName) {
            this.sourceFileName = Optional.of(sourceFileName);
            return this;
        }

        JavaClassBuilder withDescriptor(JavaClassDescriptor descriptor) {
            this.descriptor = descriptor;
            return this;
        }

        JavaClassBuilder withInterface(boolean isInterface) {
            this.isInterface = isInterface;
            return this;
        }

        JavaClassBuilder withAnonymousClass(boolean isAnonymousClass) {
            this.isAnonymousClass = isAnonymousClass;
            return this;
        }

        JavaClassBuilder withMemberClass(boolean isMemberClass) {
            this.isMemberClass = isMemberClass;
            return this;
        }

        JavaClassBuilder withEnum(boolean isEnum) {
            this.isEnum = isEnum;
            return this;
        }

        public JavaClassBuilder withAnnotation(boolean isAnnotation) {
            this.isAnnotation = isAnnotation;
            return this;
        }

        JavaClassBuilder withRecord(boolean isRecord) {
            this.isRecord = isRecord;
            return this;
        }

        JavaClassBuilder withModifiers(Set<JavaModifier> modifiers) {
            this.modifiers = modifiers;
            return this;
        }

        JavaClassBuilder withSimpleName(String simpleName) {
            this.descriptor = this.descriptor.withSimpleClassName(simpleName);
            return this;
        }

        JavaClass build() {
            return DomainObjectCreationContext.createJavaClass(this);
        }

        public Optional<Source> getSource() {
            return this.sourceDescriptor.isPresent() ? Optional.of(DomainObjectCreationContext.createSource(this.sourceDescriptor.get().getUri(), this.sourceFileName, this.sourceDescriptor.get().isMd5InClassSourcesEnabled())) : Optional.empty();
        }

        public JavaClassDescriptor getDescriptor() {
            return this.descriptor;
        }

        public boolean isInterface() {
            return this.isInterface;
        }

        public boolean isEnum() {
            return this.isEnum;
        }

        public boolean isAnnotation() {
            return this.isAnnotation;
        }

        public boolean isRecord() {
            return this.isRecord;
        }

        public boolean isAnonymousClass() {
            return this.isAnonymousClass;
        }

        public boolean isMemberClass() {
            return this.isMemberClass;
        }

        public Set<JavaModifier> getModifiers() {
            return this.modifiers;
        }
    }

    @Internal
    public static final class JavaConstructorBuilder
    extends JavaCodeUnitBuilder<JavaConstructor, JavaConstructorBuilder> {
        JavaConstructorBuilder() {
        }

        @Override
        JavaConstructor construct(JavaConstructorBuilder builder, ImportedClasses importedClasses) {
            return DomainObjectCreationContext.createJavaConstructor(builder);
        }
    }

    @Internal
    public static final class JavaMethodBuilder
    extends JavaCodeUnitBuilder<JavaMethod, JavaMethodBuilder> {
        private static final Function<JavaMethod, Optional<Object>> NO_ANNOTATION_DEFAULT_VALUE = new Function<JavaMethod, Optional<Object>>(){

            @Override
            public Optional<Object> apply(JavaMethod input) {
                return Optional.empty();
            }
        };
        private Function<JavaMethod, Optional<Object>> createAnnotationDefaultValue = NO_ANNOTATION_DEFAULT_VALUE;

        JavaMethodBuilder() {
        }

        void withAnnotationDefaultValue(Function<JavaMethod, Optional<Object>> createAnnotationDefaultValue) {
            this.createAnnotationDefaultValue = createAnnotationDefaultValue;
        }

        @Override
        JavaMethod construct(JavaMethodBuilder builder, ImportedClasses importedClasses) {
            return DomainObjectCreationContext.createJavaMethod(builder, this.createAnnotationDefaultValue);
        }
    }

    @Internal
    public static abstract class JavaCodeUnitBuilder<OUTPUT, SELF extends JavaCodeUnitBuilder<OUTPUT, SELF>>
    extends JavaMemberBuilder<OUTPUT, SELF> {
        private Optional<JavaTypeCreationProcess<JavaCodeUnit>> genericReturnType;
        private JavaClassDescriptor rawReturnType;
        private List<JavaTypeCreationProcess<JavaCodeUnit>> genericParameterTypes;
        private List<JavaClassDescriptor> rawParameterTypes;
        private SetMultimap<Integer, JavaAnnotationBuilder> parameterAnnotationsByIndex;
        private JavaCodeUnitTypeParametersBuilder typeParametersBuilder;
        private List<JavaClassDescriptor> throwsDeclarations;
        private final Set<RawReferencedClassObject> rawReferencedClassObjects = new HashSet<RawReferencedClassObject>();
        private final List<RawInstanceofCheck> instanceOfChecks = new ArrayList<RawInstanceofCheck>();

        private JavaCodeUnitBuilder() {
        }

        SELF withReturnType(Optional<JavaTypeCreationProcess<JavaCodeUnit>> genericReturnType, JavaClassDescriptor rawReturnType) {
            this.genericReturnType = genericReturnType;
            this.rawReturnType = rawReturnType;
            return (SELF)((JavaCodeUnitBuilder)this.self());
        }

        SELF withParameterTypes(List<JavaTypeCreationProcess<JavaCodeUnit>> genericParameterTypes, List<JavaClassDescriptor> rawParameterTypes) {
            this.genericParameterTypes = genericParameterTypes;
            this.rawParameterTypes = rawParameterTypes;
            return (SELF)((JavaCodeUnitBuilder)this.self());
        }

        SELF withParameterAnnotations(SetMultimap<Integer, JavaAnnotationBuilder> parameterAnnotationsByIndex) {
            this.parameterAnnotationsByIndex = parameterAnnotationsByIndex;
            return (SELF)((JavaCodeUnitBuilder)this.self());
        }

        SELF withTypeParameters(List<JavaTypeParameterBuilder<JavaCodeUnit>> typeParameterBuilders) {
            this.typeParametersBuilder = new JavaCodeUnitTypeParametersBuilder(typeParameterBuilders);
            return (SELF)((JavaCodeUnitBuilder)this.self());
        }

        SELF withThrowsClause(List<JavaClassDescriptor> throwsDeclarations) {
            this.throwsDeclarations = throwsDeclarations;
            return (SELF)((JavaCodeUnitBuilder)this.self());
        }

        SELF addReferencedClassObject(RawReferencedClassObject rawReferencedClassObject) {
            this.rawReferencedClassObjects.add(rawReferencedClassObject);
            return (SELF)((JavaCodeUnitBuilder)this.self());
        }

        SELF addInstanceOfCheck(RawInstanceofCheck rawInstanceOfChecks) {
            this.instanceOfChecks.add(rawInstanceOfChecks);
            return (SELF)((JavaCodeUnitBuilder)this.self());
        }

        List<String> getParameterTypeNames() {
            ImmutableList.Builder result = ImmutableList.builder();
            for (JavaClassDescriptor parameter : this.rawParameterTypes) {
                result.add(parameter.getFullyQualifiedClassName());
            }
            return result.build();
        }

        String getReturnTypeName() {
            return this.rawReturnType.getFullyQualifiedClassName();
        }

        boolean hasNoParameters() {
            return this.rawParameterTypes.isEmpty();
        }

        public JavaType getReturnType(JavaCodeUnit codeUnit) {
            return this.genericReturnType.isPresent() ? this.genericReturnType.get().finish(codeUnit, this.allTypeParametersInContextOf(codeUnit), this.importedClasses) : this.get(this.rawReturnType.getFullyQualifiedClassName());
        }

        private Iterable<JavaTypeVariable<?>> allTypeParametersInContextOf(JavaCodeUnit codeUnit) {
            return FluentIterable.from(DomainBuilders.getTypeParametersOf(codeUnit)).append(DomainBuilders.allTypeParametersInEnclosingContextOf(codeUnit));
        }

        public List<JavaClass> getRawParameterTypes() {
            return this.asJavaClasses(this.rawParameterTypes);
        }

        public List<JavaType> getGenericParameterTypes(JavaCodeUnit codeUnit) {
            return this.build(this.genericParameterTypes, codeUnit);
        }

        private List<JavaType> build(List<JavaTypeCreationProcess<JavaCodeUnit>> genericParameterTypeBuilders, JavaCodeUnit codeUnit) {
            ImmutableList.Builder result = ImmutableList.builder();
            for (JavaTypeCreationProcess<JavaCodeUnit> parameterTypeBuilder : genericParameterTypeBuilders) {
                result.add(parameterTypeBuilder.finish(codeUnit, this.allTypeParametersInContextOf(codeUnit), this.importedClasses));
            }
            return result.build();
        }

        public Set<JavaAnnotationBuilder> getParameterAnnotations(int index) {
            return this.parameterAnnotationsByIndex.get(index);
        }

        public List<JavaTypeVariable<JavaCodeUnit>> getTypeParameters(JavaCodeUnit owner) {
            return this.typeParametersBuilder.build(owner, this.importedClasses);
        }

        public <CODE_UNIT extends JavaCodeUnit> ThrowsClause<CODE_UNIT> getThrowsClause(CODE_UNIT codeUnit) {
            return DomainObjectCreationContext.createThrowsClause(codeUnit, this.asJavaClasses(this.throwsDeclarations));
        }

        public Set<ReferencedClassObject> getReferencedClassObjects(JavaCodeUnit codeUnit) {
            ImmutableSet.Builder result = ImmutableSet.builder();
            for (RawReferencedClassObject rawReferencedClassObject : this.rawReferencedClassObjects) {
                result.add(DomainObjectCreationContext.createReferencedClassObject(codeUnit, this.get(rawReferencedClassObject.getClassName()), rawReferencedClassObject.getLineNumber()));
            }
            return result.build();
        }

        public Set<InstanceofCheck> getInstanceofChecks(JavaCodeUnit codeUnit) {
            ImmutableSet.Builder result = ImmutableSet.builder();
            for (RawInstanceofCheck instanceOfCheck : this.instanceOfChecks) {
                result.add(DomainObjectCreationContext.createInstanceofCheck(codeUnit, this.get(instanceOfCheck.getTarget().getFullyQualifiedClassName()), instanceOfCheck.getLineNumber()));
            }
            return result.build();
        }

        private List<JavaClass> asJavaClasses(List<JavaClassDescriptor> descriptors) {
            ImmutableList.Builder result = ImmutableList.builder();
            for (JavaClassDescriptor javaClassDescriptor : descriptors) {
                result.add(this.get(javaClassDescriptor.getFullyQualifiedClassName()));
            }
            return result.build();
        }

        public ParameterAnnotationsBuilder getParameterAnnotationsBuilder(int index) {
            return new ParameterAnnotationsBuilder(this.parameterAnnotationsByIndex.get(index), this.importedClasses);
        }

        public Iterable<JavaAnnotationBuilder> getParameterAnnotationBuilders() {
            return this.parameterAnnotationsByIndex.values();
        }

        @Internal
        public static class ParameterAnnotationsBuilder {
            private final Iterable<JavaAnnotationBuilder> annotationBuilders;
            private final ImportedClasses importedClasses;

            private ParameterAnnotationsBuilder(Iterable<JavaAnnotationBuilder> annotationBuilders, ImportedClasses importedClasses) {
                this.annotationBuilders = annotationBuilders;
                this.importedClasses = importedClasses;
            }

            public Set<JavaAnnotation<JavaParameter>> build(JavaParameter owner) {
                ImmutableSet.Builder result = ImmutableSet.builder();
                for (JavaAnnotationBuilder annotationBuilder : this.annotationBuilders) {
                    result.add(annotationBuilder.build(owner, this.importedClasses));
                }
                return result.build();
            }
        }
    }

    @Internal
    public static final class JavaFieldBuilder
    extends JavaMemberBuilder<JavaField, JavaFieldBuilder> {
        private Optional<JavaTypeCreationProcess<JavaField>> genericType;
        private JavaClassDescriptor rawType;

        JavaFieldBuilder() {
        }

        JavaFieldBuilder withType(Optional<JavaTypeCreationProcess<JavaField>> genericTypeBuilder, JavaClassDescriptor rawType) {
            this.genericType = Preconditions.checkNotNull(genericTypeBuilder);
            this.rawType = Preconditions.checkNotNull(rawType);
            return (JavaFieldBuilder)this.self();
        }

        String getTypeName() {
            return this.rawType.getFullyQualifiedClassName();
        }

        public JavaType getType(JavaField field) {
            return this.genericType.isPresent() ? this.genericType.get().finish(field, JavaFieldBuilder.allTypeParametersInContextOf(field.getOwner()), this.importedClasses) : this.importedClasses.getOrResolve(this.rawType.getFullyQualifiedClassName());
        }

        private static Iterable<JavaTypeVariable<?>> allTypeParametersInContextOf(JavaClass javaClass) {
            return FluentIterable.from(DomainBuilders.getTypeParametersOf(javaClass)).append(DomainBuilders.allTypeParametersInEnclosingContextOf(javaClass));
        }

        @Override
        JavaField construct(JavaFieldBuilder builder, ImportedClasses importedClasses) {
            return DomainObjectCreationContext.createJavaField(builder);
        }
    }

    @Internal
    public static abstract class JavaMemberBuilder<OUTPUT, SELF extends JavaMemberBuilder<OUTPUT, SELF>>
    implements BuilderWithBuildParameter<JavaClass, OUTPUT> {
        private String name;
        private String descriptor;
        private Set<JavaModifier> modifiers;
        private JavaClass owner;
        ImportedClasses importedClasses;
        private int firstLineNumber;

        private JavaMemberBuilder() {
        }

        SELF withName(String name) {
            this.name = name;
            return this.self();
        }

        SELF withDescriptor(String descriptor) {
            this.descriptor = descriptor;
            return this.self();
        }

        SELF withModifiers(Set<JavaModifier> modifiers) {
            this.modifiers = modifiers;
            return this.self();
        }

        void recordLineNumber(int lineNumber) {
            this.firstLineNumber = this.firstLineNumber == 0 ? lineNumber : Math.min(this.firstLineNumber, lineNumber);
        }

        SELF self() {
            return (SELF)this;
        }

        abstract OUTPUT construct(SELF var1, ImportedClasses var2);

        JavaClass get(String typeName) {
            return this.importedClasses.getOrResolve(typeName);
        }

        public String getName() {
            return this.name;
        }

        public String getDescriptor() {
            return this.descriptor;
        }

        public Set<JavaModifier> getModifiers() {
            return this.modifiers;
        }

        public JavaClass getOwner() {
            return this.owner;
        }

        public int getFirstLineNumber() {
            return this.firstLineNumber;
        }

        @Override
        public final OUTPUT build(JavaClass owner, ImportedClasses importedClasses) {
            this.owner = owner;
            this.importedClasses = importedClasses;
            return this.construct(this.self(), importedClasses);
        }
    }

    @Internal
    public static final class JavaEnumConstantBuilder {
        private JavaClass declaringClass;
        private String name;

        JavaEnumConstantBuilder() {
        }

        JavaEnumConstantBuilder withDeclaringClass(JavaClass declaringClass) {
            this.declaringClass = declaringClass;
            return this;
        }

        JavaEnumConstantBuilder withName(String name) {
            this.name = name;
            return this;
        }

        public JavaClass getDeclaringClass() {
            return this.declaringClass;
        }

        public String getName() {
            return this.name;
        }

        JavaEnumConstant build() {
            return DomainObjectCreationContext.createJavaEnumConstant(this);
        }
    }
}

