/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.importer;

import com.tngtech.archunit.base.Function;
import com.tngtech.archunit.base.HasDescription;
import com.tngtech.archunit.base.Optional;
import com.tngtech.archunit.core.domain.AccessTarget;
import com.tngtech.archunit.core.domain.DomainObjectCreationContext;
import com.tngtech.archunit.core.domain.ImportContext;
import com.tngtech.archunit.core.domain.JavaAnnotation;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.core.domain.JavaCodeUnit;
import com.tngtech.archunit.core.domain.JavaConstructor;
import com.tngtech.archunit.core.domain.JavaConstructorCall;
import com.tngtech.archunit.core.domain.JavaField;
import com.tngtech.archunit.core.domain.JavaFieldAccess;
import com.tngtech.archunit.core.domain.JavaMember;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.core.domain.JavaMethodCall;
import com.tngtech.archunit.core.domain.JavaStaticInitializer;
import com.tngtech.archunit.core.domain.JavaType;
import com.tngtech.archunit.core.domain.JavaTypeVariable;
import com.tngtech.archunit.core.importer.AccessRecord;
import com.tngtech.archunit.core.importer.ClassFileImportRecord;
import com.tngtech.archunit.core.importer.DomainBuilders;
import com.tngtech.archunit.core.importer.ImportedClasses;
import com.tngtech.archunit.core.importer.RawAccessRecord;
import com.tngtech.archunit.core.importer.resolvers.ClassResolver;
import com.tngtech.archunit.thirdparty.com.google.common.collect.HashMultimap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Multimap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.SetMultimap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ClassGraphCreator
implements ImportContext {
    private final ImportedClasses classes;
    private final ClassFileImportRecord importRecord;
    private final SetMultimap<JavaCodeUnit, AccessRecord.FieldAccessRecord> processedFieldAccessRecords = HashMultimap.create();
    private final SetMultimap<JavaCodeUnit, AccessRecord<AccessTarget.MethodCallTarget>> processedMethodCallRecords = HashMultimap.create();
    private final SetMultimap<JavaCodeUnit, AccessRecord<AccessTarget.ConstructorCallTarget>> processedConstructorCallRecords = HashMultimap.create();
    private final Function<JavaClass, Set<String>> superclassStrategy;
    private final Function<JavaClass, Set<String>> interfaceStrategy;

    ClassGraphCreator(ClassFileImportRecord importRecord, ClassResolver classResolver) {
        this.importRecord = importRecord;
        this.classes = new ImportedClasses(importRecord.getClasses(), classResolver, new ImportedClasses.MethodReturnTypeGetter(){

            @Override
            public Optional<JavaClass> getReturnType(String declaringClassName, String methodName) {
                return ClassGraphCreator.this.getMethodReturnType(declaringClassName, methodName);
            }
        });
        this.superclassStrategy = this.createSuperclassStrategy();
        this.interfaceStrategy = this.createInterfaceStrategy();
    }

    private Function<JavaClass, Set<String>> createSuperclassStrategy() {
        return new Function<JavaClass, Set<String>>(){

            @Override
            public Set<String> apply(JavaClass input) {
                return ClassGraphCreator.this.importRecord.getSuperclassFor(input.getName()).asSet();
            }
        };
    }

    private Function<JavaClass, Set<String>> createInterfaceStrategy() {
        return new Function<JavaClass, Set<String>>(){

            @Override
            public Set<String> apply(JavaClass input) {
                return ClassGraphCreator.this.importRecord.getInterfaceNamesFor(input.getName());
            }
        };
    }

    JavaClasses complete() {
        this.ensureMemberTypesArePresent();
        this.ensureCallTargetsArePresent();
        this.ensureClassesOfInheritanceHierarchiesArePresent();
        this.ensureMetaAnnotationsArePresent();
        this.completeClasses();
        this.completeAccesses();
        return DomainObjectCreationContext.createJavaClasses(this.classes.getDirectlyImported(), this.classes.getAllWithOuterClassesSortedBeforeInnerClasses(), this);
    }

    private void ensureMemberTypesArePresent() {
        for (String typeName : this.importRecord.getMemberSignatureTypeNames()) {
            this.classes.ensurePresent(typeName);
        }
    }

    private void ensureCallTargetsArePresent() {
        for (RawAccessRecord record : this.importRecord.getAccessRecords()) {
            this.classes.ensurePresent(record.target.owner.getFullyQualifiedClassName());
        }
    }

    private void ensureClassesOfInheritanceHierarchiesArePresent() {
        for (String superclassName : this.importRecord.getAllSuperclassNames()) {
            this.resolveInheritance(superclassName, this.superclassStrategy);
        }
        for (String superinterfaceName : this.importRecord.getAllSuperinterfaceNames()) {
            this.resolveInheritance(superinterfaceName, this.interfaceStrategy);
        }
    }

    private void resolveInheritance(String currentTypeName, Function<JavaClass, Set<String>> inheritanceStrategy) {
        for (String parent : inheritanceStrategy.apply(this.classes.getOrResolve(currentTypeName))) {
            this.resolveInheritance(parent, inheritanceStrategy);
        }
    }

    private void completeClasses() {
        for (JavaClass javaClass : this.classes.getAllWithOuterClassesSortedBeforeInnerClasses()) {
            DomainObjectCreationContext.completeClassHierarchy(javaClass, this);
            DomainObjectCreationContext.completeEnclosingDeclaration(javaClass, this);
            DomainObjectCreationContext.completeTypeParameters(javaClass, this);
            DomainObjectCreationContext.completeGenericSuperclass(javaClass, this);
            DomainObjectCreationContext.completeGenericInterfaces(javaClass, this);
            DomainObjectCreationContext.completeMembers(javaClass, this);
            DomainObjectCreationContext.completeAnnotations(javaClass, this);
        }
    }

    private void completeAccesses() {
        for (RawAccessRecord.ForField fieldAccessRecord : this.importRecord.getRawFieldAccessRecords()) {
            this.tryProcess(fieldAccessRecord, AccessRecord.Factory.forFieldAccessRecord(), this.processedFieldAccessRecords);
        }
        for (RawAccessRecord methodCallRecord : this.importRecord.getRawMethodCallRecords()) {
            this.tryProcess(methodCallRecord, AccessRecord.Factory.forMethodCallRecord(), this.processedMethodCallRecords);
        }
        for (RawAccessRecord constructorCallRecord : this.importRecord.getRawConstructorCallRecords()) {
            this.tryProcess(constructorCallRecord, AccessRecord.Factory.forConstructorCallRecord(), this.processedConstructorCallRecords);
        }
    }

    private void ensureMetaAnnotationsArePresent() {
        for (JavaClass javaClass : this.classes.getAllWithOuterClassesSortedBeforeInnerClasses()) {
            this.resolveAnnotationHierarchy(javaClass);
        }
    }

    private void resolveAnnotationHierarchy(JavaClass javaClass) {
        for (String annotationTypeName : this.getAnnotationTypeNamesToResolveFor(javaClass)) {
            boolean hadBeenPreviouslyResolved = this.classes.isPresent(annotationTypeName);
            JavaClass annotationType = this.classes.getOrResolve(annotationTypeName);
            if (hadBeenPreviouslyResolved) continue;
            this.resolveAnnotationHierarchy(annotationType);
        }
    }

    private Set<String> getAnnotationTypeNamesToResolveFor(JavaClass javaClass) {
        return ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(this.importRecord.getAnnotationTypeNamesFor(javaClass))).addAll(this.importRecord.getMemberAnnotationTypeNamesFor(javaClass))).addAll(this.importRecord.getParameterAnnotationTypeNamesFor(javaClass))).build();
    }

    private <T extends AccessRecord<?>, B extends RawAccessRecord> void tryProcess(B rawRecord, AccessRecord.Factory<B, T> factory, Multimap<JavaCodeUnit, T> processedAccessRecords) {
        AccessRecord processed = (AccessRecord)factory.create(rawRecord, this.classes);
        processedAccessRecords.put(processed.getCaller(), processed);
    }

    @Override
    public Set<JavaFieldAccess> createFieldAccessesFor(JavaCodeUnit codeUnit) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (AccessRecord.FieldAccessRecord record : this.processedFieldAccessRecords.get(codeUnit)) {
            result.add(this.accessBuilderFrom(new DomainBuilders.JavaFieldAccessBuilder(), record).withAccessType(record.getAccessType()).build());
        }
        return result.build();
    }

    @Override
    public Set<JavaMethodCall> createMethodCallsFor(JavaCodeUnit codeUnit) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (AccessRecord<AccessTarget.MethodCallTarget> record : this.processedMethodCallRecords.get(codeUnit)) {
            result.add(this.accessBuilderFrom(new DomainBuilders.JavaMethodCallBuilder(), record).build());
        }
        return result.build();
    }

    @Override
    public Set<JavaConstructorCall> createConstructorCallsFor(JavaCodeUnit codeUnit) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (AccessRecord<AccessTarget.ConstructorCallTarget> record : this.processedConstructorCallRecords.get(codeUnit)) {
            result.add(this.accessBuilderFrom(new DomainBuilders.JavaConstructorCallBuilder(), record).build());
        }
        return result.build();
    }

    private <T extends AccessTarget, B extends DomainBuilders.JavaAccessBuilder<T, B>> B accessBuilderFrom(B builder, AccessRecord<T> record) {
        return ((DomainBuilders.JavaAccessBuilder)((DomainBuilders.JavaAccessBuilder)builder.withOrigin(record.getCaller())).withTarget(record.getTarget())).withLineNumber(record.getLineNumber());
    }

    @Override
    public Optional<JavaClass> createSuperclass(JavaClass owner) {
        Optional<String> superclassName = this.importRecord.getSuperclassFor(owner.getName());
        return superclassName.isPresent() ? Optional.of(this.classes.getOrResolve(superclassName.get())) : Optional.empty();
    }

    @Override
    public Optional<JavaType> createGenericSuperclass(JavaClass owner) {
        Optional<DomainBuilders.JavaParameterizedTypeBuilder<JavaClass>> genericSuperclassBuilder = this.importRecord.getGenericSuperclassFor(owner);
        return genericSuperclassBuilder.isPresent() ? Optional.of(genericSuperclassBuilder.get().build(owner, ClassGraphCreator.getTypeParametersInContextOf(owner), this.classes)) : Optional.empty();
    }

    @Override
    public Optional<Set<JavaType>> createGenericInterfaces(JavaClass owner) {
        Optional<Set<DomainBuilders.JavaParameterizedTypeBuilder<JavaClass>>> genericInterfaceBuilders = this.importRecord.getGenericInterfacesFor(owner);
        if (!genericInterfaceBuilders.isPresent()) {
            return Optional.empty();
        }
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (DomainBuilders.JavaParameterizedTypeBuilder<JavaClass> builder : genericInterfaceBuilders.get()) {
            result.add(builder.build(owner, ClassGraphCreator.getTypeParametersInContextOf(owner), this.classes));
        }
        return Optional.of(result.build());
    }

    private static Iterable<JavaTypeVariable<?>> getTypeParametersInContextOf(JavaClass javaClass) {
        HashSet<JavaTypeVariable<?>> result = Sets.newHashSet(javaClass.getTypeParameters());
        while (javaClass.getEnclosingClass().isPresent()) {
            javaClass = javaClass.getEnclosingClass().get();
            result.addAll(javaClass.getTypeParameters());
        }
        return result;
    }

    @Override
    public Set<JavaClass> createInterfaces(JavaClass owner) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (String interfaceName : this.importRecord.getInterfaceNamesFor(owner.getName())) {
            result.add(this.classes.getOrResolve(interfaceName));
        }
        return result.build();
    }

    @Override
    public List<JavaTypeVariable<JavaClass>> createTypeParameters(JavaClass owner) {
        DomainBuilders.JavaClassTypeParametersBuilder typeParametersBuilder = this.importRecord.getTypeParameterBuildersFor(owner.getName());
        return typeParametersBuilder.build(owner, this.classes);
    }

    @Override
    public Set<JavaField> createFields(JavaClass owner) {
        return DomainBuilders.BuilderWithBuildParameter.BuildFinisher.build(this.importRecord.getFieldBuildersFor(owner.getName()), owner, this.classes);
    }

    @Override
    public Set<JavaMethod> createMethods(JavaClass owner) {
        Set<DomainBuilders.JavaMethodBuilder> methodBuilders = this.importRecord.getMethodBuildersFor(owner.getName());
        if (owner.isAnnotation()) {
            for (DomainBuilders.JavaMethodBuilder methodBuilder : methodBuilders) {
                methodBuilder.withAnnotationDefaultValue(new Function<JavaMethod, Optional<Object>>(){

                    @Override
                    public Optional<Object> apply(JavaMethod method) {
                        Optional<DomainBuilders.JavaAnnotationBuilder.ValueBuilder> defaultValueBuilder = ClassGraphCreator.this.importRecord.getAnnotationDefaultValueBuilderFor(method);
                        return defaultValueBuilder.isPresent() ? defaultValueBuilder.get().build(method, ClassGraphCreator.this.classes) : Optional.empty();
                    }
                });
            }
        }
        return DomainBuilders.BuilderWithBuildParameter.BuildFinisher.build(methodBuilders, owner, this.classes);
    }

    @Override
    public Set<JavaConstructor> createConstructors(JavaClass owner) {
        return DomainBuilders.BuilderWithBuildParameter.BuildFinisher.build(this.importRecord.getConstructorBuildersFor(owner.getName()), owner, this.classes);
    }

    @Override
    public Optional<JavaStaticInitializer> createStaticInitializer(JavaClass owner) {
        Optional<DomainBuilders.JavaStaticInitializerBuilder> builder = this.importRecord.getStaticInitializerBuilderFor(owner.getName());
        if (!builder.isPresent()) {
            return Optional.empty();
        }
        JavaStaticInitializer staticInitializer = (JavaStaticInitializer)builder.get().build(owner, this.classes);
        return Optional.of(staticInitializer);
    }

    @Override
    public Map<String, JavaAnnotation<JavaClass>> createAnnotations(JavaClass owner) {
        return this.createAnnotations(owner, this.importRecord.getAnnotationsFor(owner));
    }

    @Override
    public Map<String, JavaAnnotation<JavaMember>> createAnnotations(JavaMember owner) {
        return this.createAnnotations(owner, this.importRecord.getAnnotationsFor(owner));
    }

    private <OWNER extends HasDescription> Map<String, JavaAnnotation<OWNER>> createAnnotations(OWNER owner, Set<DomainBuilders.JavaAnnotationBuilder> annotationBuilders) {
        return DomainBuilders.buildAnnotations(owner, annotationBuilders, this.classes);
    }

    @Override
    public Optional<JavaClass> createEnclosingClass(JavaClass owner) {
        Optional<String> enclosingClassName = this.importRecord.getEnclosingClassFor(owner.getName());
        return enclosingClassName.isPresent() ? Optional.of(this.classes.getOrResolve(enclosingClassName.get())) : Optional.empty();
    }

    @Override
    public Optional<JavaCodeUnit> createEnclosingCodeUnit(JavaClass owner) {
        Optional<RawAccessRecord.CodeUnit> enclosingCodeUnit = this.importRecord.getEnclosingCodeUnitFor(owner.getName());
        if (!enclosingCodeUnit.isPresent()) {
            return Optional.empty();
        }
        RawAccessRecord.CodeUnit codeUnit = enclosingCodeUnit.get();
        JavaClass enclosingClass = this.classes.getOrResolve(codeUnit.getDeclaringClassName());
        return enclosingClass.tryGetCodeUnitWithParameterTypeNames(codeUnit.getName(), codeUnit.getParameters());
    }

    @Override
    public JavaClass resolveClass(String fullyQualifiedClassName) {
        return this.classes.getOrResolve(fullyQualifiedClassName);
    }

    private Optional<JavaClass> getMethodReturnType(String declaringClassName, String methodName) {
        for (DomainBuilders.JavaMethodBuilder methodBuilder : this.importRecord.getMethodBuildersFor(declaringClassName)) {
            if (!methodBuilder.getName().equals(methodName) || !methodBuilder.hasNoParameters()) continue;
            return Optional.of(this.classes.getOrResolve(methodBuilder.getReturnTypeName()));
        }
        return Optional.empty();
    }
}

