/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.importer;

import com.tngtech.archunit.base.Optional;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaMember;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.core.importer.DomainBuilders;
import com.tngtech.archunit.core.importer.RawAccessRecord;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.collect.HashMultimap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Iterables;
import com.tngtech.archunit.thirdparty.com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class ClassFileImportRecord {
    private static final DomainBuilders.JavaClassTypeParametersBuilder NO_TYPE_PARAMETERS = new DomainBuilders.JavaClassTypeParametersBuilder(Collections.emptyList());
    private final Map<String, JavaClass> classes = new HashMap<String, JavaClass>();
    private final Map<String, String> superclassNamesByOwner = new HashMap<String, String>();
    private final SetMultimap<String, String> interfaceNamesByOwner = HashMultimap.create();
    private final Map<String, DomainBuilders.JavaClassTypeParametersBuilder> typeParametersBuilderByOwner = new HashMap<String, DomainBuilders.JavaClassTypeParametersBuilder>();
    private final Map<String, DomainBuilders.JavaParameterizedTypeBuilder<JavaClass>> genericSuperclassBuilderByOwner = new HashMap<String, DomainBuilders.JavaParameterizedTypeBuilder<JavaClass>>();
    private final Map<String, Set<DomainBuilders.JavaParameterizedTypeBuilder<JavaClass>>> genericInterfaceBuildersByOwner = new HashMap<String, Set<DomainBuilders.JavaParameterizedTypeBuilder<JavaClass>>>();
    private final SetMultimap<String, DomainBuilders.JavaFieldBuilder> fieldBuildersByOwner = HashMultimap.create();
    private final SetMultimap<String, DomainBuilders.JavaMethodBuilder> methodBuildersByOwner = HashMultimap.create();
    private final SetMultimap<String, DomainBuilders.JavaConstructorBuilder> constructorBuildersByOwner = HashMultimap.create();
    private final Map<String, DomainBuilders.JavaStaticInitializerBuilder> staticInitializerBuildersByOwner = new HashMap<String, DomainBuilders.JavaStaticInitializerBuilder>();
    private final SetMultimap<String, DomainBuilders.JavaAnnotationBuilder> annotationsByOwner = HashMultimap.create();
    private final Map<String, DomainBuilders.JavaAnnotationBuilder.ValueBuilder> annotationDefaultValuesByOwner = new HashMap<String, DomainBuilders.JavaAnnotationBuilder.ValueBuilder>();
    private final EnclosingDeclarationsByInnerClasses enclosingDeclarationsByOwner = new EnclosingDeclarationsByInnerClasses();
    private final Set<RawAccessRecord.ForField> rawFieldAccessRecords = new HashSet<RawAccessRecord.ForField>();
    private final Set<RawAccessRecord> rawMethodCallRecords = new HashSet<RawAccessRecord>();
    private final Set<RawAccessRecord> rawConstructorCallRecords = new HashSet<RawAccessRecord>();

    ClassFileImportRecord() {
    }

    void setSuperclass(String ownerName, String superclassName) {
        Preconditions.checkState(!this.superclassNamesByOwner.containsKey(ownerName), "Attempted to add %s as a second superclass to %s, this is most likely a bug", (Object)superclassName, (Object)ownerName);
        this.superclassNamesByOwner.put(ownerName, superclassName);
    }

    void addInterfaces(String ownerName, Set<String> interfaceNames) {
        this.interfaceNamesByOwner.putAll(ownerName, interfaceNames);
    }

    void addTypeParameters(String ownerName, DomainBuilders.JavaClassTypeParametersBuilder builder) {
        this.typeParametersBuilderByOwner.put(ownerName, builder);
    }

    void addGenericSuperclass(String ownerName, DomainBuilders.JavaParameterizedTypeBuilder<JavaClass> genericSuperclassBuilder) {
        this.genericSuperclassBuilderByOwner.put(ownerName, genericSuperclassBuilder);
    }

    public void addGenericInterfaces(String ownerName, Set<DomainBuilders.JavaParameterizedTypeBuilder<JavaClass>> genericInterfaceBuilders) {
        this.genericInterfaceBuildersByOwner.put(ownerName, genericInterfaceBuilders);
    }

    void addField(String ownerName, DomainBuilders.JavaFieldBuilder fieldBuilder) {
        this.fieldBuildersByOwner.put(ownerName, fieldBuilder);
    }

    void addMethod(String ownerName, DomainBuilders.JavaMethodBuilder methodBuilder) {
        this.methodBuildersByOwner.put(ownerName, methodBuilder);
    }

    void addConstructor(String ownerName, DomainBuilders.JavaConstructorBuilder constructorBuilder) {
        this.constructorBuildersByOwner.put(ownerName, constructorBuilder);
    }

    void setStaticInitializer(String ownerName, DomainBuilders.JavaStaticInitializerBuilder builder) {
        Preconditions.checkState(!this.staticInitializerBuildersByOwner.containsKey(ownerName), "Tried to add a second static initializer to %s, this is most likely a bug", (Object)ownerName);
        this.staticInitializerBuildersByOwner.put(ownerName, builder);
    }

    void addClassAnnotations(String ownerName, Set<DomainBuilders.JavaAnnotationBuilder> annotations) {
        this.annotationsByOwner.putAll(ownerName, annotations);
    }

    void addMemberAnnotations(String declaringClassName, String memberName, String descriptor, Set<DomainBuilders.JavaAnnotationBuilder> annotations) {
        this.annotationsByOwner.putAll(ClassFileImportRecord.getMemberKey(declaringClassName, memberName, descriptor), annotations);
    }

    void addAnnotationDefaultValue(String declaringClassName, String methodName, String descriptor, DomainBuilders.JavaAnnotationBuilder.ValueBuilder valueBuilder) {
        this.annotationDefaultValuesByOwner.put(ClassFileImportRecord.getMemberKey(declaringClassName, methodName, descriptor), valueBuilder);
    }

    void setEnclosingClass(String ownerName, String enclosingClassName) {
        this.enclosingDeclarationsByOwner.registerEnclosingClass(ownerName, enclosingClassName);
    }

    void setEnclosingCodeUnit(String ownerName, RawAccessRecord.CodeUnit enclosingCodeUnit) {
        this.enclosingDeclarationsByOwner.registerEnclosingCodeUnit(ownerName, enclosingCodeUnit);
    }

    Optional<String> getSuperclassFor(String name) {
        return Optional.ofNullable(this.superclassNamesByOwner.get(name));
    }

    Set<String> getInterfaceNamesFor(String ownerName) {
        return this.interfaceNamesByOwner.get(ownerName);
    }

    DomainBuilders.JavaClassTypeParametersBuilder getTypeParameterBuildersFor(String ownerName) {
        if (!this.typeParametersBuilderByOwner.containsKey(ownerName)) {
            return NO_TYPE_PARAMETERS;
        }
        return this.typeParametersBuilderByOwner.get(ownerName);
    }

    Optional<DomainBuilders.JavaParameterizedTypeBuilder<JavaClass>> getGenericSuperclassFor(JavaClass owner) {
        return Optional.ofNullable(this.genericSuperclassBuilderByOwner.get(owner.getName()));
    }

    Optional<Set<DomainBuilders.JavaParameterizedTypeBuilder<JavaClass>>> getGenericInterfacesFor(JavaClass owner) {
        return Optional.ofNullable(this.genericInterfaceBuildersByOwner.get(owner.getName()));
    }

    Set<String> getMemberSignatureTypeNames() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (DomainBuilders.JavaFieldBuilder fieldBuilder : this.fieldBuildersByOwner.values()) {
            result.add(fieldBuilder.getTypeName());
        }
        for (DomainBuilders.JavaConstructorBuilder constructorBuilder : this.constructorBuildersByOwner.values()) {
            for (String parameterTypeName : constructorBuilder.getParameterTypeNames()) {
                result.add(parameterTypeName);
            }
        }
        for (DomainBuilders.JavaMethodBuilder methodBuilder : this.methodBuildersByOwner.values()) {
            result.add(methodBuilder.getReturnTypeName());
            for (String parameterTypeName : methodBuilder.getParameterTypeNames()) {
                result.add(parameterTypeName);
            }
        }
        return result.build();
    }

    Set<DomainBuilders.JavaFieldBuilder> getFieldBuildersFor(String ownerName) {
        return this.fieldBuildersByOwner.get(ownerName);
    }

    Set<DomainBuilders.JavaMethodBuilder> getMethodBuildersFor(String ownerName) {
        return this.methodBuildersByOwner.get(ownerName);
    }

    Set<DomainBuilders.JavaConstructorBuilder> getConstructorBuildersFor(String ownerName) {
        return this.constructorBuildersByOwner.get(ownerName);
    }

    Optional<DomainBuilders.JavaStaticInitializerBuilder> getStaticInitializerBuilderFor(String ownerName) {
        return Optional.ofNullable(this.staticInitializerBuildersByOwner.get(ownerName));
    }

    Set<String> getAnnotationTypeNamesFor(JavaClass owner) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (DomainBuilders.JavaAnnotationBuilder annotationBuilder : this.annotationsByOwner.get(owner.getName())) {
            result.add(annotationBuilder.getFullyQualifiedClassName());
        }
        return result.build();
    }

    Set<DomainBuilders.JavaAnnotationBuilder> getAnnotationsFor(JavaClass owner) {
        return this.annotationsByOwner.get(owner.getName());
    }

    Set<String> getMemberAnnotationTypeNamesFor(JavaClass owner) {
        Iterable<DomainBuilders.JavaMemberBuilder<?, ?>> memberBuilders = Iterables.concat(this.fieldBuildersByOwner.get(owner.getName()), this.methodBuildersByOwner.get(owner.getName()), this.constructorBuildersByOwner.get(owner.getName()), this.nullToEmpty(this.staticInitializerBuildersByOwner.get(owner.getName())));
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (DomainBuilders.JavaMemberBuilder<?, ?> memberBuilder : memberBuilders) {
            for (DomainBuilders.JavaAnnotationBuilder annotationBuilder : this.annotationsByOwner.get(ClassFileImportRecord.getMemberKey(owner.getName(), memberBuilder.getName(), memberBuilder.getDescriptor()))) {
                result.add(annotationBuilder.getFullyQualifiedClassName());
            }
        }
        return result.build();
    }

    Set<String> getParameterAnnotationTypeNamesFor(JavaClass owner) {
        Iterable<DomainBuilders.JavaConstructorBuilder> codeUnitBuilders = Iterables.concat(this.methodBuildersByOwner.get(owner.getName()), this.constructorBuildersByOwner.get(owner.getName()));
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (DomainBuilders.JavaCodeUnitBuilder javaCodeUnitBuilder : codeUnitBuilders) {
            for (DomainBuilders.JavaAnnotationBuilder annotationBuilder : javaCodeUnitBuilder.getParameterAnnotationBuilders()) {
                result.add(annotationBuilder.getFullyQualifiedClassName());
            }
        }
        return result.build();
    }

    private Iterable<DomainBuilders.JavaMemberBuilder<?, ?>> nullToEmpty(DomainBuilders.JavaStaticInitializerBuilder staticInitializerBuilder) {
        return staticInitializerBuilder != null ? Collections.singleton(staticInitializerBuilder) : Collections.emptySet();
    }

    Set<DomainBuilders.JavaAnnotationBuilder> getAnnotationsFor(JavaMember owner) {
        return this.annotationsByOwner.get(ClassFileImportRecord.getMemberKey(owner));
    }

    Optional<DomainBuilders.JavaAnnotationBuilder.ValueBuilder> getAnnotationDefaultValueBuilderFor(JavaMethod method) {
        return Optional.ofNullable(this.annotationDefaultValuesByOwner.get(ClassFileImportRecord.getMemberKey(method)));
    }

    Optional<String> getEnclosingClassFor(String ownerName) {
        return this.enclosingDeclarationsByOwner.getEnclosingClassName(ownerName);
    }

    Optional<RawAccessRecord.CodeUnit> getEnclosingCodeUnitFor(String ownerName) {
        return this.enclosingDeclarationsByOwner.getEnclosingCodeUnit(ownerName);
    }

    void registerFieldAccess(RawAccessRecord.ForField record) {
        this.rawFieldAccessRecords.add(record);
    }

    void registerMethodCall(RawAccessRecord record) {
        this.rawMethodCallRecords.add(record);
    }

    void registerConstructorCall(RawAccessRecord record) {
        this.rawConstructorCallRecords.add(record);
    }

    Set<RawAccessRecord.ForField> getRawFieldAccessRecords() {
        return ImmutableSet.copyOf(this.rawFieldAccessRecords);
    }

    Set<RawAccessRecord> getRawMethodCallRecords() {
        return ImmutableSet.copyOf(this.rawMethodCallRecords);
    }

    Set<RawAccessRecord> getRawConstructorCallRecords() {
        return ImmutableSet.copyOf(this.rawConstructorCallRecords);
    }

    void addAll(Collection<JavaClass> javaClasses) {
        for (JavaClass javaClass : javaClasses) {
            this.classes.put(javaClass.getName(), javaClass);
        }
    }

    Map<String, JavaClass> getClasses() {
        return this.classes;
    }

    Set<RawAccessRecord> getAccessRecords() {
        return ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(this.rawFieldAccessRecords)).addAll(this.rawMethodCallRecords)).addAll(this.rawConstructorCallRecords)).build();
    }

    Set<String> getAllSuperclassNames() {
        return ImmutableSet.copyOf(this.superclassNamesByOwner.values());
    }

    Set<String> getAllSuperinterfaceNames() {
        return ImmutableSet.copyOf(this.interfaceNamesByOwner.values());
    }

    private static String getMemberKey(JavaMember member) {
        return ClassFileImportRecord.getMemberKey(member.getOwner().getName(), member.getName(), member.getDescriptor());
    }

    private static String getMemberKey(String declaringClassName, String methodName, String descriptor) {
        return declaringClassName + "|" + methodName + "|" + descriptor;
    }

    private static class EnclosingDeclarationsByInnerClasses {
        private final Map<String, String> innerClassNameToEnclosingClassName = new HashMap<String, String>();
        private final Map<String, RawAccessRecord.CodeUnit> innerClassNameToEnclosingCodeUnit = new HashMap<String, RawAccessRecord.CodeUnit>();

        private EnclosingDeclarationsByInnerClasses() {
        }

        void registerEnclosingClass(String innerName, String outerName) {
            Preconditions.checkArgument(!this.innerClassNameToEnclosingClassName.containsKey(innerName) || this.innerClassNameToEnclosingClassName.get(innerName).equals(outerName), "Can't register multiple enclosing classes, this is likely a bug!");
            this.innerClassNameToEnclosingClassName.put(innerName, outerName);
        }

        void registerEnclosingCodeUnit(String innerName, RawAccessRecord.CodeUnit codeUnit) {
            Preconditions.checkArgument(!this.innerClassNameToEnclosingCodeUnit.containsKey(innerName) || this.innerClassNameToEnclosingCodeUnit.get(innerName).equals(codeUnit), "Can't register multiple enclosing code units, this is likely a bug!");
            this.innerClassNameToEnclosingCodeUnit.put(innerName, codeUnit);
        }

        Optional<String> getEnclosingClassName(String ownerName) {
            return Optional.ofNullable(this.innerClassNameToEnclosingClassName.get(ownerName));
        }

        Optional<RawAccessRecord.CodeUnit> getEnclosingCodeUnit(String ownerName) {
            return Optional.ofNullable(this.innerClassNameToEnclosingCodeUnit.get(ownerName));
        }
    }
}

