/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.importer;

import com.tngtech.archunit.Internal;
import com.tngtech.archunit.base.Optional;
import com.tngtech.archunit.core.domain.AccessTarget;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaClassDescriptor;
import com.tngtech.archunit.core.domain.JavaCodeUnit;
import com.tngtech.archunit.core.domain.JavaConstructor;
import com.tngtech.archunit.core.domain.JavaField;
import com.tngtech.archunit.core.domain.JavaFieldAccess;
import com.tngtech.archunit.core.domain.JavaMember;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.core.importer.DomainBuilders;
import com.tngtech.archunit.core.importer.ImportedClasses;
import com.tngtech.archunit.core.importer.JavaClassDescriptorImporter;
import com.tngtech.archunit.core.importer.RawAccessRecord;
import com.tngtech.archunit.thirdparty.com.google.common.base.Supplier;
import com.tngtech.archunit.thirdparty.com.google.common.base.Suppliers;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableCollection;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

interface AccessRecord<TARGET extends AccessTarget> {
    public JavaCodeUnit getCaller();

    public TARGET getTarget();

    public int getLineNumber();

    @Internal
    public static abstract class Factory<RAW_RECORD, PROCESSED_RECORD> {
        private static final SignaturePredicate<RawAccessRecord.TargetInfo> FIELD_SIGNATURE_PREDICATE = new SignaturePredicate<RawAccessRecord.TargetInfo>(){

            @Override
            public boolean exists(JavaClass clazz, RawAccessRecord.TargetInfo target) {
                Optional<JavaField> field = clazz.tryGetField(target.name);
                return field.isPresent() && target.desc.equals(field.get().getDescriptor());
            }
        };
        private static final SignaturePredicate<RawAccessRecord.TargetInfo> METHOD_SIGNATURE_PREDICATE = new SignaturePredicate<RawAccessRecord.TargetInfo>(){

            @Override
            public boolean exists(JavaClass clazz, RawAccessRecord.TargetInfo target) {
                for (JavaMethod method : clazz.getMethods()) {
                    if (!method.getName().equals(target.name) || !method.getDescriptor().equals(target.desc)) continue;
                    return true;
                }
                return false;
            }
        };

        abstract PROCESSED_RECORD create(RAW_RECORD var1, ImportedClasses var2);

        static Factory<RawAccessRecord, AccessRecord<AccessTarget.ConstructorCallTarget>> forConstructorCallRecord() {
            return new Factory<RawAccessRecord, AccessRecord<AccessTarget.ConstructorCallTarget>>(){

                @Override
                AccessRecord<AccessTarget.ConstructorCallTarget> create(RawAccessRecord record, ImportedClasses classes) {
                    return new RawConstructorCallRecordProcessed(record, classes);
                }
            };
        }

        static Factory<RawAccessRecord, AccessRecord<AccessTarget.MethodCallTarget>> forMethodCallRecord() {
            return new Factory<RawAccessRecord, AccessRecord<AccessTarget.MethodCallTarget>>(){

                @Override
                AccessRecord<AccessTarget.MethodCallTarget> create(RawAccessRecord record, ImportedClasses classes) {
                    return new RawMethodCallRecordProcessed(record, classes);
                }
            };
        }

        static Factory<RawAccessRecord.ForField, FieldAccessRecord> forFieldAccessRecord() {
            return new Factory<RawAccessRecord.ForField, FieldAccessRecord>(){

                @Override
                FieldAccessRecord create(RawAccessRecord.ForField record, ImportedClasses classes) {
                    return new RawFieldAccessRecordProcessed(record, classes);
                }
            };
        }

        private static Supplier<JavaCodeUnit> createCallerSupplier(final RawAccessRecord.CodeUnit caller, final ImportedClasses classes) {
            return Suppliers.memoize(new Supplier<JavaCodeUnit>(){

                @Override
                public JavaCodeUnit get() {
                    return Factory.getCaller(caller, classes);
                }
            });
        }

        private static JavaCodeUnit getCaller(RawAccessRecord.CodeUnit caller, ImportedClasses classes) {
            for (JavaCodeUnit method : classes.getOrResolve(caller.getDeclaringClassName()).getCodeUnits()) {
                if (!caller.is(method)) continue;
                return method;
            }
            throw new IllegalStateException("Never found a " + JavaCodeUnit.class.getSimpleName() + " that matches supposed caller " + caller);
        }

        private static <MEMBER extends JavaMember, TARGET extends RawAccessRecord.TargetInfo> Set<MEMBER> tryFindMatchingTargets(Set<MEMBER> possibleTargets, TARGET target, SignaturePredicate<TARGET> signaturePredicate) {
            ImmutableSet.Builder result = ImmutableSet.builder();
            for (JavaMember possibleTarget : possibleTargets) {
                if (!Factory.matches(possibleTarget, target, signaturePredicate)) continue;
                result.add(possibleTarget);
            }
            return result.build();
        }

        private static <MEMBER extends JavaMember, TARGET extends RawAccessRecord.TargetInfo> boolean matches(MEMBER member, TARGET target, SignaturePredicate<TARGET> signaturePredicate) {
            if (!target.name.equals(member.getName()) || !target.desc.equals(member.getDescriptor())) {
                return false;
            }
            return target.owner.getFullyQualifiedClassName().equals(member.getOwner().getName()) || Factory.containsExactlyOneMatch(new ClassHierarchyPath(target.owner, member.getOwner()), target, signaturePredicate);
        }

        private static <TARGET extends RawAccessRecord.TargetInfo> boolean containsExactlyOneMatch(Iterable<JavaClass> classes, TARGET target, SignaturePredicate<TARGET> signaturePredicate) {
            HashSet<JavaClass> matching = new HashSet<JavaClass>();
            for (JavaClass javaClass : classes) {
                if (!signaturePredicate.exists(javaClass, target)) continue;
                matching.add(javaClass);
            }
            return matching.size() == 1;
        }

        private static <T> Optional<T> uniqueTargetIn(Collection<T> collection) {
            return collection.size() == 1 ? Optional.of(Iterables.getOnlyElement(collection)) : Optional.empty();
        }

        private static List<JavaClass> getArgumentTypesFrom(String descriptor, ImportedClasses classes) {
            ImmutableList.Builder result = ImmutableList.builder();
            for (JavaClassDescriptor type : JavaClassDescriptorImporter.importAsmMethodArgumentTypes(descriptor)) {
                result.add(classes.getOrResolve(type.getFullyQualifiedClassName()));
            }
            return result.build();
        }

        private static interface SignaturePredicate<TARGET extends RawAccessRecord.TargetInfo> {
            public boolean exists(JavaClass var1, TARGET var2);
        }

        private static class ClassHierarchyPath
        implements Iterable<JavaClass> {
            private final List<JavaClass> path;

            public ClassHierarchyPath(JavaClassDescriptor childType, JavaClass parent) {
                Optional<JavaClass> child = this.tryFindChildInHierarchy(childType, parent);
                this.path = child.isPresent() ? this.createPath(parent, child.get()) : Collections.emptyList();
            }

            private Optional<JavaClass> tryFindChildInHierarchy(JavaClassDescriptor childType, JavaClass parent) {
                for (JavaClass subclass : parent.getAllSubclasses()) {
                    if (!subclass.getName().equals(childType.getFullyQualifiedClassName())) continue;
                    return Optional.of(subclass);
                }
                return Optional.empty();
            }

            private List<JavaClass> createPath(JavaClass parent, JavaClass child) {
                ImmutableCollection.ArrayBasedBuilder pathBuilder = ImmutableList.builder().add(child);
                HierarchyResolutionStrategy hierarchyResolutionStrategy = this.hierarchyResolutionStrategyFrom(child).to(parent);
                while (hierarchyResolutionStrategy.hasNext()) {
                    ((ImmutableList.Builder)pathBuilder).add(hierarchyResolutionStrategy.next());
                }
                return ((ImmutableList.Builder)pathBuilder).build();
            }

            private HierarchyResolutionStrategyCreator hierarchyResolutionStrategyFrom(JavaClass child) {
                return new HierarchyResolutionStrategyCreator(child);
            }

            @Override
            public Iterator<JavaClass> iterator() {
                return this.path.iterator();
            }

            private static class HierarchyResolutionStrategyCreator {
                private final JavaClass child;

                private HierarchyResolutionStrategyCreator(JavaClass child) {
                    this.child = child;
                }

                public HierarchyResolutionStrategy to(JavaClass parent) {
                    return parent.isInterface() ? new InterfaceHierarchyResolutionStrategy(this.child, parent) : new ClassHierarchyResolutionStrategy(this.child, parent);
                }
            }

            private static interface HierarchyResolutionStrategy {
                public boolean hasNext();

                public JavaClass next();
            }

            private static class Node {
                private final JavaClass child;
                private final Set<Node> parents = new HashSet<Node>();

                private Node(JavaClass child) {
                    this.child = child;
                    for (JavaClass i : child.getRawInterfaces()) {
                        this.parents.add(new Node(i));
                    }
                }

                public List<JavaClass> to(JavaClass target) {
                    if (this.child.equals(target)) {
                        return Collections.singletonList(this.child);
                    }
                    LinkedHashSet<JavaClass> result = new LinkedHashSet<JavaClass>();
                    for (Node parent : this.parents) {
                        if (!parent.contains(target)) continue;
                        result.add(this.child);
                        result.addAll(parent.to(target));
                    }
                    return new ArrayList<JavaClass>(result);
                }

                public boolean contains(JavaClass target) {
                    if (this.child.equals(target)) {
                        return true;
                    }
                    for (Node parent : this.parents) {
                        if (!parent.contains(target)) continue;
                        return true;
                    }
                    return false;
                }
            }

            private static class InterfaceHierarchyResolutionStrategy
            implements HierarchyResolutionStrategy {
                private final Iterator<JavaClass> interfaces;
                private final JavaClass parent;
                private JavaClass current;

                private InterfaceHierarchyResolutionStrategy(JavaClass child, JavaClass parent) {
                    this.interfaces = this.interfacesBetween(child, parent);
                    this.parent = parent;
                    this.current = child;
                }

                private Iterator<JavaClass> interfacesBetween(JavaClass from, JavaClass target) {
                    Node node = new Node(from);
                    ArrayList<JavaClass> result = new ArrayList<JavaClass>();
                    for (Node parent : node.parents) {
                        result.addAll(parent.to(target));
                    }
                    return result.iterator();
                }

                @Override
                public boolean hasNext() {
                    return !this.current.equals(this.parent) && this.interfaces.hasNext();
                }

                @Override
                public JavaClass next() {
                    this.current = this.interfaces.next();
                    return this.current;
                }
            }

            private static class ClassHierarchyResolutionStrategy
            implements HierarchyResolutionStrategy {
                private final JavaClass parent;
                private JavaClass current;

                private ClassHierarchyResolutionStrategy(JavaClass child, JavaClass parent) {
                    this.current = child;
                    this.parent = parent;
                }

                @Override
                public boolean hasNext() {
                    return !this.current.equals(this.parent) && this.current.getRawSuperclass().isPresent();
                }

                @Override
                public JavaClass next() {
                    this.current = this.current.getRawSuperclass().get();
                    return this.current;
                }
            }
        }

        private static class RawFieldAccessRecordProcessed
        implements FieldAccessRecord {
            private final RawAccessRecord.ForField record;
            final ImportedClasses classes;
            private final JavaClass targetOwner;
            private final Supplier<JavaCodeUnit> callerSupplier;

            RawFieldAccessRecordProcessed(RawAccessRecord.ForField record, ImportedClasses classes) {
                this.record = record;
                this.classes = classes;
                this.targetOwner = this.classes.getOrResolve(record.target.owner.getFullyQualifiedClassName());
                this.callerSupplier = Factory.createCallerSupplier(record.caller, classes);
            }

            @Override
            public JavaFieldAccess.AccessType getAccessType() {
                return this.record.accessType;
            }

            @Override
            public JavaCodeUnit getCaller() {
                return this.callerSupplier.get();
            }

            @Override
            public AccessTarget.FieldAccessTarget getTarget() {
                FieldTargetSupplier fieldSupplier = new FieldTargetSupplier(this.targetOwner.getAllFields(), this.record.target);
                JavaClass fieldType = this.classes.getOrResolve(JavaClassDescriptorImporter.importAsmTypeFromDescriptor(this.record.target.desc).getFullyQualifiedClassName());
                return ((DomainBuilders.FieldAccessTargetBuilder)((DomainBuilders.FieldAccessTargetBuilder)new DomainBuilders.FieldAccessTargetBuilder().withOwner(this.targetOwner)).withName(this.record.target.name)).withType(fieldType).withField(fieldSupplier).build();
            }

            @Override
            public int getLineNumber() {
                return this.record.lineNumber;
            }

            private static class FieldTargetSupplier
            implements Supplier<Optional<JavaField>> {
                private final Set<JavaField> allFields;
                private final RawAccessRecord.TargetInfo target;

                FieldTargetSupplier(Set<JavaField> allFields, RawAccessRecord.TargetInfo target) {
                    this.allFields = allFields;
                    this.target = target;
                }

                @Override
                public Optional<JavaField> get() {
                    return Factory.uniqueTargetIn(Factory.tryFindMatchingTargets(this.allFields, this.target, FIELD_SIGNATURE_PREDICATE));
                }
            }
        }

        private static class RawMethodCallRecordProcessed
        implements AccessRecord<AccessTarget.MethodCallTarget> {
            private final RawAccessRecord record;
            final ImportedClasses classes;
            private final JavaClass targetOwner;
            private final Supplier<JavaCodeUnit> callerSupplier;

            RawMethodCallRecordProcessed(RawAccessRecord record, ImportedClasses classes) {
                this.record = record;
                this.classes = classes;
                this.targetOwner = this.classes.getOrResolve(record.target.owner.getFullyQualifiedClassName());
                this.callerSupplier = Factory.createCallerSupplier(record.caller, classes);
            }

            @Override
            public JavaCodeUnit getCaller() {
                return this.callerSupplier.get();
            }

            @Override
            public AccessTarget.MethodCallTarget getTarget() {
                MethodTargetSupplier methodsSupplier = new MethodTargetSupplier(this.targetOwner.getAllMethods(), this.record.target);
                List parameters = Factory.getArgumentTypesFrom(this.record.target.desc, this.classes);
                JavaClass returnType = this.classes.getOrResolve(JavaClassDescriptorImporter.importAsmMethodReturnType(this.record.target.desc).getFullyQualifiedClassName());
                return ((DomainBuilders.MethodCallTargetBuilder)((DomainBuilders.MethodCallTargetBuilder)((DomainBuilders.MethodCallTargetBuilder)((DomainBuilders.MethodCallTargetBuilder)new DomainBuilders.MethodCallTargetBuilder().withOwner(this.targetOwner)).withName(this.record.target.name)).withParameters(parameters)).withReturnType(returnType)).withMethods(methodsSupplier).build();
            }

            @Override
            public int getLineNumber() {
                return this.record.lineNumber;
            }

            private static class MethodTargetSupplier
            implements Supplier<Set<JavaMethod>> {
                private final Set<JavaMethod> allMethods;
                private final RawAccessRecord.TargetInfo target;

                MethodTargetSupplier(Set<JavaMethod> allMethods, RawAccessRecord.TargetInfo target) {
                    this.allMethods = allMethods;
                    this.target = target;
                }

                @Override
                public Set<JavaMethod> get() {
                    return Factory.tryFindMatchingTargets(this.allMethods, this.target, METHOD_SIGNATURE_PREDICATE);
                }
            }
        }

        private static class RawConstructorCallRecordProcessed
        implements AccessRecord<AccessTarget.ConstructorCallTarget> {
            private final RawAccessRecord record;
            private final ImportedClasses classes;
            private final JavaClass targetOwner;
            private final Supplier<JavaCodeUnit> callerSupplier;

            RawConstructorCallRecordProcessed(RawAccessRecord record, ImportedClasses classes) {
                this.record = record;
                this.classes = classes;
                this.targetOwner = this.classes.getOrResolve(record.target.owner.getFullyQualifiedClassName());
                this.callerSupplier = Factory.createCallerSupplier(record.caller, classes);
            }

            @Override
            public JavaCodeUnit getCaller() {
                return this.callerSupplier.get();
            }

            @Override
            public AccessTarget.ConstructorCallTarget getTarget() {
                ConstructorTargetSupplier constructorSupplier = new ConstructorTargetSupplier(this.targetOwner, this.record.target);
                List paramTypes = Factory.getArgumentTypesFrom(this.record.target.desc, this.classes);
                JavaClass returnType = this.classes.getOrResolve(Void.TYPE.getName());
                return ((DomainBuilders.ConstructorCallTargetBuilder)((DomainBuilders.ConstructorCallTargetBuilder)((DomainBuilders.ConstructorCallTargetBuilder)new DomainBuilders.ConstructorCallTargetBuilder().withOwner(this.targetOwner)).withParameters(paramTypes)).withReturnType(returnType)).withConstructor(constructorSupplier).build();
            }

            @Override
            public int getLineNumber() {
                return this.record.lineNumber;
            }

            private static class ConstructorTargetSupplier
            implements Supplier<Optional<JavaConstructor>> {
                private final JavaClass targetOwner;
                private final RawAccessRecord.TargetInfo target;

                ConstructorTargetSupplier(JavaClass targetOwner, RawAccessRecord.TargetInfo target) {
                    this.targetOwner = targetOwner;
                    this.target = target;
                }

                @Override
                public Optional<JavaConstructor> get() {
                    for (JavaConstructor constructor : this.targetOwner.getConstructors()) {
                        if (!constructor.getDescriptor().equals(this.target.desc)) continue;
                        return Optional.of(constructor);
                    }
                    return Optional.empty();
                }
            }
        }
    }

    @Internal
    public static interface FieldAccessRecord
    extends AccessRecord<AccessTarget.FieldAccessTarget> {
        public JavaFieldAccess.AccessType getAccessType();
    }
}

