/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain.properties;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.ChainableFunction;
import com.tngtech.archunit.base.DescribedPredicate;

public interface HasOwner<T> {
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public T getOwner();

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final class Functions {
        private Functions() {
        }

        public static final class Get {
            private Get() {
            }

            @PublicAPI(usage=PublicAPI.Usage.ACCESS)
            public static <T> ChainableFunction<HasOwner<T>, T> owner() {
                return new ChainableFunction<HasOwner<T>, T>(){

                    @Override
                    public T apply(HasOwner<T> input) {
                        return input.getOwner();
                    }
                };
            }
        }
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final class Predicates {
        private Predicates() {
        }

        private static class OwnerPredicate<T>
        extends DescribedPredicate<HasOwner<T>> {
            private final DescribedPredicate<? super T> predicate;

            OwnerPredicate(DescribedPredicate<? super T> predicate) {
                super("owner " + predicate.getDescription(), new Object[0]);
                this.predicate = predicate;
            }

            @Override
            public boolean apply(HasOwner<T> input) {
                return this.predicate.apply(input.getOwner());
            }
        }

        public static final class With {
            private With() {
            }

            @PublicAPI(usage=PublicAPI.Usage.ACCESS)
            public static <T> DescribedPredicate<HasOwner<T>> owner(DescribedPredicate<? super T> predicate) {
                return new OwnerPredicate<T>(predicate);
            }
        }
    }
}

