/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.ChainableFunction;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.base.Guava;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.ThrowsDeclaration;
import com.tngtech.archunit.core.domain.properties.CanBeAnnotated;
import com.tngtech.archunit.core.domain.properties.HasName;
import com.tngtech.archunit.core.domain.properties.HasOwner;
import com.tngtech.archunit.core.domain.properties.HasParameterTypes;
import com.tngtech.archunit.core.domain.properties.HasReturnType;
import com.tngtech.archunit.core.domain.properties.HasType;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.collect.FluentIterable;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public final class ThrowsClause<LOCATION extends HasParameterTypes & HasReturnType & CanBeAnnotated>
implements HasOwner<LOCATION>,
Iterable<ThrowsDeclaration<LOCATION>> {
    private final LOCATION location;
    private final List<ThrowsDeclaration<LOCATION>> throwsDeclarations;

    private ThrowsClause(LOCATION location, List<JavaClass> thrownTypes) {
        this.location = (HasParameterTypes)Preconditions.checkNotNull(location);
        ImmutableList.Builder result = ImmutableList.builder();
        for (JavaClass type : thrownTypes) {
            result.add(new ThrowsDeclaration(this, type));
        }
        this.throwsDeclarations = result.build();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean containsType(Class<?> type) {
        return this.containsType(type.getName());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean containsType(String typeName) {
        return this.containsType(HasName.Functions.GET_NAME.is(DescribedPredicate.equalTo(typeName)));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean containsType(DescribedPredicate<? super JavaClass> predicate) {
        for (ThrowsDeclaration<LOCATION> throwsDeclaration : this.throwsDeclarations) {
            if (!predicate.apply(throwsDeclaration.getRawType())) continue;
            return true;
        }
        return false;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public List<JavaClass> getTypes() {
        return FluentIterable.from(this.throwsDeclarations).transform(Guava.toGuava(HasType.Functions.GET_RAW_TYPE)).toList();
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public LOCATION getOwner() {
        return this.location;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClass getDeclaringClass() {
        return (JavaClass)((HasOwner)this.getOwner()).getOwner();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public int size() {
        return this.throwsDeclarations.size();
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Iterator<ThrowsDeclaration<LOCATION>> iterator() {
        return this.throwsDeclarations.iterator();
    }

    public int hashCode() {
        return Objects.hash(this.location, this.getTypes());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ThrowsClause other = (ThrowsClause)obj;
        return Objects.equals(this.location, other.location) && Objects.equals(this.getTypes(), other.getTypes());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{location=" + ((HasName.AndFullName)this.location).getFullName() + ", throwsDeclarations=" + this.throwsDeclarations + '}';
    }

    static <LOCATION extends HasParameterTypes & HasReturnType & CanBeAnnotated> ThrowsClause<LOCATION> from(LOCATION location, List<JavaClass> types) {
        return new ThrowsClause<LOCATION>(location, types);
    }

    static <LOCATION extends HasParameterTypes & HasReturnType & CanBeAnnotated> ThrowsClause<LOCATION> empty(LOCATION location) {
        return new ThrowsClause<LOCATION>(location, Collections.emptyList());
    }

    public static final class Functions {
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<ThrowsClause<?>, List<JavaClass>> GET_TYPES = new ChainableFunction<ThrowsClause<?>, List<JavaClass>>(){

            @Override
            public List<JavaClass> apply(ThrowsClause<?> input) {
                return input.getTypes();
            }
        };

        private Functions() {
        }
    }
}

