/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.ChainableFunction;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaCodeUnit;
import com.tngtech.archunit.core.domain.JavaType;
import com.tngtech.archunit.core.domain.SourceCodeLocation;
import com.tngtech.archunit.core.domain.properties.HasOwner;
import com.tngtech.archunit.core.domain.properties.HasSourceCodeLocation;
import com.tngtech.archunit.core.domain.properties.HasType;
import com.tngtech.archunit.thirdparty.com.google.common.base.MoreObjects;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public final class ReferencedClassObject
implements HasType,
HasOwner<JavaCodeUnit>,
HasSourceCodeLocation {
    private final JavaCodeUnit owner;
    private final JavaClass value;
    private final int lineNumber;
    private final SourceCodeLocation sourceCodeLocation;

    private ReferencedClassObject(JavaCodeUnit owner, JavaClass value, int lineNumber) {
        this.owner = Preconditions.checkNotNull(owner);
        this.value = Preconditions.checkNotNull(value);
        this.lineNumber = lineNumber;
        this.sourceCodeLocation = SourceCodeLocation.of(owner.getOwner(), lineNumber);
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaType getType() {
        return this.getRawType();
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClass getRawType() {
        return this.value;
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaCodeUnit getOwner() {
        return this.owner;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClass getValue() {
        return this.value;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public SourceCodeLocation getSourceCodeLocation() {
        return this.sourceCodeLocation;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("owner", this.owner).add("value", this.value).add("sourceCodeLocation", this.sourceCodeLocation).toString();
    }

    static ReferencedClassObject from(JavaCodeUnit owner, JavaClass javaClass, int lineNumber) {
        return new ReferencedClassObject(owner, javaClass, lineNumber);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final class Functions {
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<ReferencedClassObject, JavaClass> GET_VALUE = new ChainableFunction<ReferencedClassObject, JavaClass>(){

            @Override
            public JavaClass apply(ReferencedClassObject input) {
                return input.getValue();
            }
        };

        private Functions() {
        }
    }
}

