/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.core.domain.Formatters;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaType;
import com.tngtech.archunit.core.domain.properties.HasUpperBounds;
import com.tngtech.archunit.core.importer.DomainBuilders;
import com.tngtech.archunit.thirdparty.com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;

public class JavaWildcardType
implements JavaType,
HasUpperBounds {
    private static final String WILDCARD_TYPE_NAME = "?";
    private final List<JavaType> upperBounds;
    private final List<JavaType> lowerBounds;
    private final JavaClass erasure;

    JavaWildcardType(DomainBuilders.JavaWildcardTypeBuilder<?> builder) {
        this.upperBounds = builder.getUpperBounds();
        this.lowerBounds = builder.getLowerBounds();
        this.erasure = builder.getUnboundErasureType(this.upperBounds);
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public String getName() {
        return WILDCARD_TYPE_NAME + this.boundsToString();
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public List<JavaType> getUpperBounds() {
        return this.upperBounds;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public List<JavaType> getLowerBounds() {
        return this.lowerBounds;
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClass toErasure() {
        return this.erasure;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '{' + this.getName() + '}';
    }

    private String boundsToString() {
        String upperBoundsString = !this.upperBounds.isEmpty() ? " extends " + this.joinTypeNames(this.upperBounds) : "";
        String lowerBoundsString = !this.lowerBounds.isEmpty() ? " super " + this.joinTypeNames(this.lowerBounds) : "";
        return upperBoundsString + lowerBoundsString;
    }

    private String joinTypeNames(List<JavaType> types) {
        ArrayList<String> formatted = new ArrayList<String>();
        for (JavaType type : types) {
            formatted.add(Formatters.ensureCanonicalArrayTypeName(type.getName()));
        }
        return Joiner.on(" & ").join(formatted);
    }
}

