/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.ChainableFunction;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.base.Function;
import com.tngtech.archunit.base.Guava;
import com.tngtech.archunit.base.Optional;
import com.tngtech.archunit.base.Predicate;
import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.core.domain.JavaAnnotation;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.properties.HasAnnotations;
import com.tngtech.archunit.core.domain.properties.HasName;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.base.Splitter;
import com.tngtech.archunit.thirdparty.com.google.common.collect.FluentIterable;
import com.tngtech.archunit.thirdparty.com.google.common.collect.HashMultimap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableCollection;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableMap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Iterables;
import com.tngtech.archunit.thirdparty.com.google.common.collect.SetMultimap;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public final class JavaPackage
implements HasName,
HasAnnotations<JavaPackage> {
    private final String name;
    private final String relativeName;
    private final Set<JavaClass> classes;
    private final Optional<JavaClass> packageInfo;
    private final Map<String, JavaPackage> subpackages;
    private Optional<JavaPackage> parent = Optional.empty();
    private final Function<? super JavaAnnotation<JavaClass>, JavaAnnotation<JavaPackage>> withSelfAsOwner = new Function<JavaAnnotation<JavaClass>, JavaAnnotation<JavaPackage>>(){

        @Override
        public JavaAnnotation<JavaPackage> apply(JavaAnnotation<JavaClass> input) {
            return input.withOwner(JavaPackage.this);
        }
    };

    private JavaPackage(String name, Set<JavaClass> classes, Map<String, JavaPackage> subpackages) {
        this.name = Preconditions.checkNotNull(name);
        this.relativeName = name.substring(name.lastIndexOf(".") + 1);
        this.classes = ImmutableSet.copyOf(classes);
        this.packageInfo = this.tryGetClassWithSimpleName("package-info");
        this.subpackages = ImmutableMap.copyOf(subpackages);
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public String getName() {
        return this.name;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public String getRelativeName() {
        return this.relativeName;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public HasAnnotations<?> getPackageInfo() {
        Optional<HasAnnotations<?>> packageInfo = this.tryGetPackageInfo();
        if (!packageInfo.isPresent()) {
            throw new IllegalArgumentException(String.format("%s does not contain a package-info.java", this.getDescription()));
        }
        return packageInfo.get();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Optional<? extends HasAnnotations<?>> tryGetPackageInfo() {
        return this.packageInfo;
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<? extends JavaAnnotation<JavaPackage>> getAnnotations() {
        if (this.packageInfo.isPresent()) {
            return FluentIterable.from(this.packageInfo.get().getAnnotations()).transform(Guava.toGuava(this.withSelfAsOwner)).toSet();
        }
        return Collections.emptySet();
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public <A extends Annotation> A getAnnotationOfType(Class<A> type) {
        return this.getAnnotationOfType(type.getName()).as(type);
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaAnnotation<JavaPackage> getAnnotationOfType(String typeName) {
        Optional<JavaAnnotation<JavaPackage>> annotation = this.tryGetAnnotationOfType(typeName);
        if (!annotation.isPresent()) {
            throw new IllegalArgumentException(String.format("%s is not annotated with @%s", this.getDescription(), typeName));
        }
        return annotation.get();
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public <A extends Annotation> Optional<A> tryGetAnnotationOfType(Class<A> type) {
        if (this.packageInfo.isPresent()) {
            return this.packageInfo.get().tryGetAnnotationOfType(type);
        }
        return Optional.empty();
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Optional<JavaAnnotation<JavaPackage>> tryGetAnnotationOfType(String typeName) {
        if (this.packageInfo.isPresent()) {
            return this.packageInfo.get().tryGetAnnotationOfType(typeName).map(this.withSelfAsOwner);
        }
        return Optional.empty();
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isAnnotatedWith(Class<? extends Annotation> annotationType) {
        if (this.packageInfo.isPresent()) {
            return this.packageInfo.get().isAnnotatedWith(annotationType);
        }
        return false;
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isAnnotatedWith(String annotationTypeName) {
        if (this.packageInfo.isPresent()) {
            return this.packageInfo.get().isAnnotatedWith(annotationTypeName);
        }
        return false;
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isAnnotatedWith(DescribedPredicate<? super JavaAnnotation<?>> predicate) {
        if (this.packageInfo.isPresent()) {
            return this.packageInfo.get().isAnnotatedWith(predicate);
        }
        return false;
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isMetaAnnotatedWith(Class<? extends Annotation> annotationType) {
        if (this.packageInfo.isPresent()) {
            return this.packageInfo.get().isMetaAnnotatedWith(annotationType);
        }
        return false;
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isMetaAnnotatedWith(String annotationTypeName) {
        if (this.packageInfo.isPresent()) {
            return this.packageInfo.get().isMetaAnnotatedWith(annotationTypeName);
        }
        return false;
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isMetaAnnotatedWith(DescribedPredicate<? super JavaAnnotation<?>> predicate) {
        if (this.packageInfo.isPresent()) {
            return this.packageInfo.get().isMetaAnnotatedWith(predicate);
        }
        return false;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Optional<JavaPackage> getParent() {
        return this.parent;
    }

    private void setParent(JavaPackage parent) {
        this.parent = Optional.of(parent);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaClass> getClasses() {
        return this.classes;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaClass> getAllClasses() {
        ImmutableCollection.Builder result = ImmutableSet.builder().addAll(this.classes);
        for (JavaPackage subpackage : this.getSubpackages()) {
            ((ImmutableSet.Builder)result).addAll(subpackage.getAllClasses());
        }
        return ((ImmutableSet.Builder)result).build();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaPackage> getSubpackages() {
        return ImmutableSet.copyOf(this.subpackages.values());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaPackage> getSubPackages() {
        return this.getSubpackages();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaPackage> getAllSubpackages() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (JavaPackage subpackage : this.getSubpackages()) {
            result.add(subpackage);
            result.addAll(subpackage.getAllSubpackages());
        }
        return result.build();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaPackage> getAllSubPackages() {
        return this.getAllSubpackages();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean containsClass(JavaClass clazz) {
        return this.classes.contains(clazz);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean containsClass(Class<?> clazz) {
        return this.containsClassWithFullyQualifiedName(clazz.getName());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClass getClass(Class<?> clazz) {
        return this.getClassWithFullyQualifiedName(clazz.getName());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean containsClassWithFullyQualifiedName(String className) {
        return this.tryGetClassWithFullyQualifiedName(className).isPresent();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClass getClassWithFullyQualifiedName(String className) {
        return this.getValue(this.tryGetClassWithFullyQualifiedName(className), "This package does not contain any class with fully qualified name '%s'", className);
    }

    private Optional<JavaClass> tryGetClassWithFullyQualifiedName(String className) {
        return this.tryGetClassWith(HasName.Functions.GET_NAME.is(DescribedPredicate.equalTo(className)));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean containsClassWithSimpleName(String className) {
        return this.tryGetClassWithSimpleName(className).isPresent();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClass getClassWithSimpleName(String className) {
        return this.getValue(this.tryGetClassWithSimpleName(className), "This package does not contain any class with simple name '%s'", className);
    }

    private Optional<JavaClass> tryGetClassWithSimpleName(String className) {
        return this.tryGetClassWith(JavaClass.Functions.GET_SIMPLE_NAME.is(DescribedPredicate.equalTo(className)));
    }

    private Optional<JavaClass> tryGetClassWith(DescribedPredicate<? super JavaClass> predicate) {
        Set<JavaClass> matching = this.getClassesWith(predicate);
        return matching.size() == 1 ? Optional.of(Iterables.getOnlyElement(matching)) : Optional.empty();
    }

    private Set<JavaClass> getClassesWith(Predicate<? super JavaClass> predicate) {
        HashSet<JavaClass> result = new HashSet<JavaClass>();
        for (JavaClass javaClass : this.classes) {
            if (!predicate.apply(javaClass)) continue;
            result.add(javaClass);
        }
        return result;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean containsPackage(String packageName) {
        return this.tryGetPackage(packageName).isPresent();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaPackage getPackage(String packageName) {
        return this.getValue(this.tryGetPackage(packageName), "This package does not contain any sub package '%s'", packageName);
    }

    private Optional<JavaPackage> tryGetPackage(String packageName) {
        LinkedList<String> packageParts = new LinkedList<String>(Splitter.on('.').splitToList(packageName));
        return this.tryGetPackage(this, packageParts);
    }

    private Optional<JavaPackage> tryGetPackage(JavaPackage currentPackage, Deque<String> packageParts) {
        if (packageParts.isEmpty()) {
            return Optional.of(currentPackage);
        }
        String next = packageParts.poll();
        if (!this.subpackages.containsKey(next)) {
            return Optional.empty();
        }
        JavaPackage child = this.subpackages.get(next);
        return child.tryGetPackage(child, packageParts);
    }

    private <T> T getValue(Optional<T> optional, String errorMessageTemplate, Object ... messageParams) {
        Preconditions.checkArgument(optional.isPresent(), errorMessageTemplate, messageParams);
        return optional.get();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<Dependency> getClassDependenciesFromSelf() {
        ImmutableSet.Builder<Dependency> result = ImmutableSet.builder();
        for (JavaClass javaClass : this.getAllClasses()) {
            this.addAllNonSelfDependencies(result, javaClass.getDirectDependenciesFromSelf());
        }
        return result.build();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<Dependency> getClassDependenciesToSelf() {
        ImmutableSet.Builder<Dependency> result = ImmutableSet.builder();
        for (JavaClass javaClass : this.getAllClasses()) {
            this.addAllNonSelfDependencies(result, javaClass.getDirectDependenciesToSelf());
        }
        return result.build();
    }

    private void addAllNonSelfDependencies(ImmutableSet.Builder<Dependency> result, Set<Dependency> dependencies) {
        for (Dependency dependency : dependencies) {
            if (this.containsClass(dependency.getOriginClass()) && this.containsClass(dependency.getTargetClass())) continue;
            result.add((Object)dependency);
        }
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaPackage> getPackageDependenciesFromSelf() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (Dependency dependency : this.getClassDependenciesFromSelf()) {
            result.add(dependency.getTargetClass().getPackage());
        }
        return result.build();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaPackage> getPackageDependenciesToSelf() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (Dependency dependency : this.getClassDependenciesToSelf()) {
            result.add(dependency.getOriginClass().getPackage());
        }
        return result.build();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public void accept(Predicate<? super JavaClass> predicate, ClassVisitor visitor) {
        for (JavaClass javaClass : this.getClassesWith(predicate)) {
            visitor.visit(javaClass);
        }
        for (JavaPackage subpackage : this.getSubpackages()) {
            subpackage.accept(predicate, visitor);
        }
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public void accept(Predicate<? super JavaPackage> predicate, PackageVisitor visitor) {
        if (predicate.apply(this)) {
            visitor.visit(this);
        }
        for (JavaPackage subpackage : this.getSubpackages()) {
            subpackage.accept(predicate, visitor);
        }
    }

    @Override
    public String getDescription() {
        return "Package <" + this.name + ">";
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getName() + "]";
    }

    static JavaPackage simple(JavaClass javaClass) {
        String packageName = javaClass.getPackageName();
        JavaPackage defaultPackage = JavaPackage.from(Collections.singleton(javaClass));
        return packageName.isEmpty() ? defaultPackage : defaultPackage.getPackage(packageName);
    }

    static JavaPackage from(Iterable<JavaClass> classes) {
        return new Tree(classes).toJavaPackage();
    }

    @PublicAPI(usage=PublicAPI.Usage.INHERITANCE)
    public static interface ClassVisitor {
        public void visit(JavaClass var1);
    }

    @PublicAPI(usage=PublicAPI.Usage.INHERITANCE)
    public static interface PackageVisitor {
        public void visit(JavaPackage var1);
    }

    private static class Tree {
        private final String packageName;
        private final Map<String, Tree> subpackageTrees;
        private final Set<JavaClass> classes = new HashSet<JavaClass>();

        Tree(Iterable<JavaClass> classes) {
            this("", classes);
        }

        private Tree(String packageName, Iterable<JavaClass> classes) {
            this.packageName = packageName;
            HashMultimap<String, JavaClass> childPackages = HashMultimap.create();
            for (JavaClass clazz : classes) {
                if (clazz.getPackageName().equals(packageName)) {
                    this.classes.add(clazz);
                    continue;
                }
                String subpackageName = this.findSubpackageName(packageName, clazz);
                childPackages.put(subpackageName, clazz);
            }
            this.subpackageTrees = this.createSubTrees(packageName, childPackages);
        }

        private String findSubpackageName(String packageName, JavaClass clazz) {
            String packageRest = !packageName.isEmpty() ? clazz.getPackageName().substring(packageName.length() + 1) : clazz.getPackageName();
            int indexOfDot = packageRest.indexOf(".");
            return indexOfDot > 0 ? packageRest.substring(0, indexOfDot) : packageRest;
        }

        private Map<String, Tree> createSubTrees(String packageName, SetMultimap<String, JavaClass> childPackages) {
            HashMap<String, Tree> result = new HashMap<String, Tree>();
            for (Map.Entry<String, Collection<JavaClass>> entry : childPackages.asMap().entrySet()) {
                String childPackageName = this.joinSkippingEmpty(packageName, entry.getKey());
                result.put(entry.getKey(), new Tree(childPackageName, (Iterable<JavaClass>)entry.getValue()));
            }
            return result;
        }

        private String joinSkippingEmpty(String first, String second) {
            return !first.isEmpty() ? first + "." + second : second;
        }

        JavaPackage toJavaPackage() {
            JavaPackage result = this.createJavaPackage();
            for (JavaPackage subpackage : result.getSubpackages()) {
                subpackage.setParent(result);
            }
            return result;
        }

        private JavaPackage createJavaPackage() {
            ImmutableMap.Builder<String, JavaPackage> subpackages = ImmutableMap.builder();
            for (Map.Entry<String, Tree> entry : this.subpackageTrees.entrySet()) {
                subpackages.put(entry.getKey(), entry.getValue().toJavaPackage());
            }
            return new JavaPackage(this.packageName, this.classes, subpackages.build());
        }
    }

    public static final class Functions {
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<JavaPackage, String> GET_RELATIVE_NAME = new ChainableFunction<JavaPackage, String>(){

            @Override
            public String apply(JavaPackage javaPackage) {
                return javaPackage.getRelativeName();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<JavaPackage, Set<JavaClass>> GET_CLASSES = new ChainableFunction<JavaPackage, Set<JavaClass>>(){

            @Override
            public Set<JavaClass> apply(JavaPackage javaPackage) {
                return javaPackage.getClasses();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<JavaPackage, Set<JavaPackage>> GET_SUB_PACKAGES = new ChainableFunction<JavaPackage, Set<JavaPackage>>(){

            @Override
            public Set<JavaPackage> apply(JavaPackage javaPackage) {
                return javaPackage.getSubpackages();
            }
        };

        private Functions() {
        }
    }
}

