/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.AccessTarget;
import com.tngtech.archunit.core.domain.JavaAccess;
import com.tngtech.archunit.core.importer.DomainBuilders;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

public class JavaFieldAccess
extends JavaAccess<AccessTarget.FieldAccessTarget> {
    private static final Map<AccessType, String> MESSAGE_VERB = ImmutableMap.of(AccessType.GET, "gets", AccessType.SET, "sets");
    private final AccessType accessType;

    JavaFieldAccess(DomainBuilders.JavaFieldAccessBuilder builder) {
        super(builder);
        this.accessType = Preconditions.checkNotNull(builder.getAccessType());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public AccessType getAccessType() {
        return this.accessType;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.accessType.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JavaFieldAccess other = (JavaFieldAccess)obj;
        return super.equals(other) && Objects.equals((Object)this.accessType, (Object)other.accessType);
    }

    @Override
    protected String additionalToStringFields() {
        return ", accessType=" + (Object)((Object)this.accessType);
    }

    @Override
    protected String descriptionVerb() {
        return MESSAGE_VERB.get((Object)this.accessType);
    }

    public static enum AccessType {
        GET(182),
        SET(183);

        private final int asmOpCodes;

        private AccessType(int asmOpCodes) {
            this.asmOpCodes = asmOpCodes;
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static AccessType forOpCode(int opCode) {
            for (AccessType accessType : AccessType.values()) {
                if ((accessType.asmOpCodes & opCode) != opCode) continue;
                return accessType;
            }
            throw new IllegalArgumentException("There is no " + AccessType.class.getSimpleName() + " registered for OpCode <" + opCode + ">");
        }
    }

    public static final class Predicates {
        private Predicates() {
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaFieldAccess> accessType(AccessType accessType) {
            return new AccessTypePredicate(accessType);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaFieldAccess> target(DescribedPredicate<? super AccessTarget.FieldAccessTarget> predicate) {
            return new TargetPredicate(predicate);
        }

        private static class AccessTypePredicate
        extends DescribedPredicate<JavaFieldAccess> {
            private final AccessType accessType;

            AccessTypePredicate(AccessType accessType) {
                super("access type " + (Object)((Object)accessType), new Object[0]);
                this.accessType = accessType;
            }

            @Override
            public boolean apply(JavaFieldAccess input) {
                return this.accessType == input.getAccessType();
            }
        }

        private static class TargetPredicate
        extends DescribedPredicate<JavaFieldAccess> {
            private final DescribedPredicate<? super AccessTarget.FieldAccessTarget> predicate;

            TargetPredicate(DescribedPredicate<? super AccessTarget.FieldAccessTarget> predicate) {
                super("target " + predicate.getDescription(), new Object[0]);
                this.predicate = predicate;
            }

            @Override
            public boolean apply(JavaFieldAccess input) {
                return this.predicate.apply((AccessTarget.FieldAccessTarget)input.getTarget());
            }
        }
    }
}

