/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.DescribedIterable;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.base.ForwardingCollection;
import com.tngtech.archunit.base.Guava;
import com.tngtech.archunit.core.domain.ImportContext;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaClassDependencies;
import com.tngtech.archunit.core.domain.JavaPackage;
import com.tngtech.archunit.core.domain.ReverseDependencies;
import com.tngtech.archunit.core.domain.properties.CanOverrideDescription;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableMap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class JavaClasses
extends ForwardingCollection<JavaClass>
implements DescribedIterable<JavaClass>,
CanOverrideDescription<JavaClasses> {
    private final ImmutableMap<String, JavaClass> classes;
    private final JavaPackage defaultPackage;
    private final String description;

    private JavaClasses(JavaPackage defaultPackage, Map<String, JavaClass> classes) {
        this(defaultPackage, classes, "classes");
    }

    private JavaClasses(JavaPackage defaultPackage, Map<String, JavaClass> classes, String description) {
        this.classes = ImmutableMap.copyOf(classes);
        this.defaultPackage = Preconditions.checkNotNull(defaultPackage);
        this.description = Preconditions.checkNotNull(description);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClasses that(DescribedPredicate<? super JavaClass> predicate) {
        Map<String, JavaClass> matchingElements = Guava.Maps.filterValues(this.classes, predicate);
        String newDescription = String.format("%s that %s", this.description, predicate.getDescription());
        return new JavaClasses(this.defaultPackage, matchingElements, newDescription);
    }

    @Override
    public JavaClasses as(String description) {
        return new JavaClasses(this.defaultPackage, this.classes, description);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{classes=" + this.classes + '}';
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean contain(Class<?> reflectedType) {
        return this.contain(reflectedType.getName());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClass get(Class<?> reflectedType) {
        return this.get(reflectedType.getName());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean contain(String typeName) {
        return this.classes.containsKey(typeName);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClass get(String typeName) {
        Preconditions.checkArgument(this.contain(typeName), "%s do not contain %s of type %s", (Object)this.getClass().getSimpleName(), (Object)JavaClass.class.getSimpleName(), (Object)typeName);
        return this.classes.get(typeName);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean containPackage(String packageName) {
        return this.defaultPackage.containsPackage(packageName);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaPackage getPackage(String packageName) {
        return this.defaultPackage.getPackage(packageName);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaPackage getDefaultPackage() {
        return this.defaultPackage;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.classes.keySet(), this.description);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JavaClasses other = (JavaClasses)obj;
        return Objects.equals(this.classes.keySet(), other.classes.keySet()) && Objects.equals(this.description, other.description);
    }

    @Override
    protected Collection<JavaClass> delegate() {
        return this.classes.values();
    }

    static JavaClasses of(Iterable<JavaClass> classes) {
        HashMap<String, JavaClass> mapping = new HashMap<String, JavaClass>();
        for (JavaClass clazz : classes) {
            mapping.put(clazz.getName(), clazz);
        }
        JavaPackage defaultPackage = !Iterables.isEmpty(classes) ? JavaClasses.getRoot(classes.iterator().next().getPackage()) : JavaPackage.from(classes);
        return new JavaClasses(defaultPackage, mapping);
    }

    private static JavaPackage getRoot(JavaPackage javaPackage) {
        JavaPackage result = javaPackage;
        while (result.getParent().isPresent()) {
            result = result.getParent().get();
        }
        return result;
    }

    static JavaClasses of(Map<String, JavaClass> selectedClasses, Collection<JavaClass> allClasses, ImportContext importContext) {
        ReverseDependencies.Creation reverseDependenciesCreation = new ReverseDependencies.Creation();
        JavaPackage defaultPackage = JavaPackage.from(allClasses);
        for (JavaClass clazz : allClasses) {
            JavaClasses.setPackage(clazz, defaultPackage);
            JavaClassDependencies classDependencies = clazz.completeFrom(importContext);
            reverseDependenciesCreation.registerDependenciesOf(clazz, classDependencies);
        }
        reverseDependenciesCreation.finish(allClasses);
        return new JavaClasses(defaultPackage, selectedClasses);
    }

    private static void setPackage(JavaClass clazz, JavaPackage defaultPackage) {
        JavaPackage javaPackage = clazz.getPackageName().isEmpty() ? defaultPackage : defaultPackage.getPackage(clazz.getPackageName());
        clazz.setPackage(javaPackage);
    }
}

