/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain;

import com.tngtech.archunit.base.Optional;
import com.tngtech.archunit.core.domain.ImportContext;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaCodeUnit;
import com.tngtech.archunit.core.domain.JavaConstructor;
import com.tngtech.archunit.core.domain.JavaConstructorCall;
import com.tngtech.archunit.core.domain.JavaEnumConstant;
import com.tngtech.archunit.core.domain.JavaField;
import com.tngtech.archunit.core.domain.JavaFieldAccess;
import com.tngtech.archunit.core.domain.JavaMember;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.core.domain.JavaMethodCall;
import com.tngtech.archunit.core.domain.JavaModifier;
import com.tngtech.archunit.core.domain.JavaStaticInitializer;
import com.tngtech.archunit.core.domain.ReferencedClassObject;
import com.tngtech.archunit.core.domain.ReverseDependencies;
import com.tngtech.archunit.core.domain.properties.HasName;
import com.tngtech.archunit.thirdparty.com.google.common.base.Supplier;
import com.tngtech.archunit.thirdparty.com.google.common.base.Suppliers;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import java.util.Set;

class JavaClassMembers {
    private final JavaClass owner;
    private final Set<JavaField> fields;
    private final Set<JavaCodeUnit> codeUnits;
    private final Set<JavaMethod> methods;
    private final Set<JavaMember> members;
    private final Set<JavaConstructor> constructors;
    private final Optional<JavaStaticInitializer> staticInitializer;
    private final Supplier<Set<JavaMethod>> allMethods;
    private final Supplier<Set<JavaConstructor>> allConstructors;
    private final Supplier<Set<JavaField>> allFields;
    private final Supplier<Set<JavaMember>> allMembers = Suppliers.memoize(new Supplier<Set<JavaMember>>(){

        @Override
        public Set<JavaMember> get() {
            return ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(JavaClassMembers.this.getAllFields())).addAll(JavaClassMembers.this.getAllMethods())).addAll(JavaClassMembers.this.getAllConstructors())).build();
        }
    });

    JavaClassMembers(final JavaClass owner, Set<JavaField> fields, Set<JavaMethod> methods, Set<JavaConstructor> constructors, Optional<JavaStaticInitializer> staticInitializer) {
        this.owner = owner;
        this.fields = fields;
        this.methods = methods;
        this.constructors = constructors;
        this.staticInitializer = staticInitializer;
        this.codeUnits = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(methods)).addAll(constructors)).addAll(staticInitializer.asSet())).build();
        this.members = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(fields)).addAll(methods)).addAll(constructors)).build();
        this.allFields = Suppliers.memoize(new Supplier<Set<JavaField>>(){

            @Override
            public Set<JavaField> get() {
                ImmutableSet.Builder result = ImmutableSet.builder();
                for (JavaClass javaClass : Iterables.concat(owner.getClassHierarchy(), owner.getAllRawInterfaces())) {
                    result.addAll(javaClass.getFields());
                }
                return result.build();
            }
        });
        this.allMethods = Suppliers.memoize(new Supplier<Set<JavaMethod>>(){

            @Override
            public Set<JavaMethod> get() {
                ImmutableSet.Builder result = ImmutableSet.builder();
                for (JavaClass javaClass : Iterables.concat(owner.getClassHierarchy(), owner.getAllRawInterfaces())) {
                    result.addAll(javaClass.getMethods());
                }
                return result.build();
            }
        });
        this.allConstructors = Suppliers.memoize(new Supplier<Set<JavaConstructor>>(){

            @Override
            public Set<JavaConstructor> get() {
                ImmutableSet.Builder result = ImmutableSet.builder();
                for (JavaClass javaClass : owner.getClassHierarchy()) {
                    result.addAll(javaClass.getConstructors());
                }
                return result.build();
            }
        });
    }

    Set<JavaMember> get() {
        return this.members;
    }

    Set<JavaMember> getAll() {
        return this.allMembers.get();
    }

    Set<JavaField> getFields() {
        return this.fields;
    }

    Set<JavaField> getAllFields() {
        return this.allFields.get();
    }

    public JavaField getField(String name) {
        Optional<JavaField> field = this.tryGetField(name);
        if (!field.isPresent()) {
            throw new IllegalArgumentException("No field with name '" + name + " in class " + this.owner.getName());
        }
        return field.get();
    }

    Optional<JavaField> tryGetField(String name) {
        for (JavaField field : this.fields) {
            if (!name.equals(field.getName())) continue;
            return Optional.of(field);
        }
        return Optional.empty();
    }

    Set<JavaCodeUnit> getCodeUnits() {
        return this.codeUnits;
    }

    JavaCodeUnit getCodeUnitWithParameterTypeNames(String name, List<String> parameters) {
        return this.findMatchingCodeUnit(this.codeUnits, name, parameters);
    }

    Optional<JavaCodeUnit> tryGetCodeUnitWithParameterTypeNames(String name, List<String> parameters) {
        return this.tryFindMatchingCodeUnit(this.codeUnits, name, parameters);
    }

    JavaMethod getMethod(String name, List<String> parameterTypeNames) {
        return this.findMatchingCodeUnit(this.methods, name, ImmutableList.copyOf(parameterTypeNames));
    }

    Optional<JavaMethod> tryGetMethod(String name, List<String> parameterTypeNames) {
        return this.tryFindMatchingCodeUnit(this.methods, name, parameterTypeNames);
    }

    Set<JavaMethod> getMethods() {
        return this.methods;
    }

    Set<JavaMethod> getAllMethods() {
        return this.allMethods.get();
    }

    JavaConstructor getConstructor(List<String> parameterTypeNames) {
        return this.findMatchingCodeUnit(this.constructors, "<init>", parameterTypeNames);
    }

    Optional<JavaConstructor> tryGetConstructor(List<String> parameterTypeNames) {
        return this.tryFindMatchingCodeUnit(this.constructors, "<init>", parameterTypeNames);
    }

    Set<JavaConstructor> getConstructors() {
        return this.constructors;
    }

    Set<JavaConstructor> getAllConstructors() {
        return this.allConstructors.get();
    }

    Optional<JavaStaticInitializer> getStaticInitializer() {
        return this.staticInitializer;
    }

    Set<JavaEnumConstant> getEnumConstants() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (JavaField field : this.fields) {
            if (!field.getModifiers().contains((Object)JavaModifier.ENUM)) continue;
            result.add(new JavaEnumConstant(this.owner, field.getName()));
        }
        return result.build();
    }

    Set<ReferencedClassObject> getReferencedClassObjects() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (JavaCodeUnit codeUnit : this.codeUnits) {
            result.addAll(codeUnit.getReferencedClassObjects());
        }
        return result.build();
    }

    Set<JavaFieldAccess> getFieldAccessesFromSelf() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (JavaCodeUnit codeUnit : this.codeUnits) {
            result.addAll(codeUnit.getFieldAccesses());
        }
        return result.build();
    }

    Set<JavaMethodCall> getMethodCallsFromSelf() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (JavaCodeUnit codeUnit : this.codeUnits) {
            result.addAll(codeUnit.getMethodCallsFromSelf());
        }
        return result.build();
    }

    Set<JavaConstructorCall> getConstructorCallsFromSelf() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (JavaCodeUnit codeUnit : this.codeUnits) {
            result.addAll(codeUnit.getConstructorCallsFromSelf());
        }
        return result.build();
    }

    Set<JavaFieldAccess> getFieldAccessesToSelf() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (JavaField field : this.fields) {
            result.addAll(field.getAccessesToSelf());
        }
        return result.build();
    }

    Set<JavaMethodCall> getMethodCallsToSelf() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (JavaMethod method : this.methods) {
            result.addAll(method.getCallsOfSelf());
        }
        return result.build();
    }

    Set<JavaConstructorCall> getConstructorCallsToSelf() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (JavaConstructor constructor : this.constructors) {
            result.addAll(constructor.getCallsOfSelf());
        }
        return result.build();
    }

    private <T extends JavaCodeUnit> T findMatchingCodeUnit(Set<T> codeUnits, String name, List<String> parameters) {
        Optional<T> codeUnit = this.tryFindMatchingCodeUnit(codeUnits, name, parameters);
        if (!codeUnit.isPresent()) {
            throw new IllegalArgumentException(String.format("No code unit with name '%s' and parameters %s in codeUnits %s of class %s", name, parameters, codeUnits, this.owner.getName()));
        }
        return (T)((JavaCodeUnit)codeUnit.get());
    }

    private <T extends JavaCodeUnit> Optional<T> tryFindMatchingCodeUnit(Set<T> codeUnits, String name, List<String> parameters) {
        for (JavaCodeUnit codeUnit : codeUnits) {
            if (!name.equals(codeUnit.getName()) || !parameters.equals(HasName.Utils.namesOf(codeUnit.getRawParameterTypes()))) continue;
            return Optional.of(codeUnit);
        }
        return Optional.empty();
    }

    void completeAnnotations(ImportContext context) {
        for (JavaMember member : this.members) {
            member.completeAnnotations(context);
        }
    }

    void completeAccessesFrom(ImportContext context) {
        for (JavaCodeUnit codeUnit : this.codeUnits) {
            codeUnit.completeAccessesFrom(context);
        }
    }

    void setReverseDependencies(ReverseDependencies reverseDependencies) {
        for (JavaMember member : this.members) {
            member.setReverseDependencies(reverseDependencies);
        }
    }

    static JavaClassMembers empty(JavaClass owner) {
        return new JavaClassMembers(owner, Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Optional.empty());
    }

    static JavaClassMembers create(JavaClass owner, ImportContext context) {
        return new JavaClassMembers(owner, context.createFields(owner), context.createMethods(owner), context.createConstructors(owner), context.createStaticInitializer(owner));
    }
}

