/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain;

import com.tngtech.archunit.base.HasDescription;
import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.core.domain.InstanceofCheck;
import com.tngtech.archunit.core.domain.JavaAccess;
import com.tngtech.archunit.core.domain.JavaAnnotation;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaCodeUnit;
import com.tngtech.archunit.core.domain.JavaEnumConstant;
import com.tngtech.archunit.core.domain.JavaField;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.core.domain.JavaParameterizedType;
import com.tngtech.archunit.core.domain.JavaType;
import com.tngtech.archunit.core.domain.JavaTypeVariable;
import com.tngtech.archunit.core.domain.JavaWildcardType;
import com.tngtech.archunit.core.domain.ReferencedClassObject;
import com.tngtech.archunit.core.domain.ThrowsDeclaration;
import com.tngtech.archunit.core.domain.properties.HasAnnotations;
import com.tngtech.archunit.thirdparty.com.google.common.base.Predicates;
import com.tngtech.archunit.thirdparty.com.google.common.base.Supplier;
import com.tngtech.archunit.thirdparty.com.google.common.base.Suppliers;
import com.tngtech.archunit.thirdparty.com.google.common.collect.FluentIterable;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableCollection;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

class JavaClassDependencies {
    private final JavaClass javaClass;
    private final Supplier<Set<Dependency>> directDependenciesFromClass;

    JavaClassDependencies(JavaClass javaClass) {
        this.javaClass = javaClass;
        this.directDependenciesFromClass = this.createDirectDependenciesFromClassSupplier();
    }

    private Supplier<Set<Dependency>> createDirectDependenciesFromClassSupplier() {
        return Suppliers.memoize(new Supplier<Set<Dependency>>(){

            @Override
            public Set<Dependency> get() {
                ImmutableSet.Builder result = ImmutableSet.builder();
                result.addAll((Iterable)JavaClassDependencies.this.dependenciesFromAccesses(JavaClassDependencies.this.javaClass.getAccessesFromSelf()));
                result.addAll((Iterable)JavaClassDependencies.this.inheritanceDependenciesFromSelf());
                result.addAll((Iterable)JavaClassDependencies.this.fieldDependenciesFromSelf());
                result.addAll((Iterable)JavaClassDependencies.this.returnTypeDependenciesFromSelf());
                result.addAll((Iterable)JavaClassDependencies.this.codeUnitParameterDependenciesFromSelf());
                result.addAll((Iterable)JavaClassDependencies.this.throwsDeclarationDependenciesFromSelf());
                result.addAll((Iterable)JavaClassDependencies.this.annotationDependenciesFromSelf());
                result.addAll((Iterable)JavaClassDependencies.this.instanceofCheckDependenciesFromSelf());
                result.addAll((Iterable)JavaClassDependencies.this.referencedClassObjectDependenciesFromSelf());
                result.addAll((Iterable)JavaClassDependencies.this.typeParameterDependenciesFromSelf());
                return result.build();
            }
        });
    }

    Set<Dependency> getDirectDependenciesFromClass() {
        return this.directDependenciesFromClass.get();
    }

    private Set<Dependency> dependenciesFromAccesses(Set<JavaAccess<?>> accesses) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (JavaAccess<?> access : accesses) {
            result.addAll(Dependency.tryCreateFromAccess(access));
        }
        return result.build();
    }

    private Set<Dependency> inheritanceDependenciesFromSelf() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (JavaClass supertype : FluentIterable.from(this.javaClass.getRawInterfaces()).append((Iterable<JavaClass>)this.javaClass.getRawSuperclass().asSet())) {
            result.add(Dependency.fromInheritance(this.javaClass, supertype));
        }
        result.addAll(this.genericSuperclassTypeArgumentDependencies());
        result.addAll(this.genericInterfaceTypeArgumentDependencies());
        return result.build();
    }

    private Set<Dependency> genericSuperclassTypeArgumentDependencies() {
        if (!this.javaClass.getSuperclass().isPresent() || !(this.javaClass.getSuperclass().get() instanceof JavaParameterizedType)) {
            return Collections.emptySet();
        }
        JavaParameterizedType genericSuperclass = (JavaParameterizedType)this.javaClass.getSuperclass().get();
        List<JavaType> actualTypeArguments = genericSuperclass.getActualTypeArguments();
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (JavaClass superclassTypeArgumentDependency : this.dependenciesOfTypes(actualTypeArguments)) {
            result.addAll(Dependency.tryCreateFromGenericSuperclassTypeArguments(this.javaClass, genericSuperclass, superclassTypeArgumentDependency));
        }
        return result.build();
    }

    private Set<Dependency> genericInterfaceTypeArgumentDependencies() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (JavaParameterizedType genericInterface : JavaClassDependencies.getGenericInterfacesOf(this.javaClass)) {
            List<JavaType> actualTypeArguments = genericInterface.getActualTypeArguments();
            for (JavaClass interfaceTypeArgumentDependency : this.dependenciesOfTypes(actualTypeArguments)) {
                result.addAll(Dependency.tryCreateFromGenericInterfaceTypeArgument(this.javaClass, genericInterface, interfaceTypeArgumentDependency));
            }
        }
        return result.build();
    }

    private static Iterable<JavaParameterizedType> getGenericInterfacesOf(JavaClass javaClass) {
        return FluentIterable.from(javaClass.getInterfaces()).filter(Predicates.instanceOf(JavaParameterizedType.class));
    }

    private Set<Dependency> fieldDependenciesFromSelf() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (JavaField field : this.javaClass.getFields()) {
            result.addAll(Dependency.tryCreateFromField(field));
            result.addAll(this.genericFieldTypeArgumentDependencies(field));
        }
        return result.build();
    }

    private Set<Dependency> genericFieldTypeArgumentDependencies(JavaField field) {
        if (!(field.getType() instanceof JavaParameterizedType)) {
            return Collections.emptySet();
        }
        JavaParameterizedType fieldType = (JavaParameterizedType)field.getType();
        List<JavaType> actualTypeArguments = fieldType.getActualTypeArguments();
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (JavaClass fieldTypeArgumentDependency : this.dependenciesOfTypes(actualTypeArguments)) {
            result.addAll(Dependency.tryCreateFromGenericFieldTypeArgument(field, fieldTypeArgumentDependency));
        }
        return result.build();
    }

    private Set<Dependency> returnTypeDependenciesFromSelf() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (JavaMethod method : this.javaClass.getMethods()) {
            result.addAll(Dependency.tryCreateFromReturnType(method));
            result.addAll(this.genericReturnTypeArgumentDependencies(method));
        }
        return result.build();
    }

    private Set<Dependency> genericReturnTypeArgumentDependencies(JavaMethod method) {
        if (!(method.getReturnType() instanceof JavaParameterizedType)) {
            return Collections.emptySet();
        }
        JavaParameterizedType returnType = (JavaParameterizedType)method.getReturnType();
        List<JavaType> actualTypeArguments = returnType.getActualTypeArguments();
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (JavaClass returnTypeArgumentDependency : this.dependenciesOfTypes(actualTypeArguments)) {
            result.addAll(Dependency.tryCreateFromGenericMethodReturnTypeArgument(method, returnTypeArgumentDependency));
        }
        return result.build();
    }

    private Set<Dependency> codeUnitParameterDependenciesFromSelf() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (JavaCodeUnit codeUnit : this.javaClass.getCodeUnits()) {
            for (JavaClass parameter : codeUnit.getRawParameterTypes()) {
                result.addAll(Dependency.tryCreateFromParameter(codeUnit, parameter));
            }
            result.addAll(this.genericParameterTypeArgumentDependencies(codeUnit));
        }
        return result.build();
    }

    private Set<Dependency> genericParameterTypeArgumentDependencies(JavaCodeUnit codeUnit) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (JavaType parameterType : codeUnit.getParameterTypes()) {
            if (!(parameterType instanceof JavaParameterizedType)) continue;
            for (JavaClass parameterTypeDependency : JavaClassDependencies.dependenciesOfParameterizedType((JavaParameterizedType)parameterType)) {
                result.addAll(Dependency.tryCreateFromGenericCodeUnitParameterTypeArgument(codeUnit, parameterType, parameterTypeDependency));
            }
        }
        return result.build();
    }

    private Set<Dependency> throwsDeclarationDependenciesFromSelf() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (JavaCodeUnit codeUnit : this.javaClass.getCodeUnits()) {
            for (ThrowsDeclaration<? extends JavaCodeUnit> throwsDeclaration : codeUnit.getThrowsClause()) {
                result.addAll(Dependency.tryCreateFromThrowsDeclaration(throwsDeclaration));
            }
        }
        return result.build();
    }

    private Set<Dependency> annotationDependenciesFromSelf() {
        return ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)new ImmutableSet.Builder().addAll(this.annotationDependencies(this.javaClass))).addAll(this.annotationDependencies((HasDescription & HasAnnotations<?>)this.javaClass.getFields()))).addAll(this.annotationDependencies((HasDescription & HasAnnotations<?>)this.javaClass.getMethods()))).addAll(this.parameterAnnotationDependencies(this.javaClass.getMethods()))).addAll(this.annotationDependencies((HasDescription & HasAnnotations<?>)this.javaClass.getConstructors()))).addAll(this.parameterAnnotationDependencies(this.javaClass.getConstructors()))).build();
    }

    private Set<Dependency> instanceofCheckDependenciesFromSelf() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (JavaCodeUnit codeUnit : this.javaClass.getCodeUnits()) {
            for (InstanceofCheck instanceofCheck : codeUnit.getInstanceofChecks()) {
                result.addAll(Dependency.tryCreateFromInstanceofCheck(instanceofCheck));
            }
        }
        return result.build();
    }

    private Set<Dependency> referencedClassObjectDependenciesFromSelf() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (ReferencedClassObject referencedClassObject : this.javaClass.getReferencedClassObjects()) {
            result.addAll(Dependency.tryCreateFromReferencedClassObject(referencedClassObject));
        }
        return result.build();
    }

    private Set<Dependency> typeParameterDependenciesFromSelf() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        result.addAll(this.classTypeParameterDependenciesFromSelf());
        result.addAll(this.codeUnitTypeParameterDependenciesFromSelf());
        return result.build();
    }

    private ImmutableSet<Dependency> classTypeParameterDependenciesFromSelf() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (JavaTypeVariable<JavaClass> typeVariable : this.javaClass.getTypeParameters()) {
            result.addAll(this.getDependenciesFromTypeParameter(typeVariable));
        }
        return result.build();
    }

    private ImmutableSet<Dependency> codeUnitTypeParameterDependenciesFromSelf() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (JavaCodeUnit codeUnit : this.javaClass.getCodeUnits()) {
            for (JavaTypeVariable<? extends JavaCodeUnit> javaTypeVariable : codeUnit.getTypeParameters()) {
                result.addAll(this.getDependenciesFromTypeParameter(javaTypeVariable));
            }
        }
        return result.build();
    }

    private Set<Dependency> getDependenciesFromTypeParameter(JavaTypeVariable<?> typeVariable) {
        ImmutableSet.Builder dependenciesBuilder = ImmutableSet.builder();
        for (JavaClass typeParameterDependency : this.dependenciesOfTypes(typeVariable.getUpperBounds())) {
            dependenciesBuilder.addAll(Dependency.tryCreateFromTypeParameter(typeVariable, typeParameterDependency));
        }
        return dependenciesBuilder.build();
    }

    private Set<JavaClass> dependenciesOfTypes(Iterable<JavaType> types) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (JavaType type : types) {
            for (JavaClass typeParameterDependency : JavaClassDependencies.dependenciesOfType(type)) {
                result.add(typeParameterDependency);
            }
        }
        return result.build();
    }

    private static Iterable<JavaClass> dependenciesOfType(JavaType javaType) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        if (javaType instanceof JavaClass) {
            result.add((JavaClass)javaType);
        } else if (javaType instanceof JavaParameterizedType) {
            result.addAll(JavaClassDependencies.dependenciesOfParameterizedType((JavaParameterizedType)javaType));
        } else if (javaType instanceof JavaWildcardType) {
            result.addAll(JavaClassDependencies.dependenciesOfWildcardType((JavaWildcardType)javaType));
        }
        return result.build();
    }

    private static Set<JavaClass> dependenciesOfParameterizedType(JavaParameterizedType parameterizedType) {
        ImmutableCollection.ArrayBasedBuilder result = ImmutableSet.builder().add(parameterizedType.toErasure());
        for (JavaType typeArgument : parameterizedType.getActualTypeArguments()) {
            ((ImmutableSet.Builder)result).addAll(JavaClassDependencies.dependenciesOfType(typeArgument));
        }
        return ((ImmutableSet.Builder)result).build();
    }

    private static Set<JavaClass> dependenciesOfWildcardType(JavaWildcardType javaType) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (JavaType bound : Iterables.concat(javaType.getUpperBounds(), javaType.getLowerBounds())) {
            result.addAll(JavaClassDependencies.dependenciesOfType(bound));
        }
        return result.build();
    }

    private Set<Dependency> parameterAnnotationDependencies(Set<? extends JavaCodeUnit> codeUnits) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (JavaCodeUnit javaCodeUnit : codeUnits) {
            result.addAll(this.annotationDependencies((HasDescription & HasAnnotations<?>)javaCodeUnit.getParameters()));
        }
        return result.build();
    }

    private <T extends HasDescription & HasAnnotations<?>> Set<Dependency> annotationDependencies(Collection<T> annotatedObjects) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (HasDescription annotated : annotatedObjects) {
            result.addAll(this.annotationDependencies(annotated));
        }
        return result.build();
    }

    private <T extends HasDescription & HasAnnotations<?>> Set<Dependency> annotationDependencies(T annotated) {
        final ImmutableSet.Builder result = ImmutableSet.builder();
        for (final JavaAnnotation<?> annotation : ((HasAnnotations<?>)annotated).getAnnotations()) {
            result.addAll(Dependency.tryCreateFromAnnotation(annotation));
            annotation.accept(new JavaAnnotation.DefaultParameterVisitor(){

                @Override
                public void visitClass(String propertyName, JavaClass javaClass) {
                    result.addAll(Dependency.tryCreateFromAnnotationMember(annotation, javaClass));
                }

                @Override
                public void visitEnumConstant(String propertyName, JavaEnumConstant enumConstant) {
                    result.addAll(Dependency.tryCreateFromAnnotationMember(annotation, enumConstant.getDeclaringClass()));
                }

                @Override
                public void visitAnnotation(String propertyName, JavaAnnotation<?> memberAnnotation) {
                    result.addAll(Dependency.tryCreateFromAnnotationMember(annotation, memberAnnotation.getRawType()));
                    memberAnnotation.accept(this);
                }
            });
        }
        return result.build();
    }
}

