/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaCodeUnit;
import com.tngtech.archunit.core.domain.JavaType;
import com.tngtech.archunit.core.domain.SourceCodeLocation;
import com.tngtech.archunit.core.domain.properties.HasOwner;
import com.tngtech.archunit.core.domain.properties.HasSourceCodeLocation;
import com.tngtech.archunit.core.domain.properties.HasType;
import com.tngtech.archunit.thirdparty.com.google.common.base.MoreObjects;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;

public final class InstanceofCheck
implements HasType,
HasOwner<JavaCodeUnit>,
HasSourceCodeLocation {
    private final JavaCodeUnit owner;
    private final JavaClass target;
    private final int lineNumber;
    private final SourceCodeLocation sourceCodeLocation;

    private InstanceofCheck(JavaCodeUnit owner, JavaClass target, int lineNumber) {
        this.owner = Preconditions.checkNotNull(owner);
        this.target = Preconditions.checkNotNull(target);
        this.lineNumber = lineNumber;
        this.sourceCodeLocation = SourceCodeLocation.of(owner.getOwner(), lineNumber);
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClass getRawType() {
        return this.target;
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaType getType() {
        return this.target;
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaCodeUnit getOwner() {
        return this.owner;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public SourceCodeLocation getSourceCodeLocation() {
        return this.sourceCodeLocation;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("owner", this.owner).add("target", this.target).add("lineNumber", this.lineNumber).toString();
    }

    static InstanceofCheck from(JavaCodeUnit owner, JavaClass target, int lineNumber) {
        return new InstanceofCheck(owner, target, lineNumber);
    }
}

