/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.core.domain.JavaClassDescriptor;
import com.tngtech.archunit.thirdparty.com.google.common.base.Joiner;
import com.tngtech.archunit.thirdparty.com.google.common.base.Strings;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;

public final class Formatters {
    private Formatters() {
    }

    private static String format(String ownerName, String methodName, String parameters) {
        return ownerName + "." + methodName + "(" + parameters + ")";
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static String formatMethodSimple(String ownerName, String methodName, List<String> parameters) {
        ArrayList<String> simpleParams = new ArrayList<String>();
        for (String parameter : parameters) {
            simpleParams.add(Formatters.ensureSimpleName(parameter));
        }
        return Formatters.formatMethod(Formatters.ensureSimpleName(ownerName), methodName, simpleParams);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static String formatMethod(String ownerName, String methodName, List<String> parameters) {
        return Formatters.format(ownerName, methodName, Formatters.formatMethodParameterTypeNames(parameters));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static String formatMethodParameterTypeNames(List<String> typeNames) {
        return Joiner.on(", ").join(typeNames);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static String formatThrowsDeclarationTypeNames(List<String> typeNames) {
        return Joiner.on(", ").join(typeNames);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static List<String> formatNamesOf(Class<?> ... paramTypes) {
        return Formatters.formatNamesOf(ImmutableList.copyOf(paramTypes));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static List<String> formatNamesOf(Iterable<Class<?>> paramTypes) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (Class<?> paramType : paramTypes) {
            result.add(paramType.getName());
        }
        return result.build();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static String ensureSimpleName(String name) {
        int lastIndexOfDot = name.lastIndexOf(46);
        String partAfterDot = lastIndexOfDot >= 0 ? name.substring(lastIndexOfDot + 1) : name;
        int lastIndexOf$ = partAfterDot.lastIndexOf(36);
        String simpleNameCandidate = lastIndexOf$ >= 0 ? partAfterDot.substring(lastIndexOf$ + 1) : partAfterDot;
        for (int i = 0; i < simpleNameCandidate.length(); ++i) {
            if (!Character.isJavaIdentifierStart(simpleNameCandidate.charAt(i))) continue;
            return simpleNameCandidate.substring(i);
        }
        return "";
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static String ensureCanonicalArrayTypeName(String typeName) {
        if (Formatters.isNoArrayClassName(typeName)) {
            return typeName;
        }
        JavaClassDescriptor descriptor = JavaClassDescriptor.From.name(typeName);
        int dimensions = 0;
        while (descriptor.tryGetComponentType().isPresent()) {
            descriptor = descriptor.tryGetComponentType().get();
            ++dimensions;
        }
        return descriptor.getFullyQualifiedClassName() + Strings.repeat("[]", dimensions);
    }

    private static boolean isNoArrayClassName(String typeName) {
        return !typeName.startsWith("[");
    }
}

