/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain;

import com.tngtech.archunit.base.Function;
import com.tngtech.archunit.thirdparty.com.google.common.base.Joiner;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

class AnnotationPropertiesFormatter {
    private final Function<List<String>, String> arrayFormatter;
    private final Function<Class<?>, String> typeFormatter;
    private final Function<String, String> stringFormatter;
    private final boolean omitOptionalIdentifierForSingleElementAnnotations;

    private AnnotationPropertiesFormatter(Builder builder) {
        this.arrayFormatter = Preconditions.checkNotNull(builder.arrayFormatter);
        this.typeFormatter = Preconditions.checkNotNull(builder.typeFormatter);
        this.stringFormatter = Preconditions.checkNotNull(builder.stringFormatter);
        this.omitOptionalIdentifierForSingleElementAnnotations = builder.omitOptionalIdentifierForSingleElementAnnotations;
    }

    String formatProperties(Map<String, Object> properties) {
        if (properties.size() == 1 && properties.containsKey("value") && this.omitOptionalIdentifierForSingleElementAnnotations) {
            return this.formatValue(properties.get("value"));
        }
        HashSet<String> formattedProperties = new HashSet<String>();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            formattedProperties.add(entry.getKey() + "=" + this.formatValue(entry.getValue()));
        }
        return Joiner.on(", ").join(formattedProperties);
    }

    String formatValue(Object input) {
        if (input instanceof Class) {
            return this.typeFormatter.apply((Class)input);
        }
        if (input instanceof String) {
            return this.stringFormatter.apply((String)input);
        }
        if (!input.getClass().isArray()) {
            return String.valueOf(input);
        }
        ArrayList<String> elemToString = new ArrayList<String>();
        for (int i = 0; i < Array.getLength(input); ++i) {
            elemToString.add(this.formatValue(Array.get(input, i)));
        }
        return this.arrayFormatter.apply(elemToString);
    }

    static Builder configure() {
        return new Builder();
    }

    static class Builder {
        private Function<List<String>, String> arrayFormatter;
        private Function<Class<?>, String> typeFormatter;
        private Function<String, String> stringFormatter = Function.Functions.identity();
        private boolean omitOptionalIdentifierForSingleElementAnnotations = false;

        Builder() {
        }

        Builder formattingArraysWithSquareBrackets() {
            this.arrayFormatter = new Function<List<String>, String>(){

                @Override
                public String apply(List<String> input) {
                    return "[" + Joiner.on(", ").join(input) + "]";
                }
            };
            return this;
        }

        Builder formattingArraysWithCurlyBrackets() {
            this.arrayFormatter = new Function<List<String>, String>(){

                @Override
                public String apply(List<String> input) {
                    return "{" + Joiner.on(", ").join(input) + "}";
                }
            };
            return this;
        }

        Builder formattingTypesToString() {
            this.typeFormatter = new Function<Class<?>, String>(){

                @Override
                public String apply(Class<?> input) {
                    return String.valueOf(input);
                }
            };
            return this;
        }

        Builder formattingTypesAsClassNames() {
            this.typeFormatter = new Function<Class<?>, String>(){

                @Override
                public String apply(Class<?> input) {
                    return input.getName() + ".class";
                }
            };
            return this;
        }

        Builder quotingStrings() {
            this.stringFormatter = new Function<String, String>(){

                @Override
                public String apply(String input) {
                    return "\"" + input + "\"";
                }
            };
            return this;
        }

        Builder omitOptionalIdentifierForSingleElementAnnotations() {
            this.omitOptionalIdentifierForSingleElementAnnotations = true;
            return this;
        }

        AnnotationPropertiesFormatter build() {
            return new AnnotationPropertiesFormatter(this);
        }
    }
}

