/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.ChainableFunction;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.base.Guava;
import com.tngtech.archunit.base.HasDescription;
import com.tngtech.archunit.base.Optional;
import com.tngtech.archunit.core.domain.JavaAnnotation;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaCodeUnit;
import com.tngtech.archunit.core.domain.JavaConstructor;
import com.tngtech.archunit.core.domain.JavaField;
import com.tngtech.archunit.core.domain.JavaMember;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.core.domain.JavaType;
import com.tngtech.archunit.core.domain.ThrowsClause;
import com.tngtech.archunit.core.domain.properties.CanBeAnnotated;
import com.tngtech.archunit.core.domain.properties.HasName;
import com.tngtech.archunit.core.domain.properties.HasOwner;
import com.tngtech.archunit.core.domain.properties.HasParameterTypes;
import com.tngtech.archunit.core.domain.properties.HasReturnType;
import com.tngtech.archunit.core.domain.properties.HasThrowsClause;
import com.tngtech.archunit.core.domain.properties.HasType;
import com.tngtech.archunit.core.importer.DomainBuilders;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.base.Predicate;
import com.tngtech.archunit.thirdparty.com.google.common.base.Supplier;
import com.tngtech.archunit.thirdparty.com.google.common.base.Suppliers;
import com.tngtech.archunit.thirdparty.com.google.common.collect.FluentIterable;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Iterables;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public abstract class AccessTarget
implements HasName.AndFullName,
CanBeAnnotated,
HasOwner<JavaClass>,
HasDescription {
    private final String name;
    private final JavaClass owner;
    private final String fullName;

    AccessTarget(JavaClass owner, String name, String fullName) {
        this.name = name;
        this.owner = owner;
        this.fullName = fullName;
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public String getName() {
        return this.name;
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClass getOwner() {
        return this.owner;
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public String getFullName() {
        return this.fullName;
    }

    public int hashCode() {
        return Objects.hash(this.fullName);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public abstract Set<? extends JavaMember> resolve();

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AccessTarget other = (AccessTarget)obj;
        return Objects.equals(this.fullName, other.fullName);
    }

    public String toString() {
        return "target{" + this.fullName + '}';
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isAnnotatedWith(Class<? extends Annotation> annotationType) {
        return this.isAnnotatedWith(annotationType.getName());
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isAnnotatedWith(final String annotationTypeName) {
        return this.anyMember(new Predicate<JavaMember>(){

            @Override
            public boolean apply(JavaMember input) {
                return input.isAnnotatedWith(annotationTypeName);
            }
        });
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isAnnotatedWith(final DescribedPredicate<? super JavaAnnotation<?>> predicate) {
        return this.anyMember(new Predicate<JavaMember>(){

            @Override
            public boolean apply(JavaMember input) {
                return input.isAnnotatedWith(predicate);
            }
        });
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isMetaAnnotatedWith(Class<? extends Annotation> annotationType) {
        return this.isMetaAnnotatedWith(annotationType.getName());
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isMetaAnnotatedWith(final String annotationTypeName) {
        return this.anyMember(new Predicate<JavaMember>(){

            @Override
            public boolean apply(JavaMember input) {
                return input.isMetaAnnotatedWith(annotationTypeName);
            }
        });
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isMetaAnnotatedWith(final DescribedPredicate<? super JavaAnnotation<?>> predicate) {
        return this.anyMember(new Predicate<JavaMember>(){

            @Override
            public boolean apply(JavaMember input) {
                return input.isMetaAnnotatedWith(predicate);
            }
        });
    }

    private boolean anyMember(Predicate<JavaMember> predicate) {
        for (JavaMember javaMember : this.resolve()) {
            if (!predicate.apply(javaMember)) continue;
            return true;
        }
        return false;
    }

    public static final class Predicates {
        private Predicates() {
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<AccessTarget> declaredIn(Class<?> clazz) {
            return Predicates.declaredIn(clazz.getName());
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<AccessTarget> declaredIn(String className) {
            return Predicates.declaredIn(HasName.Functions.GET_NAME.is(DescribedPredicate.equalTo(className)).as(className, new Object[0]));
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<AccessTarget> declaredIn(DescribedPredicate<? super JavaClass> predicate) {
            return HasOwner.Functions.Get.owner().is(predicate).as("declared in %s", predicate.getDescription()).forSubtype();
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<AccessTarget> constructor() {
            return new DescribedPredicate<AccessTarget>("constructor", new Object[0]){

                @Override
                public boolean apply(AccessTarget input) {
                    return "<init>".equals(input.getName());
                }
            };
        }
    }

    public static final class MethodCallTarget
    extends CodeUnitCallTarget {
        private final Supplier<Set<JavaMethod>> methods;

        MethodCallTarget(DomainBuilders.MethodCallTargetBuilder builder) {
            super(builder);
            this.methods = Suppliers.memoize(builder.getMethods());
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public Set<JavaMethod> resolve() {
            return this.methods.get();
        }

        @Override
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public String getDescription() {
            return "method <" + this.getFullName() + ">";
        }

        public static final class Functions {
            @PublicAPI(usage=PublicAPI.Usage.ACCESS)
            public static final ChainableFunction<MethodCallTarget, Set<JavaMethod>> RESOLVE = new ChainableFunction<MethodCallTarget, Set<JavaMethod>>(){

                @Override
                public Set<JavaMethod> apply(MethodCallTarget input) {
                    return input.resolve();
                }
            };

            private Functions() {
            }
        }
    }

    public static final class ConstructorCallTarget
    extends CodeUnitCallTarget {
        private final Supplier<Optional<JavaConstructor>> constructor;

        ConstructorCallTarget(DomainBuilders.ConstructorCallTargetBuilder builder) {
            super(builder);
            this.constructor = builder.getConstructor();
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public Optional<JavaConstructor> resolveConstructor() {
            return this.constructor.get();
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public Set<JavaConstructor> resolve() {
            return this.resolveConstructor().asSet();
        }

        @Override
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public String getDescription() {
            return "constructor <" + this.getFullName() + ">";
        }

        public static final class Functions {
            @PublicAPI(usage=PublicAPI.Usage.ACCESS)
            public static final ChainableFunction<ConstructorCallTarget, Set<JavaConstructor>> RESOLVE = new ChainableFunction<ConstructorCallTarget, Set<JavaConstructor>>(){

                @Override
                public Set<JavaConstructor> apply(ConstructorCallTarget input) {
                    return input.resolve();
                }
            };

            private Functions() {
            }
        }
    }

    public static abstract class CodeUnitCallTarget
    extends AccessTarget
    implements HasParameterTypes,
    HasReturnType,
    HasThrowsClause<CodeUnitCallTarget> {
        private final ImmutableList<JavaClass> parameters;
        private final JavaClass returnType;

        CodeUnitCallTarget(DomainBuilders.CodeUnitCallTargetBuilder<?> builder) {
            super(builder.getOwner(), builder.getName(), builder.getFullName());
            this.parameters = ImmutableList.copyOf(builder.getParameters());
            this.returnType = builder.getReturnType();
        }

        @Override
        public List<JavaType> getParameterTypes() {
            return this.parameters;
        }

        @Override
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public List<JavaClass> getRawParameterTypes() {
            return this.parameters;
        }

        @Override
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public JavaType getReturnType() {
            return this.returnType;
        }

        @Override
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public JavaClass getRawReturnType() {
            return this.returnType;
        }

        @Override
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public ThrowsClause<CodeUnitCallTarget> getThrowsClause() {
            ImmutableList<ThrowsClause<JavaCodeUnit>> resolvedThrowsClauses = FluentIterable.from(this.resolve()).transform(Guava.toGuava(JavaCodeUnit.Functions.Get.throwsClause())).toList();
            if (resolvedThrowsClauses.isEmpty()) {
                return ThrowsClause.empty(this);
            }
            if (resolvedThrowsClauses.size() == 1) {
                return ThrowsClause.from(this, Iterables.getOnlyElement(resolvedThrowsClauses).getTypes());
            }
            return ThrowsClause.from(this, this.intersectTypesOf(resolvedThrowsClauses));
        }

        private List<JavaClass> intersectTypesOf(List<ThrowsClause<JavaCodeUnit>> throwsClauses) {
            Preconditions.checkArgument(throwsClauses.size() > 1, "Can only intersect more than one throws clause");
            ArrayList<JavaClass> result = new ArrayList<JavaClass>(throwsClauses.get(0).getTypes());
            for (ThrowsClause<JavaCodeUnit> throwsClause : throwsClauses.subList(1, throwsClauses.size())) {
                result.retainAll(throwsClause.getTypes());
            }
            return result;
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public abstract Set<? extends JavaCodeUnit> resolve();

        public static final class Functions {
            @PublicAPI(usage=PublicAPI.Usage.ACCESS)
            public static final ChainableFunction<CodeUnitCallTarget, Set<JavaCodeUnit>> RESOLVE = new ChainableFunction<CodeUnitCallTarget, Set<JavaCodeUnit>>(){

                @Override
                public Set<JavaCodeUnit> apply(CodeUnitCallTarget input) {
                    return input.resolve();
                }
            };

            private Functions() {
            }
        }
    }

    public static final class FieldAccessTarget
    extends AccessTarget
    implements HasType {
        private final JavaClass type;
        private final Supplier<Optional<JavaField>> field;

        FieldAccessTarget(DomainBuilders.FieldAccessTargetBuilder builder) {
            super(builder.getOwner(), builder.getName(), builder.getFullName());
            this.type = builder.getType();
            this.field = Suppliers.memoize(builder.getField());
        }

        @Override
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public JavaType getType() {
            return this.type;
        }

        @Override
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public JavaClass getRawType() {
            return this.type;
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public Optional<JavaField> resolveField() {
            return this.field.get();
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public Set<JavaField> resolve() {
            return this.resolveField().asSet();
        }

        @Override
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public String getDescription() {
            return "field <" + this.getFullName() + ">";
        }

        public static final class Functions {
            @PublicAPI(usage=PublicAPI.Usage.ACCESS)
            public static final ChainableFunction<FieldAccessTarget, Set<JavaField>> RESOLVE = new ChainableFunction<FieldAccessTarget, Set<JavaField>>(){

                @Override
                public Set<JavaField> apply(FieldAccessTarget input) {
                    return input.resolve();
                }
            };

            private Functions() {
            }
        }
    }

    public static final class Functions {
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<AccessTarget, Set<JavaMember>> RESOLVE = new ChainableFunction<AccessTarget, Set<JavaMember>>(){

            @Override
            public Set<JavaMember> apply(AccessTarget input) {
                return input.resolve();
            }
        };

        private Functions() {
        }
    }
}

