/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.base;

import com.tngtech.archunit.PublicAPI;

@PublicAPI(usage=PublicAPI.Usage.INHERITANCE)
public interface Predicate<T> {
    public boolean apply(T var1);

    public static class Defaults {
        private static final Predicate<Object> ALWAYS_TRUE = new Predicate<Object>(){

            @Override
            public boolean apply(Object input) {
                return true;
            }
        };
        private static final Predicate<Object> ALWAYS_FALSE = new Predicate<Object>(){

            @Override
            public boolean apply(Object input) {
                return false;
            }
        };

        private Defaults() {
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static <T> Predicate<T> alwaysTrue() {
            return ALWAYS_TRUE;
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static <T> Predicate<T> alwaysFalse() {
            return ALWAYS_FALSE;
        }
    }
}

