/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.base;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.base.PackageMatcher;
import com.tngtech.archunit.thirdparty.com.google.common.base.Joiner;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public final class PackageMatchers
extends DescribedPredicate<String> {
    private final Set<PackageMatcher> packageMatchers;

    private PackageMatchers(Set<String> packageIdentifiers) {
        super("matches any of ['%s']", Joiner.on("', '").join(packageIdentifiers));
        ImmutableSet.Builder matchers = ImmutableSet.builder();
        for (String identifier : packageIdentifiers) {
            matchers.add(PackageMatcher.of(identifier));
        }
        this.packageMatchers = matchers.build();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static PackageMatchers of(String ... packageIdentifiers) {
        return PackageMatchers.of(ImmutableSet.copyOf(packageIdentifiers));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static PackageMatchers of(Collection<String> packageIdentifiers) {
        return new PackageMatchers(ImmutableSet.copyOf(packageIdentifiers));
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean apply(String aPackage) {
        boolean matches = false;
        for (PackageMatcher matcher : this.packageMatchers) {
            matches = matches || matcher.matches(aPackage);
        }
        return matches;
    }
}

