/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.base;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.Function;
import com.tngtech.archunit.base.Optional;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PackageMatcher {
    private static final String OPT_LETTERS_AT_START = "(?:^\\w*)?";
    private static final String OPT_LETTERS_AT_END = "(?:\\w*$)?";
    private static final String ARBITRARY_PACKAGES = "\\.(?:\\w+\\.)*";
    private static final String TWO_DOTS_REGEX = String.format("(?:%s%s%s)?", "(?:^\\w*)?", "\\.(?:\\w+\\.)*", "(?:\\w*$)?");
    private static final String TWO_STAR_CAPTURE_LITERAL = "(**)";
    private static final String TWO_STAR_CAPTURE_REGEX = "(\\w+(?:\\.\\w+)*)";
    static final String TWO_STAR_REGEX_MARKER = "#%#%#";
    private static final Set<Character> PACKAGE_CONTROL_SYMBOLS = ImmutableSet.of(Character.valueOf('*'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('.'));
    private final String packageIdentifier;
    private final Pattern packagePattern;
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final Function<Result, List<String>> TO_GROUPS = new Function<Result, List<String>>(){

        @Override
        public List<String> apply(Result input) {
            ArrayList<String> result = new ArrayList<String>();
            for (int i = 0; i < input.getNumberOfGroups(); ++i) {
                result.add(input.getGroup(i + 1));
            }
            return result;
        }
    };

    private PackageMatcher(String packageIdentifier) {
        this.validate(packageIdentifier);
        this.packageIdentifier = packageIdentifier;
        this.packagePattern = Pattern.compile(this.convertToRegex(packageIdentifier));
    }

    private void validate(String packageIdentifier) {
        if (packageIdentifier.contains("...")) {
            throw new IllegalArgumentException("Package Identifier may not contain more than two '.' in a row");
        }
        if (packageIdentifier.replace(TWO_STAR_CAPTURE_LITERAL, "").contains("**")) {
            throw new IllegalArgumentException("Package Identifier may not contain more than one '*' in a row");
        }
        if (packageIdentifier.contains("(..)")) {
            throw new IllegalArgumentException("Package Identifier does not support capturing via (..), use (**) instead");
        }
        this.validateCharacters(packageIdentifier);
    }

    private void validateCharacters(String packageIdentifier) {
        for (int i = 0; i < packageIdentifier.length(); ++i) {
            char c = packageIdentifier.charAt(i);
            if (Character.isJavaIdentifierPart(c) || PACKAGE_CONTROL_SYMBOLS.contains(Character.valueOf(c))) continue;
            throw new IllegalArgumentException(String.format("Package Identifier '%s' may only consist of valid java identifier parts or the symbols '.)(*'", packageIdentifier));
        }
    }

    private String convertToRegex(String packageIdentifier) {
        return packageIdentifier.replace(TWO_STAR_CAPTURE_LITERAL, TWO_STAR_REGEX_MARKER).replace("*", "\\w+").replace(".", "\\.").replace(TWO_STAR_REGEX_MARKER, TWO_STAR_CAPTURE_REGEX).replace("\\.\\.", TWO_DOTS_REGEX);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static PackageMatcher of(String packageIdentifier) {
        return new PackageMatcher(packageIdentifier);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean matches(String aPackage) {
        return this.packagePattern.matcher(aPackage).matches();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Optional<Result> match(String aPackage) {
        Matcher matcher = this.packagePattern.matcher(aPackage);
        return matcher.matches() ? Optional.of(new Result(matcher)) : Optional.empty();
    }

    public String toString() {
        return "PackageMatcher{" + this.packageIdentifier + '}';
    }

    public static final class Result {
        private final Matcher matcher;

        private Result(Matcher matcher) {
            this.matcher = matcher;
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public int getNumberOfGroups() {
            return this.matcher.groupCount();
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public String getGroup(int number) {
            return this.matcher.group(number);
        }
    }
}

