/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.base;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.Function;
import com.tngtech.archunit.base.Supplier;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public abstract class Optional<T> {
    private Optional() {
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <T> Optional<T> of(T object) {
        Preconditions.checkNotNull(object, "Object may not be null");
        return new Present(object);
    }

    @Deprecated
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <T> Optional<T> fromNullable(T object) {
        return Optional.ofNullable(object);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <T> Optional<T> ofNullable(T object) {
        return object == null ? Optional.empty() : new Present(object);
    }

    @Deprecated
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <T> Optional<T> absent() {
        return Optional.empty();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <T> Optional<T> empty() {
        return Empty.getInstance();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public abstract boolean isPresent();

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public abstract T get();

    @Deprecated
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public abstract T getOrThrow(RuntimeException var1);

    @Deprecated
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public T getOrThrow(Supplier<? extends RuntimeException> exceptionSupplier) {
        return this.orElseThrow(exceptionSupplier);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public abstract <X extends Throwable> T orElseThrow(Supplier<? extends X> var1) throws X;

    @Deprecated
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public <U> Optional<U> transform(Function<? super T, U> function) {
        return this.map(function);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public abstract <U> Optional<U> map(Function<? super T, ? extends U> var1);

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public T orNull() {
        return this.orElse(null);
    }

    @Deprecated
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public T or(T value) {
        return this.orElse(value);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public abstract T orElse(T var1);

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public abstract T orElseGet(Supplier<? extends T> var1);

    @Deprecated
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public abstract Optional<T> or(Optional<? extends T> var1);

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public abstract Set<T> asSet();

    private static class Present<T>
    extends Optional<T> {
        private final T object;

        private Present(T object) {
            this.object = object;
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public T get() {
            return this.object;
        }

        @Override
        public T orElse(T value) {
            return this.object;
        }

        @Override
        public T orElseGet(Supplier<? extends T> supplier) {
            return this.object;
        }

        @Override
        public Optional<T> or(Optional<? extends T> value) {
            return this;
        }

        @Override
        public Set<T> asSet() {
            return Collections.singleton(this.object);
        }

        @Override
        public T getOrThrow(RuntimeException e) {
            return this.object;
        }

        @Override
        public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) {
            return this.object;
        }

        @Override
        public <U> Optional<U> map(Function<? super T, ? extends U> mapper) {
            return Optional.of(mapper.apply(this.object));
        }

        public int hashCode() {
            return Objects.hash(this.object);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Present other = (Present)obj;
            return Objects.equals(this.object, other.object);
        }

        public String toString() {
            return Optional.class.getSimpleName() + ".of(" + this.object + ")";
        }
    }

    private static class Empty<T>
    extends Optional<T> {
        private static final Empty<Object> INSTANCE = new Empty();

        private Empty() {
        }

        private static <T> Empty<T> getInstance() {
            return INSTANCE;
        }

        @Override
        public boolean isPresent() {
            return false;
        }

        @Override
        public T get() {
            throw new NullPointerException("Object is absent");
        }

        @Override
        public T orElse(T value) {
            return value;
        }

        @Override
        public T orElseGet(Supplier<? extends T> supplier) {
            return supplier.get();
        }

        @Override
        public Optional<T> or(Optional<? extends T> value) {
            return value;
        }

        @Override
        public Set<T> asSet() {
            return Collections.emptySet();
        }

        @Override
        public T getOrThrow(RuntimeException e) {
            throw e;
        }

        @Override
        public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
            throw (Throwable)exceptionSupplier.get();
        }

        @Override
        public <U> Optional<U> map(Function<? super T, ? extends U> mapper) {
            return Empty.empty();
        }

        public int hashCode() {
            return 1;
        }

        public boolean equals(Object obj) {
            return obj instanceof Empty;
        }

        public String toString() {
            return Optional.class.getSimpleName() + ".empty()";
        }
    }
}

