/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.locks.VMCondition;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalInt;
import com.oracle.svm.core.threadlocal.FastThreadLocalWord;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.WordFactory;

public abstract class VMThreads {
    public static final VMMutex THREAD_MUTEX = new VMMutex();
    public static final VMCondition THREAD_LIST_CONDITION = new VMCondition(THREAD_MUTEX);
    private static IsolateThread head;
    private static final FastThreadLocalWord<IsolateThread> nextTL;
    private static final FastThreadLocalWord<ComparableWord> OSThreadIdTL;
    public static final FastThreadLocalWord<Isolate> IsolateTL;
    private static final int STATE_UNINITIALIZED = 1;
    private static final int STATE_INITIALIZING = 2;
    private static final int STATE_INITIALIZED = 3;
    private static final int STATE_TEARING_DOWN = 4;
    private static final UninterruptibleUtils.AtomicInteger initializationState;

    @Fold
    public static VMThreads singleton() {
        return (VMThreads)ImageSingletons.lookup(VMThreads.class);
    }

    @Uninterruptible(reason="Called from uninterruptible code. Too early for safepoints.")
    public static boolean isInitialized() {
        return initializationState.get() >= 3;
    }

    @Uninterruptible(reason="Called from uninterruptible code during tear down.")
    public static boolean isTearingDown() {
        return initializationState.get() >= 4;
    }

    protected static void setTearingDown() {
        initializationState.set(4);
    }

    @Uninterruptible(reason="Called from uninterruptible code. Too early for safepoints.")
    public static boolean ensureInitialized() {
        boolean result = true;
        if (initializationState.compareAndSet(1, 2)) {
            result = VMThreads.singleton().initializeOnce();
            initializationState.set(3);
        } else {
            while (initializationState.get() < 3) {
            }
        }
        return result;
    }

    @Uninterruptible(reason="Called from uninterruptible code. Too early for safepoints.")
    protected abstract boolean initializeOnce();

    @Uninterruptible(reason="Thread state not set up.")
    public abstract IsolateThread allocateIsolateThread(int var1);

    @Uninterruptible(reason="Thread state not set up.")
    public abstract void freeIsolateThread(IsolateThread var1);

    @Uninterruptible(reason="Unknown thread state.")
    public abstract void failFatally(int var1, CCharPointer var2);

    @Uninterruptible(reason="Called from uninterruptible code.")
    public static IsolateThread nullThread() {
        return (IsolateThread)WordFactory.nullPointer();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isNullThread(IsolateThread vmThread) {
        return vmThread.isNull();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isNonNullThread(IsolateThread vmThread) {
        return vmThread.isNonNull();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static IsolateThread firstThread() {
        return head;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static IsolateThread nextThread(IsolateThread cur) {
        return nextTL.get(cur);
    }

    @Uninterruptible(reason="Reason: Thread register not yet set up.")
    public void attachThread(IsolateThread thread) {
        assert (StatusSupport.isStatusCreated(thread)) : "Status should be initialized on creation.";
        OSThreadIdTL.set(thread, this.getCurrentOSThreadId());
        THREAD_MUTEX.lockNoTransition();
        try {
            THREAD_MUTEX.guaranteeIsLocked("Must hold the VMThreads lock.");
            nextTL.set(thread, head);
            head = thread;
            StatusSupport.setStatusNative(thread);
            THREAD_LIST_CONDITION.broadcast();
        }
        finally {
            THREAD_MUTEX.unlock();
        }
    }

    @Uninterruptible(reason="Manipulates the threads list; broadcasts on changes.")
    public static void detachThread(IsolateThread current) {
        assert (current.equal((ComparableWord)CurrentIsolate.getCurrentThread())) : "Cannot detach different thread with this method";
        StatusSupport.setStatusIgnoreSafepoints();
        THREAD_MUTEX.lockNoTransition();
        try {
            VMThreads.detachThreadInSafeContext(current);
        }
        finally {
            THREAD_MUTEX.unlock();
        }
    }

    @Uninterruptible(reason="Manipulates the threads list; broadcasts on changes.")
    private static void detachThreadInSafeContext(IsolateThread thread) {
        VMThreads.detachJavaThread(thread);
        IsolateThread previous = VMThreads.nullThread();
        IsolateThread current = head;
        while (VMThreads.isNonNullThread(current)) {
            IsolateThread next = nextTL.get(current);
            if (current == thread) {
                if (VMThreads.isNullThread(previous)) {
                    head = next;
                    break;
                }
                nextTL.set(previous, next);
                break;
            }
            previous = current;
            current = next;
        }
        THREAD_LIST_CONDITION.broadcast();
        VMThreads.singleton().freeIsolateThread(thread);
    }

    @Uninterruptible(reason="For calling interruptible code from uninterruptible code.", calleeMustBe=false)
    private static void detachJavaThread(IsolateThread thread) {
        JavaThreads.detachThread(thread);
    }

    public static void detachThreads(IsolateThread[] threads) {
        VMOperation.enqueueBlockingSafepoint("detachThreads", () -> {
            for (IsolateThread thread : threads) {
                assert (!thread.equal((ComparableWord)CurrentIsolate.getCurrentThread())) : "Cannot detach current thread with this method";
                VMThreads.detachThreadInSafeContext(thread);
            }
        });
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected abstract ComparableWord getCurrentOSThreadId();

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public IsolateThread findIsolateThreadforCurrentOSThread() {
        ComparableWord id = this.getCurrentOSThreadId();
        IsolateThread thread = head;
        while (VMThreads.isNonNullThread(thread) && OSThreadIdTL.get(thread).notEqual(id)) {
            thread = VMThreads.nextThread(thread);
        }
        return thread;
    }

    static {
        nextTL = FastThreadLocalFactory.createWord();
        OSThreadIdTL = FastThreadLocalFactory.createWord();
        IsolateTL = FastThreadLocalFactory.createWord();
        initializationState = new UninterruptibleUtils.AtomicInteger(1);
    }

    public static class StatusSupport {
        public static final FastThreadLocalInt statusTL = FastThreadLocalFactory.createInt();
        private static final FastThreadLocalInt safepointsDisabledTL = FastThreadLocalFactory.createInt();
        private static final int STATUS_CREATED = 0;
        public static final int STATUS_IN_JAVA = 1;
        public static final int STATUS_IN_SAFEPOINT = 2;
        public static final int STATUS_IN_NATIVE = 3;

        private static String statusToString(int status, boolean safepointsDisabled) {
            switch (status) {
                case 0: {
                    return safepointsDisabled ? "STATUS_CREATED (safepoints disabled)" : "STATUS_CREATED";
                }
                case 1: {
                    return safepointsDisabled ? "STATUS_IN_JAVA (safepoints disabled)" : "STATUS_IN_JAVA";
                }
                case 2: {
                    return safepointsDisabled ? "STATUS_IN_SAFEPOINT (safepoints disabled)" : "STATUS_IN_SAFEPOINT";
                }
                case 3: {
                    return safepointsDisabled ? "STATUS_IN_NATIVE (safepoints disabled)" : "STATUS_IN_NATIVE";
                }
            }
            return "STATUS error";
        }

        public static String getStatusString(IsolateThread vmThread) {
            return StatusSupport.statusToString(statusTL.getVolatile(vmThread), StatusSupport.isStatusIgnoreSafepoints(vmThread));
        }

        @Uninterruptible(reason="Called from uninterruptible code.")
        public static boolean isStatusCreated(IsolateThread vmThread) {
            return statusTL.getVolatile(vmThread) == 0;
        }

        @Uninterruptible(reason="Called from uninterruptible code.")
        public static boolean isStatusNative(IsolateThread vmThread) {
            return statusTL.getVolatile(vmThread) == 3;
        }

        public static void setStatusNative() {
            statusTL.set(3);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static void setStatusNative(IsolateThread vmThread) {
            statusTL.setVolatile(vmThread, 3);
        }

        @Uninterruptible(reason="Called from uninterruptible code.")
        public static boolean isStatusSafepoint(IsolateThread vmThread) {
            return statusTL.getVolatile(vmThread) == 2;
        }

        public static boolean compareAndSetNativeToSafepoint(IsolateThread vmThread) {
            return statusTL.compareAndSet(vmThread, 3, 2);
        }

        @Uninterruptible(reason="Called from uninterruptible code.")
        public static boolean isStatusJava() {
            return statusTL.getVolatile() == 1;
        }

        @Uninterruptible(reason="Called from uninterruptible code.")
        public static void setStatusJavaUnguarded(IsolateThread vmThread) {
            statusTL.setVolatile(vmThread, 1);
        }

        @Uninterruptible(reason="Called from uninterruptible code.")
        public static boolean compareAndSetNativeToJava() {
            return statusTL.compareAndSet(3, 1);
        }

        @Uninterruptible(reason="Called from uninterruptible code.")
        public static boolean isStatusIgnoreSafepoints(IsolateThread vmThread) {
            return safepointsDisabledTL.getVolatile(vmThread) == 1;
        }

        @Uninterruptible(reason="Called from uninterruptible code.")
        public static void setStatusIgnoreSafepoints() {
            safepointsDisabledTL.setVolatile(1);
        }
    }
}

