/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.JDK8OrEarlier;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.Util_java_io_Console_JDK8OrEarlier;
import com.oracle.svm.core.posix.headers.Termios;
import com.oracle.svm.core.posix.headers.Unistd;
import java.io.Console;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.charset.Charset;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;

@TargetClass(value=Console.class)
@Platforms(value={Platform.LINUX.class, Platform.DARWIN.class})
final class Target_java_io_Console {
    @Alias
    Charset cs;
    @Alias
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    static boolean echoOff;

    @Alias
    Target_java_io_Console() {
    }

    @Substitute
    static String encoding() {
        return null;
    }

    @Substitute
    static boolean istty() {
        return Unistd.isatty(PosixUtils.getFD(FileDescriptor.in)) == 1 && Unistd.isatty(PosixUtils.getFD(FileDescriptor.out)) == 1;
    }

    @Substitute
    static boolean echo(boolean on) throws IOException {
        boolean old;
        if (JavaVersionUtil.Java8OrEarlier) {
            Util_java_io_Console_JDK8OrEarlier.addShutdownHook();
        }
        Termios.termios tio = (Termios.termios)StackValue.get(Termios.termios.class);
        int tty = Unistd.STDIN_FILENO();
        if (Termios.tcgetattr(tty, tio) == -1) {
            throw PosixUtils.newIOExceptionWithLastError("tcgetattr failed");
        }
        boolean bl = old = (tio.get_c_lflag() & (long)Termios.ECHO()) != 0L;
        if (on) {
            tio.set_c_lflag(tio.get_c_lflag() | (long)Termios.ECHO());
        } else {
            tio.set_c_lflag(tio.get_c_lflag() & (long)(~Termios.ECHO()));
        }
        if (Termios.tcsetattr(tty, Termios.TCSANOW(), tio) == -1) {
            throw PosixUtils.newIOExceptionWithLastError("tcsetattr failed");
        }
        return old;
    }
}

