/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.ResourceBundle;
import oracle.security.pki.OracleKeyStoreSpi;
import oracle.security.pki.OraclePKIDebug;
import oracle.security.pki.OracleSSOKeyStoreSpi;
import oracle.security.pki.OracleSecretStoreException;

public class OracleSecretStore {
    static ResourceBundle a = ResourceBundle.getBundle("oracle.security.pki.resources.OraclePKIMsg");
    private OracleKeyStoreSpi b = null;

    protected OracleSecretStore() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAlias(String string) throws OracleSecretStoreException {
        if (this.b == null) {
            throw new OracleSecretStoreException("Secret Store not initialized");
        }
        OracleSecretStore oracleSecretStore = this;
        synchronized (oracleSecretStore) {
            return this.b.secretStoreContainsAlias(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char[] getSecret(String string) throws OracleSecretStoreException {
        if (this.b == null) {
            throw new OracleSecretStoreException("Secret Store not initialized");
        }
        OracleSecretStore oracleSecretStore = this;
        synchronized (oracleSecretStore) {
            return this.b.secretStoreGetSecret(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSecret(String string, char[] cArray) throws OracleSecretStoreException {
        if (this.b == null) {
            throw new OracleSecretStoreException("Secret Store not initialized");
        }
        OracleSecretStore oracleSecretStore = this;
        synchronized (oracleSecretStore) {
            this.b.secretStoreSetSecret(string, cArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSecret(String string) throws OracleSecretStoreException {
        if (this.b == null) {
            throw new OracleSecretStoreException("Secret Store not initialized");
        }
        OracleSecretStore oracleSecretStore = this;
        synchronized (oracleSecretStore) {
            this.b.secretStoreDeleteSecret(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createCredential(char[] cArray, char[] cArray2, char[] cArray3) throws OracleSecretStoreException {
        if (this.b == null) {
            throw new OracleSecretStoreException("Secret Store not initialized");
        }
        OracleSecretStore oracleSecretStore = this;
        synchronized (oracleSecretStore) {
            this.b.secretStoreCreateCredential(cArray, cArray2, cArray3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyCredential(char[] cArray, char[] cArray2, char[] cArray3) throws OracleSecretStoreException {
        if (this.b == null) {
            throw new OracleSecretStoreException("Secret Store not initialized");
        }
        OracleSecretStore oracleSecretStore = this;
        synchronized (oracleSecretStore) {
            this.b.secretStoreModifyCredential(cArray, cArray2, cArray3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCredential(char[] cArray) throws OracleSecretStoreException {
        if (this.b == null) {
            throw new OracleSecretStoreException("Secret Store not initialized");
        }
        OracleSecretStore oracleSecretStore = this;
        synchronized (oracleSecretStore) {
            this.b.secretStoreDeleteCredential(cArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listCredential() throws OracleSecretStoreException {
        if (this.b == null) {
            throw new OracleSecretStoreException("Secret Store not initialized");
        }
        OracleSecretStore oracleSecretStore = this;
        synchronized (oracleSecretStore) {
            this.b.secretStoreListCredential();
        }
    }

    public Enumeration internalAliases() throws OracleSecretStoreException {
        return this.a();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration internalAliasesU() throws OracleSecretStoreException {
        if (this.b == null) {
            throw new OracleSecretStoreException("Secret Store not initialized");
        }
        OracleSecretStore oracleSecretStore = this;
        synchronized (oracleSecretStore) {
            return this.b.c();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Enumeration a() throws OracleSecretStoreException {
        if (this.b == null) {
            throw new OracleSecretStoreException("Secret Store not initialized");
        }
        OracleSecretStore oracleSecretStore = this;
        synchronized (oracleSecretStore) {
            return this.b.b();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int b() throws OracleSecretStoreException {
        if (this.b == null) {
            throw new OracleSecretStoreException("Secret Store not initialized");
        }
        OracleSecretStore oracleSecretStore = this;
        synchronized (oracleSecretStore) {
            return this.b.a();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(InputStream inputStream, char[] cArray) throws IOException, OracleSecretStoreException {
        OraclePKIDebug.a("OracleSecretStore: loading wallet from stream");
        OracleSecretStore oracleSecretStore = this;
        synchronized (oracleSecretStore) {
            this.b = cArray == null ? new OracleSSOKeyStoreSpi() : new OracleKeyStoreSpi();
            try {
                this.b.engineLoad(inputStream, cArray);
            }
            catch (CertificateException certificateException) {
                throw new OracleSecretStoreException(a.getString("PKI-03004"));
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new OracleSecretStoreException(a.getString("PKI-03004"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] setStoreInWallet(InputStream inputStream, char[] cArray) throws IOException, OracleSecretStoreException {
        if (this.b == null) {
            throw new OracleSecretStoreException("Secret Store not initialized");
        }
        OracleSecretStore oracleSecretStore = this;
        synchronized (oracleSecretStore) {
            return this.b.a(inputStream, cArray);
        }
    }
}

