/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.metric.consumer;

import com.netflix.hystrix.metric.HystrixEvent;
import com.netflix.hystrix.metric.HystrixEventStream;
import com.netflix.hystrix.metric.consumer.BucketedCounterStream;
import rx.Observable;
import rx.functions.Func1;
import rx.functions.Func2;

public abstract class BucketedRollingCounterStream<Event extends HystrixEvent, Bucket, Output>
extends BucketedCounterStream<Event, Bucket, Output> {
    private final Func1<Observable<Bucket>, Observable<Output>> reduceWindowToSummary;

    protected BucketedRollingCounterStream(HystrixEventStream<Event> stream, final int numBuckets, int bucketSizeInMs, Func2<Bucket, Event, Bucket> appendRawEventToBucket, final Func2<Output, Bucket, Output> reduceBucket) {
        super(stream, numBuckets, bucketSizeInMs, appendRawEventToBucket);
        this.reduceWindowToSummary = new Func1<Observable<Bucket>, Observable<Output>>(){

            public Observable<Output> call(Observable<Bucket> window) {
                return window.scan(BucketedRollingCounterStream.this.getEmptyOutputValue(), reduceBucket).skip(numBuckets);
            }
        };
    }

    @Override
    public Observable<Output> observe() {
        return this.bucketedStream.window(this.numBuckets, 1).flatMap(this.reduceWindowToSummary);
    }
}

