/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.config;

import com.netflix.hystrix.HystrixCollapserKey;
import com.netflix.hystrix.HystrixCollapserMetrics;
import com.netflix.hystrix.HystrixCollapserProperties;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandMetrics;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolMetrics;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import com.netflix.hystrix.config.HystrixCollapserConfiguration;
import com.netflix.hystrix.config.HystrixCommandConfiguration;
import com.netflix.hystrix.config.HystrixConfiguration;
import com.netflix.hystrix.config.HystrixThreadPoolConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.functions.Func0;
import rx.functions.Func1;

public class HystrixConfigurationStream {
    private final int intervalInMilliseconds;
    private final Observable<Long> timer;
    private static final Func1<Long, Map<HystrixCommandKey, HystrixCommandConfiguration>> getAllCommandConfig = new Func1<Long, Map<HystrixCommandKey, HystrixCommandConfiguration>>(){

        public Map<HystrixCommandKey, HystrixCommandConfiguration> call(Long timestamp) {
            HashMap<HystrixCommandKey, HystrixCommandConfiguration> commandConfigPerKey = new HashMap<HystrixCommandKey, HystrixCommandConfiguration>();
            for (HystrixCommandMetrics commandMetrics : HystrixCommandMetrics.getInstances()) {
                HystrixCommandKey commandKey = commandMetrics.getCommandKey();
                HystrixThreadPoolKey threadPoolKey = commandMetrics.getThreadPoolKey();
                HystrixCommandGroupKey groupKey = commandMetrics.getCommandGroup();
                commandConfigPerKey.put(commandKey, HystrixConfigurationStream.sampleCommandConfiguration(commandKey, threadPoolKey, groupKey, commandMetrics.getProperties()));
            }
            return commandConfigPerKey;
        }
    };
    private static final Func1<Long, Map<HystrixThreadPoolKey, HystrixThreadPoolConfiguration>> getAllThreadPoolConfig = new Func1<Long, Map<HystrixThreadPoolKey, HystrixThreadPoolConfiguration>>(){

        public Map<HystrixThreadPoolKey, HystrixThreadPoolConfiguration> call(Long timestamp) {
            HashMap<HystrixThreadPoolKey, HystrixThreadPoolConfiguration> threadPoolConfigPerKey = new HashMap<HystrixThreadPoolKey, HystrixThreadPoolConfiguration>();
            for (HystrixThreadPoolMetrics threadPoolMetrics : HystrixThreadPoolMetrics.getInstances()) {
                HystrixThreadPoolKey threadPoolKey = threadPoolMetrics.getThreadPoolKey();
                threadPoolConfigPerKey.put(threadPoolKey, HystrixConfigurationStream.sampleThreadPoolConfiguration(threadPoolKey, threadPoolMetrics.getProperties()));
            }
            return threadPoolConfigPerKey;
        }
    };
    private static final Func1<Long, Map<HystrixCollapserKey, HystrixCollapserConfiguration>> getAllCollapserConfig = new Func1<Long, Map<HystrixCollapserKey, HystrixCollapserConfiguration>>(){

        public Map<HystrixCollapserKey, HystrixCollapserConfiguration> call(Long timestamp) {
            HashMap<HystrixCollapserKey, HystrixCollapserConfiguration> collapserConfigPerKey = new HashMap<HystrixCollapserKey, HystrixCollapserConfiguration>();
            for (HystrixCollapserMetrics collapserMetrics : HystrixCollapserMetrics.getInstances()) {
                HystrixCollapserKey collapserKey = collapserMetrics.getCollapserKey();
                collapserConfigPerKey.put(collapserKey, HystrixConfigurationStream.sampleCollapserConfiguration(collapserKey, collapserMetrics.getProperties()));
            }
            return collapserConfigPerKey;
        }
    };
    private static final Func1<Long, HystrixConfiguration> getAllConfig = new Func1<Long, HystrixConfiguration>(){

        public HystrixConfiguration call(Long timestamp) {
            return HystrixConfiguration.from((Map)getAllCommandConfig.call((Object)timestamp), (Map)getAllThreadPoolConfig.call((Object)timestamp), (Map)getAllCollapserConfig.call((Object)timestamp));
        }
    };

    public HystrixConfigurationStream(final int intervalInMilliseconds) {
        this.intervalInMilliseconds = intervalInMilliseconds;
        this.timer = Observable.defer((Func0)new Func0<Observable<Long>>(){

            public Observable<Long> call() {
                return Observable.interval((long)intervalInMilliseconds, (TimeUnit)TimeUnit.MILLISECONDS);
            }
        });
    }

    public Observable<HystrixConfiguration> observe() {
        return this.timer.map(getAllConfig);
    }

    public Observable<Map<HystrixCommandKey, HystrixCommandConfiguration>> observeCommandConfiguration() {
        return this.timer.map(getAllCommandConfig);
    }

    public Observable<Map<HystrixThreadPoolKey, HystrixThreadPoolConfiguration>> observeThreadPoolConfiguration() {
        return this.timer.map(getAllThreadPoolConfig);
    }

    public Observable<Map<HystrixCollapserKey, HystrixCollapserConfiguration>> observeCollapserConfiguration() {
        return this.timer.map(getAllCollapserConfig);
    }

    public int getIntervalInMilliseconds() {
        return this.intervalInMilliseconds;
    }

    private static HystrixCommandConfiguration sampleCommandConfiguration(HystrixCommandKey commandKey, HystrixThreadPoolKey threadPoolKey, HystrixCommandGroupKey groupKey, HystrixCommandProperties commandProperties) {
        return HystrixCommandConfiguration.sample(commandKey, threadPoolKey, groupKey, commandProperties);
    }

    private static HystrixThreadPoolConfiguration sampleThreadPoolConfiguration(HystrixThreadPoolKey threadPoolKey, HystrixThreadPoolProperties threadPoolProperties) {
        return HystrixThreadPoolConfiguration.sample(threadPoolKey, threadPoolProperties);
    }

    private static HystrixCollapserConfiguration sampleCollapserConfiguration(HystrixCollapserKey collapserKey, HystrixCollapserProperties collapserProperties) {
        return HystrixCollapserConfiguration.sample(collapserKey, collapserProperties);
    }
}

