/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix;

import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolMetrics;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import com.netflix.hystrix.strategy.HystrixPlugins;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import com.netflix.hystrix.strategy.concurrency.HystrixContextScheduler;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisherFactory;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesFactory;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import rx.Scheduler;
import rx.functions.Func0;

public interface HystrixThreadPool {
    public ExecutorService getExecutor();

    public Scheduler getScheduler();

    public Scheduler getScheduler(Func0<Boolean> var1);

    public void markThreadExecution();

    public void markThreadCompletion();

    public void markThreadRejection();

    public boolean isQueueSpaceAvailable();

    public static class HystrixThreadPoolDefault
    implements HystrixThreadPool {
        private final HystrixThreadPoolProperties properties;
        private final BlockingQueue<Runnable> queue;
        private final ThreadPoolExecutor threadPool;
        private final HystrixThreadPoolMetrics metrics;
        private final int queueSize;

        public HystrixThreadPoolDefault(HystrixThreadPoolKey threadPoolKey, HystrixThreadPoolProperties.Setter propertiesDefaults) {
            this.properties = HystrixPropertiesFactory.getThreadPoolProperties(threadPoolKey, propertiesDefaults);
            HystrixConcurrencyStrategy concurrencyStrategy = HystrixPlugins.getInstance().getConcurrencyStrategy();
            this.queueSize = this.properties.maxQueueSize().get();
            this.queue = concurrencyStrategy.getBlockingQueue(this.queueSize);
            this.metrics = HystrixThreadPoolMetrics.getInstance(threadPoolKey, concurrencyStrategy.getThreadPool(threadPoolKey, this.properties.coreSize(), this.properties.coreSize(), this.properties.keepAliveTimeMinutes(), TimeUnit.MINUTES, this.queue), this.properties);
            this.threadPool = this.metrics.getThreadPool();
            HystrixMetricsPublisherFactory.createOrRetrievePublisherForThreadPool(threadPoolKey, this.metrics, this.properties);
        }

        @Override
        public ThreadPoolExecutor getExecutor() {
            this.touchConfig();
            return this.threadPool;
        }

        @Override
        public Scheduler getScheduler() {
            return this.getScheduler(new Func0<Boolean>(){

                public Boolean call() {
                    return true;
                }
            });
        }

        @Override
        public Scheduler getScheduler(Func0<Boolean> shouldInterruptThread) {
            this.touchConfig();
            return new HystrixContextScheduler(HystrixPlugins.getInstance().getConcurrencyStrategy(), this, shouldInterruptThread);
        }

        private void touchConfig() {
            int dynamicCoreSize = this.properties.coreSize().get();
            this.threadPool.setCorePoolSize(dynamicCoreSize);
            this.threadPool.setMaximumPoolSize(dynamicCoreSize);
            this.threadPool.setKeepAliveTime(this.properties.keepAliveTimeMinutes().get().intValue(), TimeUnit.MINUTES);
        }

        @Override
        public void markThreadExecution() {
            this.metrics.markThreadExecution();
        }

        @Override
        public void markThreadCompletion() {
            this.metrics.markThreadCompletion();
        }

        @Override
        public void markThreadRejection() {
            this.metrics.markThreadRejection();
        }

        @Override
        public boolean isQueueSpaceAvailable() {
            if (this.queueSize <= 0) {
                return true;
            }
            return this.threadPool.getQueue().size() < this.properties.queueSizeRejectionThreshold().get();
        }
    }

    public static class Factory {
        static final ConcurrentHashMap<String, HystrixThreadPool> threadPools = new ConcurrentHashMap();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static HystrixThreadPool getInstance(HystrixThreadPoolKey threadPoolKey, HystrixThreadPoolProperties.Setter propertiesBuilder) {
            String key = threadPoolKey.name();
            HystrixThreadPool previouslyCached = threadPools.get(key);
            if (previouslyCached != null) {
                return previouslyCached;
            }
            Class<HystrixThreadPool> clazz = HystrixThreadPool.class;
            synchronized (HystrixThreadPool.class) {
                if (!threadPools.containsKey(key)) {
                    threadPools.put(key, new HystrixThreadPoolDefault(threadPoolKey, propertiesBuilder));
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return threadPools.get(key);
            }
        }

        static synchronized void shutdown() {
            for (HystrixThreadPool pool : threadPools.values()) {
                pool.getExecutor().shutdown();
            }
            threadPools.clear();
        }

        static synchronized void shutdown(long timeout, TimeUnit unit) {
            for (HystrixThreadPool pool : threadPools.values()) {
                pool.getExecutor().shutdown();
            }
            for (HystrixThreadPool pool : threadPools.values()) {
                try {
                    pool.getExecutor().awaitTermination(timeout, unit);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Interrupted while waiting for thread-pools to terminate. Pools may not be correctly shutdown or cleared.", e);
                }
            }
            threadPools.clear();
        }
    }
}

