/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.util;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ThreadFactory;

public class PlatformSpecific {
    private final boolean isAppEngine = PlatformSpecific.determineAppEngineReflectively();
    private static PlatformSpecific INSTANCE = new PlatformSpecific();

    private PlatformSpecific() {
    }

    public static boolean isAppEngine() {
        return PlatformSpecific.INSTANCE.isAppEngine;
    }

    private static boolean determineAppEngineReflectively() {
        if (System.getProperty("com.google.appengine.runtime.environment") == null) {
            return false;
        }
        try {
            return Class.forName("com.google.apphosting.api.ApiProxy").getMethod("getCurrentEnvironment", new Class[0]).invoke(null, new Object[0]) != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public static ThreadFactory getAppEngineThreadFactory() {
        try {
            return (ThreadFactory)Class.forName("com.google.appengine.api.ThreadManager").getMethod("currentRequestThreadFactory", new Class[0]).invoke(null, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Couldn't invoke ThreadManager.currentRequestThreadFactory", e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Couldn't invoke ThreadManager.currentRequestThreadFactory", e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Couldn't invoke ThreadManager.currentRequestThreadFactory", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
    }
}

