/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.metric.sample;

import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandMetrics;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolMetrics;
import com.netflix.hystrix.metric.sample.HystrixCommandUtilization;
import com.netflix.hystrix.metric.sample.HystrixThreadPoolUtilization;
import com.netflix.hystrix.metric.sample.HystrixUtilization;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.functions.Func0;
import rx.functions.Func1;

public class HystrixUtilizationStream {
    private final int intervalInMilliseconds;
    private final Observable<Long> timer;
    private static final Func1<Long, Map<HystrixCommandKey, HystrixCommandUtilization>> getAllCommandUtilization = new Func1<Long, Map<HystrixCommandKey, HystrixCommandUtilization>>(){

        public Map<HystrixCommandKey, HystrixCommandUtilization> call(Long timestamp) {
            HashMap<HystrixCommandKey, HystrixCommandUtilization> commandUtilizationPerKey = new HashMap<HystrixCommandKey, HystrixCommandUtilization>();
            for (HystrixCommandMetrics commandMetrics : HystrixCommandMetrics.getInstances()) {
                HystrixCommandKey commandKey = commandMetrics.getCommandKey();
                commandUtilizationPerKey.put(commandKey, HystrixUtilizationStream.sampleCommandUtilization(commandMetrics));
            }
            return commandUtilizationPerKey;
        }
    };
    private static final Func1<Long, Map<HystrixThreadPoolKey, HystrixThreadPoolUtilization>> getAllThreadPoolUtilization = new Func1<Long, Map<HystrixThreadPoolKey, HystrixThreadPoolUtilization>>(){

        public Map<HystrixThreadPoolKey, HystrixThreadPoolUtilization> call(Long timestamp) {
            HashMap<HystrixThreadPoolKey, HystrixThreadPoolUtilization> threadPoolUtilizationPerKey = new HashMap<HystrixThreadPoolKey, HystrixThreadPoolUtilization>();
            for (HystrixThreadPoolMetrics threadPoolMetrics : HystrixThreadPoolMetrics.getInstances()) {
                HystrixThreadPoolKey threadPoolKey = threadPoolMetrics.getThreadPoolKey();
                threadPoolUtilizationPerKey.put(threadPoolKey, HystrixUtilizationStream.sampleThreadPoolUtilization(threadPoolMetrics));
            }
            return threadPoolUtilizationPerKey;
        }
    };
    private static final Func1<Long, HystrixUtilization> getAllUtilization = new Func1<Long, HystrixUtilization>(){

        public HystrixUtilization call(Long timestamp) {
            return HystrixUtilization.from((Map)getAllCommandUtilization.call((Object)timestamp), (Map)getAllThreadPoolUtilization.call((Object)timestamp));
        }
    };

    public HystrixUtilizationStream(final int intervalInMilliseconds) {
        this.intervalInMilliseconds = intervalInMilliseconds;
        this.timer = Observable.defer((Func0)new Func0<Observable<Long>>(){

            public Observable<Long> call() {
                return Observable.interval((long)intervalInMilliseconds, (TimeUnit)TimeUnit.MILLISECONDS);
            }
        });
    }

    public Observable<HystrixUtilization> observe() {
        return this.timer.map(getAllUtilization);
    }

    public Observable<Map<HystrixCommandKey, HystrixCommandUtilization>> observeCommandUtilization() {
        return this.timer.map(getAllCommandUtilization);
    }

    public Observable<Map<HystrixThreadPoolKey, HystrixThreadPoolUtilization>> observeThreadPoolUtilization() {
        return this.timer.map(getAllThreadPoolUtilization);
    }

    public int getIntervalInMilliseconds() {
        return this.intervalInMilliseconds;
    }

    private static HystrixCommandUtilization sampleCommandUtilization(HystrixCommandMetrics commandMetrics) {
        return HystrixCommandUtilization.sample(commandMetrics);
    }

    private static HystrixThreadPoolUtilization sampleThreadPoolUtilization(HystrixThreadPoolMetrics threadPoolMetrics) {
        return HystrixThreadPoolUtilization.sample(threadPoolMetrics);
    }
}

