/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.metric.consumer;

import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.hystrix.HystrixCollapserMetrics;
import com.netflix.hystrix.HystrixCommandMetrics;
import com.netflix.hystrix.HystrixThreadPoolMetrics;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import rx.Observable;
import rx.functions.Action0;
import rx.functions.Func1;

public class HystrixDashboardStream {
    final int delayInMs;
    final Observable<DashboardData> singleSource;
    final AtomicBoolean isSourceCurrentlySubscribed = new AtomicBoolean(false);
    private static final DynamicIntProperty dataEmissionIntervalInMs = DynamicPropertyFactory.getInstance().getIntProperty("hystrix.stream.dashboard.intervalInMilliseconds", 500);
    private static final HystrixDashboardStream INSTANCE = new HystrixDashboardStream(dataEmissionIntervalInMs.get());

    private HystrixDashboardStream(int delayInMs) {
        this.delayInMs = delayInMs;
        this.singleSource = Observable.interval((long)delayInMs, (TimeUnit)TimeUnit.MILLISECONDS).map((Func1)new Func1<Long, DashboardData>(){

            public DashboardData call(Long timestamp) {
                return new DashboardData(HystrixCommandMetrics.getInstances(), HystrixThreadPoolMetrics.getInstances(), HystrixCollapserMetrics.getInstances());
            }
        }).doOnSubscribe(new Action0(){

            public void call() {
                HystrixDashboardStream.this.isSourceCurrentlySubscribed.set(true);
            }
        }).doOnUnsubscribe(new Action0(){

            public void call() {
                HystrixDashboardStream.this.isSourceCurrentlySubscribed.set(false);
            }
        }).share().onBackpressureDrop();
    }

    public static HystrixDashboardStream getInstance() {
        return INSTANCE;
    }

    static HystrixDashboardStream getNonSingletonInstanceOnlyUsedInUnitTests(int delayInMs) {
        return new HystrixDashboardStream(delayInMs);
    }

    public Observable<DashboardData> observe() {
        return this.singleSource;
    }

    public boolean isSourceCurrentlySubscribed() {
        return this.isSourceCurrentlySubscribed.get();
    }

    public static class DashboardData {
        final Collection<HystrixCommandMetrics> commandMetrics;
        final Collection<HystrixThreadPoolMetrics> threadPoolMetrics;
        final Collection<HystrixCollapserMetrics> collapserMetrics;

        public DashboardData(Collection<HystrixCommandMetrics> commandMetrics, Collection<HystrixThreadPoolMetrics> threadPoolMetrics, Collection<HystrixCollapserMetrics> collapserMetrics) {
            this.commandMetrics = commandMetrics;
            this.threadPoolMetrics = threadPoolMetrics;
            this.collapserMetrics = collapserMetrics;
        }

        public Collection<HystrixCommandMetrics> getCommandMetrics() {
            return this.commandMetrics;
        }

        public Collection<HystrixThreadPoolMetrics> getThreadPoolMetrics() {
            return this.threadPoolMetrics;
        }

        public Collection<HystrixCollapserMetrics> getCollapserMetrics() {
            return this.collapserMetrics;
        }
    }
}

