/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.config;

import com.netflix.hystrix.HystrixCollapserKey;
import com.netflix.hystrix.HystrixCollapserProperties;

public class HystrixCollapserConfiguration {
    private final HystrixCollapserKey collapserKey;
    private final int maxRequestsInBatch;
    private final int timerDelayInMilliseconds;
    private final boolean requestCacheEnabled;
    private final CollapserMetricsConfig collapserMetricsConfig;

    public HystrixCollapserConfiguration(HystrixCollapserKey collapserKey, int maxRequestsInBatch, int timerDelayInMilliseconds, boolean requestCacheEnabled, CollapserMetricsConfig collapserMetricsConfig) {
        this.collapserKey = collapserKey;
        this.maxRequestsInBatch = maxRequestsInBatch;
        this.timerDelayInMilliseconds = timerDelayInMilliseconds;
        this.requestCacheEnabled = requestCacheEnabled;
        this.collapserMetricsConfig = collapserMetricsConfig;
    }

    public static HystrixCollapserConfiguration sample(HystrixCollapserKey collapserKey, HystrixCollapserProperties collapserProperties) {
        CollapserMetricsConfig collapserMetricsConfig = new CollapserMetricsConfig(collapserProperties.metricsRollingPercentileWindowBuckets().get(), collapserProperties.metricsRollingPercentileWindowInMilliseconds().get(), collapserProperties.metricsRollingPercentileEnabled().get(), collapserProperties.metricsRollingStatisticalWindowBuckets().get(), collapserProperties.metricsRollingStatisticalWindowInMilliseconds().get());
        return new HystrixCollapserConfiguration(collapserKey, collapserProperties.maxRequestsInBatch().get(), collapserProperties.timerDelayInMilliseconds().get(), collapserProperties.requestCacheEnabled().get(), collapserMetricsConfig);
    }

    public HystrixCollapserKey getCollapserKey() {
        return this.collapserKey;
    }

    public int getMaxRequestsInBatch() {
        return this.maxRequestsInBatch;
    }

    public int getTimerDelayInMilliseconds() {
        return this.timerDelayInMilliseconds;
    }

    public boolean isRequestCacheEnabled() {
        return this.requestCacheEnabled;
    }

    public CollapserMetricsConfig getCollapserMetricsConfig() {
        return this.collapserMetricsConfig;
    }

    public static class CollapserMetricsConfig {
        private final int rollingPercentileNumberOfBuckets;
        private final int rollingPercentileBucketSizeInMilliseconds;
        private final boolean rollingPercentileEnabled;
        private final int rollingCounterNumberOfBuckets;
        private final int rollingCounterBucketSizeInMilliseconds;

        public CollapserMetricsConfig(int rollingPercentileNumberOfBuckets, int rollingPercentileBucketSizeInMilliseconds, boolean rollingPercentileEnabled, int rollingCounterNumberOfBuckets, int rollingCounterBucketSizeInMilliseconds) {
            this.rollingPercentileNumberOfBuckets = rollingCounterNumberOfBuckets;
            this.rollingPercentileBucketSizeInMilliseconds = rollingPercentileBucketSizeInMilliseconds;
            this.rollingPercentileEnabled = rollingPercentileEnabled;
            this.rollingCounterNumberOfBuckets = rollingCounterNumberOfBuckets;
            this.rollingCounterBucketSizeInMilliseconds = rollingCounterBucketSizeInMilliseconds;
        }

        public int getRollingPercentileNumberOfBuckets() {
            return this.rollingPercentileNumberOfBuckets;
        }

        public int getRollingPercentileBucketSizeInMilliseconds() {
            return this.rollingPercentileBucketSizeInMilliseconds;
        }

        public boolean isRollingPercentileEnabled() {
            return this.rollingPercentileEnabled;
        }

        public int getRollingCounterNumberOfBuckets() {
            return this.rollingCounterNumberOfBuckets;
        }

        public int getRollingCounterBucketSizeInMilliseconds() {
            return this.rollingCounterBucketSizeInMilliseconds;
        }
    }
}

