/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix;

import java.util.concurrent.ConcurrentHashMap;

public interface HystrixCommandKey {
    public String name();

    public static class Factory {
        private static ConcurrentHashMap<String, HystrixCommandKey> intern = new ConcurrentHashMap();

        private Factory() {
        }

        public static HystrixCommandKey asKey(String name) {
            HystrixCommandKey k = intern.get(name);
            if (k == null) {
                intern.putIfAbsent(name, new HystrixCommandKeyDefault(name));
            }
            return intern.get(name);
        }

        static int getCommandCount() {
            return intern.size();
        }

        private static class HystrixCommandKeyDefault
        implements HystrixCommandKey {
            private String name;

            private HystrixCommandKeyDefault(String name) {
                this.name = name;
            }

            @Override
            public String name() {
                return this.name;
            }
        }
    }
}

