/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.command.text;

import com.google.code.yanf4j.buffer.IoBuffer;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import net.rubyeye.xmemcached.command.Command;
import net.rubyeye.xmemcached.command.CommandType;
import net.rubyeye.xmemcached.impl.MemcachedTCPSession;
import net.rubyeye.xmemcached.monitor.Constants;
import net.rubyeye.xmemcached.transcoders.CachedData;
import net.rubyeye.xmemcached.transcoders.Transcoder;
import net.rubyeye.xmemcached.utils.ByteUtils;

public class TextStoreCommand
extends Command {
    protected int expTime;
    protected long cas;
    protected Object value;

    public TextStoreCommand(String key, byte[] keyBytes, CommandType cmdType, CountDownLatch latch, int exp, long cas, Object value, boolean noreply, Transcoder transcoder) {
        super(key, keyBytes, cmdType, latch);
        this.expTime = exp;
        this.cas = cas;
        this.value = value;
        this.noreply = noreply;
        this.transcoder = transcoder;
    }

    public final int getExpTime() {
        return this.expTime;
    }

    public final void setExpTime(int exp) {
        this.expTime = exp;
    }

    public final long getCas() {
        return this.cas;
    }

    public final void setCas(long cas) {
        this.cas = cas;
    }

    public final Object getValue() {
        return this.value;
    }

    public final void setValue(Object value) {
        this.value = value;
    }

    public final Transcoder getTranscoder() {
        return this.transcoder;
    }

    public final void setTranscoder(Transcoder transcoder) {
        this.transcoder = transcoder;
    }

    public boolean decode(MemcachedTCPSession session, ByteBuffer buffer) {
        if (buffer == null || !buffer.hasRemaining()) {
            return false;
        }
        if (this.result == null) {
            if (buffer.remaining() < 2) {
                return false;
            }
            byte first = buffer.get(buffer.position());
            byte second = buffer.get(buffer.position() + 1);
            if (first == 83 && second == 84) {
                this.setResult(Boolean.TRUE);
                this.countDownLatch();
                return ByteUtils.stepBuffer(buffer, 8);
            }
            if (first == 78) {
                this.setResult(Boolean.FALSE);
                this.countDownLatch();
                return ByteUtils.stepBuffer(buffer, 12);
            }
            return this.decodeError(session, buffer);
        }
        Boolean result = (Boolean)this.result;
        if (result.booleanValue()) {
            return ByteUtils.stepBuffer(buffer, 8);
        }
        return ByteUtils.stepBuffer(buffer, 12);
    }

    private String getCommandName() {
        switch (this.commandType) {
            case ADD: {
                return "add";
            }
            case SET: {
                return "set";
            }
            case REPLACE: {
                return "replace";
            }
            case APPEND: {
                return "append";
            }
            case PREPEND: {
                return "prepend";
            }
            case CAS: {
                return "cas";
            }
        }
        throw new IllegalArgumentException(this.commandType.name() + " is not a store command");
    }

    public final void encode() {
        CachedData data = this.encodeValue();
        String cmdStr = this.getCommandName();
        byte[] encodedData = data.getData();
        int flag = data.getFlag();
        int size = cmdStr.length() + this.keyBytes.length + ByteUtils.stringSize(flag) + ByteUtils.stringSize(this.expTime) + encodedData.length + ByteUtils.stringSize(encodedData.length) + 8;
        if (this.commandType == CommandType.CAS) {
            size += 1 + ByteUtils.stringSize(this.cas);
        }
        byte[] buf = this.isNoreply() ? new byte[size + 8] : new byte[size];
        int offset = 0;
        offset = this.commandType == CommandType.CAS ? (this.isNoreply() ? ByteUtils.setArguments(buf, offset, cmdStr, this.keyBytes, flag, this.expTime, encodedData.length, this.cas, Constants.NO_REPLY) : ByteUtils.setArguments(buf, offset, cmdStr, this.keyBytes, flag, this.expTime, encodedData.length, this.cas)) : (this.isNoreply() ? ByteUtils.setArguments(buf, offset, cmdStr, this.keyBytes, flag, this.expTime, encodedData.length, Constants.NO_REPLY) : ByteUtils.setArguments(buf, offset, cmdStr, this.keyBytes, flag, this.expTime, encodedData.length));
        ByteUtils.setArguments(buf, offset, new Object[]{encodedData});
        this.ioBuffer = IoBuffer.wrap(buf);
    }

    protected CachedData encodeValue() {
        CachedData data = this.transcoder.encode(this.value);
        return data;
    }
}

