/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.command.binary;

import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import net.rubyeye.xmemcached.command.CommandType;
import net.rubyeye.xmemcached.command.binary.BaseBinaryCommand;
import net.rubyeye.xmemcached.command.binary.BinaryDecodeStatus;
import net.rubyeye.xmemcached.command.binary.OpCode;
import net.rubyeye.xmemcached.command.binary.ResponseStatus;
import net.rubyeye.xmemcached.transcoders.Transcoder;

public class BinaryStoreCommand
extends BaseBinaryCommand {
    public BinaryStoreCommand(String key, byte[] keyBytes, CommandType cmdType, CountDownLatch latch, int exp, long cas, Object value, boolean noreply, Transcoder transcoder) {
        super(key, keyBytes, cmdType, latch, exp, cas, value, noreply, transcoder);
        switch (cmdType) {
            case SET: {
                this.opCode = noreply ? OpCode.SET_QUIETLY : OpCode.SET;
                break;
            }
            case REPLACE: {
                this.opCode = noreply ? OpCode.REPLACE_QUIETLY : OpCode.REPLACE;
                break;
            }
            case ADD: {
                this.opCode = noreply ? OpCode.ADD_QUIETLY : OpCode.ADD;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknow cmd type for storage commands:" + (Object)((Object)cmdType));
            }
        }
    }

    protected void readHeader(ByteBuffer buffer) {
        super.readHeader(buffer);
        if (this.responseStatus == ResponseStatus.NO_ERROR) {
            this.decodeStatus = BinaryDecodeStatus.DONE;
        }
    }
}

