/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.yanf4j.core.impl;

import com.google.code.yanf4j.config.Configuration;
import com.google.code.yanf4j.core.CodecFactory;
import com.google.code.yanf4j.core.Controller;
import com.google.code.yanf4j.core.ControllerLifeCycle;
import com.google.code.yanf4j.core.ControllerStateListener;
import com.google.code.yanf4j.core.Dispatcher;
import com.google.code.yanf4j.core.Handler;
import com.google.code.yanf4j.core.Session;
import com.google.code.yanf4j.core.SocketOption;
import com.google.code.yanf4j.core.WriteMessage;
import com.google.code.yanf4j.core.impl.ByteBufferCodecFactory;
import com.google.code.yanf4j.statistics.Statistics;
import com.google.code.yanf4j.statistics.impl.DefaultStatistics;
import com.google.code.yanf4j.statistics.impl.SimpleStatistics;
import com.google.code.yanf4j.util.DispatcherFactory;
import com.google.code.yanf4j.util.LinkedTransferQueue;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractController
implements Controller,
ControllerLifeCycle {
    protected Statistics statistics = new DefaultStatistics();
    protected long statisticsInterval;
    protected static final Logger log = LoggerFactory.getLogger(AbstractController.class);
    protected CopyOnWriteArrayList<ControllerStateListener> stateListeners = new CopyOnWriteArrayList();
    protected Handler handler;
    protected volatile CodecFactory codecFactory;
    protected volatile boolean started;
    protected InetSocketAddress localSocketAddress;
    protected int readThreadCount;
    protected int writeThreadCount;
    protected int dispatchMessageThreadCount;
    protected Configuration configuration;
    protected Dispatcher readEventDispatcher;
    protected Dispatcher dispatchMessageDispatcher;
    protected Dispatcher writeEventDispatcher;
    protected long sessionTimeout;
    protected volatile boolean handleReadWriteConcurrently = true;
    protected int soTimeout;
    protected Map<SocketOption, Object> socketOptions = new HashMap<SocketOption, Object>();
    protected Set<Session> sessionSet = new HashSet<Session>();
    private Thread shutdownHookThread;
    private volatile boolean isHutdownHookCalled = false;

    public void setSocketOptions(Map<SocketOption, Object> socketOptions) {
        if (socketOptions == null) {
            throw new NullPointerException("Null socketOptions");
        }
        this.socketOptions = socketOptions;
    }

    @Override
    public final int getDispatchMessageThreadCount() {
        return this.dispatchMessageThreadCount;
    }

    @Override
    public final void setDispatchMessageThreadCount(int dispatchMessageThreadPoolSize) {
        if (this.started) {
            throw new IllegalStateException("Controller is started");
        }
        if (dispatchMessageThreadPoolSize < 0) {
            throw new IllegalArgumentException("dispatchMessageThreadPoolSize<0");
        }
        this.dispatchMessageThreadCount = dispatchMessageThreadPoolSize;
    }

    @Override
    public long getSessionIdleTimeout() {
        return this.configuration.getSessionIdleTimeout();
    }

    protected Queue<WriteMessage> buildQueue() {
        return new LinkedTransferQueue<WriteMessage>();
    }

    @Override
    public void setSessionIdleTimeout(long sessionIdleTimeout) {
        this.configuration.setSessionIdleTimeout(sessionIdleTimeout);
    }

    @Override
    public long getSessionTimeout() {
        return this.sessionTimeout;
    }

    @Override
    public void setSessionTimeout(long sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    @Override
    public int getSoTimeout() {
        return this.soTimeout;
    }

    @Override
    public void setSoTimeout(int timeout) {
        this.soTimeout = timeout;
    }

    public AbstractController() {
        this(new Configuration(), null, null);
    }

    @Override
    public double getReceiveThroughputLimit() {
        return this.statistics.getReceiveThroughputLimit();
    }

    @Override
    public double getSendThroughputLimit() {
        return this.statistics.getSendThroughputLimit();
    }

    @Override
    public void setReceiveThroughputLimit(double receiveThroughputLimit) {
        this.statistics.setReceiveThroughputLimit(receiveThroughputLimit);
    }

    @Override
    public void setSendThroughputLimit(double sendThroughputLimit) {
        this.statistics.setSendThroughputLimit(sendThroughputLimit);
    }

    public AbstractController(Configuration configuration) {
        this(configuration, null, null);
    }

    public AbstractController(Configuration configuration, CodecFactory codecFactory) {
        this(configuration, null, codecFactory);
    }

    public AbstractController(Configuration configuration, Handler handler, CodecFactory codecFactory) {
        this.init(configuration, handler, codecFactory);
    }

    private synchronized void init(Configuration configuration, Handler handler, CodecFactory codecFactory) {
        this.setHandler(handler);
        this.setCodecFactory(codecFactory);
        this.setConfiguration(configuration);
        this.setReadThreadCount(configuration.getReadThreadCount());
        this.setWriteThreadCount(configuration.getWriteThreadCount());
        this.setDispatchMessageThreadCount(configuration.getDispatchMessageThreadCount());
        this.setHandleReadWriteConcurrently(configuration.isHandleReadWriteConcurrently());
        this.setSoTimeout(configuration.getSoTimeout());
        this.setStatisticsConfig(configuration);
        this.setReceiveThroughputLimit(-0.1);
        this.setStarted(false);
    }

    void setStarted(boolean started) {
        this.started = started;
    }

    private void setStatisticsConfig(Configuration configuration) {
        if (configuration.isStatisticsServer()) {
            this.statistics = new SimpleStatistics();
            this.statisticsInterval = configuration.getStatisticsInterval();
        } else {
            this.statistics = new DefaultStatistics();
            this.statisticsInterval = -1L;
        }
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("Null Configuration");
        }
        this.configuration = configuration;
    }

    @Override
    public InetSocketAddress getLocalSocketAddress() {
        return this.localSocketAddress;
    }

    @Override
    public void setLocalSocketAddress(InetSocketAddress inetSocketAddress) {
        this.localSocketAddress = inetSocketAddress;
    }

    public void onAccept(SelectionKey sk) throws IOException {
        this.statistics.statisticsAccept();
    }

    public void onConnect(SelectionKey key) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addStateListener(ControllerStateListener listener) {
        this.stateListeners.add(listener);
    }

    @Override
    public void removeStateListener(ControllerStateListener listener) {
        this.stateListeners.remove(listener);
    }

    @Override
    public boolean isHandleReadWriteConcurrently() {
        return this.handleReadWriteConcurrently;
    }

    @Override
    public void setHandleReadWriteConcurrently(boolean handleReadWriteConcurrently) {
        this.handleReadWriteConcurrently = handleReadWriteConcurrently;
    }

    @Override
    public int getReadThreadCount() {
        return this.readThreadCount;
    }

    @Override
    public void setReadThreadCount(int readThreadCount) {
        if (this.started) {
            throw new IllegalStateException();
        }
        if (readThreadCount < 0) {
            throw new IllegalArgumentException("readThreadCount<0");
        }
        this.readThreadCount = readThreadCount;
    }

    @Override
    public final int getWriteThreadCount() {
        return this.writeThreadCount;
    }

    @Override
    public final void setWriteThreadCount(int writeThreadCount) {
        if (this.started) {
            throw new IllegalStateException();
        }
        if (writeThreadCount < 0) {
            throw new IllegalArgumentException("readThreadCount<0");
        }
        this.writeThreadCount = writeThreadCount;
    }

    @Override
    public Handler getHandler() {
        return this.handler;
    }

    @Override
    public void setHandler(Handler handler) {
        if (this.started) {
            throw new IllegalStateException("The Controller have started");
        }
        this.handler = handler;
    }

    @Override
    public int getPort() {
        if (this.localSocketAddress != null) {
            return this.localSocketAddress.getPort();
        }
        throw new NullPointerException("Controller is not binded");
    }

    @Override
    public synchronized void start() throws IOException {
        if (this.isStarted()) {
            return;
        }
        if (this.getHandler() == null) {
            throw new IOException("The handler is null");
        }
        if (this.getCodecFactory() == null) {
            this.setCodecFactory(new ByteBufferCodecFactory());
        }
        this.setStarted(true);
        this.setReadEventDispatcher(DispatcherFactory.newDispatcher(this.getReadThreadCount(), new ThreadPoolExecutor.CallerRunsPolicy(), "xmemcached-read-thread"));
        this.setWriteEventDispatcher(DispatcherFactory.newDispatcher(this.getWriteThreadCount(), new ThreadPoolExecutor.CallerRunsPolicy(), "xmemcached-write-thread"));
        this.setDispatchMessageDispatcher(DispatcherFactory.newDispatcher(this.getDispatchMessageThreadCount(), new ThreadPoolExecutor.CallerRunsPolicy(), "xmemcached-dispatch-thread"));
        this.startStatistics();
        this.start0();
        this.notifyStarted();
        this.shutdownHookThread = new Thread(){

            public void run() {
                try {
                    AbstractController.this.isHutdownHookCalled = true;
                    AbstractController.this.stop();
                }
                catch (IOException e) {
                    log.error("Stop controller fail", (Throwable)e);
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(this.shutdownHookThread);
        log.warn("The Controller started at " + this.localSocketAddress + " ...");
    }

    protected abstract void start0() throws IOException;

    void setDispatchMessageDispatcher(Dispatcher dispatcher) {
        Dispatcher oldDispatcher = this.dispatchMessageDispatcher;
        this.dispatchMessageDispatcher = dispatcher;
        if (oldDispatcher != null) {
            oldDispatcher.stop();
        }
    }

    Dispatcher getReadEventDispatcher() {
        return this.readEventDispatcher;
    }

    void setReadEventDispatcher(Dispatcher dispatcher) {
        Dispatcher oldDispatcher = this.readEventDispatcher;
        this.readEventDispatcher = dispatcher;
        if (oldDispatcher != null) {
            oldDispatcher.stop();
        }
    }

    void setWriteEventDispatcher(Dispatcher dispatcher) {
        Dispatcher oldDispatcher = this.writeEventDispatcher;
        this.writeEventDispatcher = dispatcher;
        if (oldDispatcher != null) {
            oldDispatcher.stop();
        }
    }

    private final void startStatistics() {
        this.statistics.start();
    }

    @Override
    public void notifyStarted() {
        for (ControllerStateListener stateListener : this.stateListeners) {
            stateListener.onStarted(this);
        }
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public final Statistics getStatistics() {
        return this.statistics;
    }

    @Override
    public final CodecFactory getCodecFactory() {
        return this.codecFactory;
    }

    @Override
    public final void setCodecFactory(CodecFactory codecFactory) {
        this.codecFactory = codecFactory;
    }

    @Override
    public void notifyReady() {
        for (ControllerStateListener stateListener : this.stateListeners) {
            stateListener.onReady(this);
        }
    }

    public final synchronized void unregisterSession(Session session) {
        this.sessionSet.remove(session);
        if (this.sessionSet.size() == 0) {
            this.notifyAllSessionClosed();
            this.notifyAll();
        }
    }

    public void checkStatisticsForRestart() {
        if (this.statisticsInterval > 0L && System.currentTimeMillis() - this.statistics.getStartedTime() > this.statisticsInterval * 1000L) {
            this.statistics.restart();
        }
    }

    public final synchronized void registerSession(Session session) {
        if (this.started) {
            this.sessionSet.add(session);
        } else {
            session.close();
        }
    }

    @Override
    public synchronized void stop() throws IOException {
        if (!this.isStarted()) {
            return;
        }
        this.setStarted(false);
        for (Session session : this.sessionSet) {
            session.close();
        }
        this.stopStatistics();
        this.stopDispatcher();
        this.sessionSet.clear();
        this.notifyStopped();
        this.clearStateListeners();
        this.stop0();
        if (!this.isHutdownHookCalled) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHookThread);
        }
        log.info("Controller has been stopped.");
    }

    protected abstract void stop0() throws IOException;

    private final void stopDispatcher() {
        if (this.readEventDispatcher != null) {
            this.readEventDispatcher.stop();
        }
        if (this.dispatchMessageDispatcher != null) {
            this.dispatchMessageDispatcher.stop();
        }
        if (this.writeEventDispatcher != null) {
            this.writeEventDispatcher.stop();
        }
    }

    private final void stopStatistics() {
        this.statistics.stop();
    }

    private final void clearStateListeners() {
        this.stateListeners.clear();
    }

    @Override
    public final void notifyException(Throwable t) {
        for (ControllerStateListener stateListener : this.stateListeners) {
            stateListener.onException(this, t);
        }
    }

    @Override
    public final void notifyStopped() {
        for (ControllerStateListener stateListener : this.stateListeners) {
            stateListener.onStopped(this);
        }
    }

    @Override
    public final void notifyAllSessionClosed() {
        for (ControllerStateListener stateListener : this.stateListeners) {
            stateListener.onAllSessionClosed(this);
        }
    }

    public Set<Session> getSessionSet() {
        return Collections.unmodifiableSet(this.sessionSet);
    }

    @Override
    public <T> void setSocketOption(SocketOption<T> socketOption, T value) {
        if (socketOption == null) {
            throw new NullPointerException("Null socketOption");
        }
        if (value == null) {
            throw new NullPointerException("Null value");
        }
        if (!socketOption.type().equals(value.getClass())) {
            throw new IllegalArgumentException("Expected " + socketOption.type().getSimpleName() + " value,but givend " + value.getClass().getSimpleName());
        }
        this.socketOptions.put(socketOption, value);
    }

    public <T> T getSocketOption(SocketOption<T> socketOption) {
        return (T)this.socketOptions.get(socketOption);
    }

    public void bind(InetSocketAddress inetSocketAddress) throws IOException {
        if (inetSocketAddress == null) {
            throw new IllegalArgumentException("Null inetSocketAddress");
        }
        this.setLocalSocketAddress(inetSocketAddress);
        this.start();
    }
}

