/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.protobuf.format;

import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.Message;
import com.google.protobuf.UnknownFieldSet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;

public abstract class ProtobufFormatter {
    private Charset defaultCharset = Charset.defaultCharset();

    public void setDefaultCharset(Charset cs) {
        this.defaultCharset = cs;
    }

    public Charset getDefaultCharset() {
        return this.defaultCharset;
    }

    public void print(Message message, OutputStream output) throws IOException {
        this.print(message, output, this.defaultCharset);
    }

    public abstract void print(Message var1, OutputStream var2, Charset var3) throws IOException;

    public void print(UnknownFieldSet fields, OutputStream output) throws IOException {
        this.print(fields, output, this.defaultCharset);
    }

    public abstract void print(UnknownFieldSet var1, OutputStream var2, Charset var3) throws IOException;

    public String printToString(Message message) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.print(message, (OutputStream)out, this.defaultCharset);
            out.flush();
            return out.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Writing to a StringBuilder threw an IOException (should never happen).", e);
        }
    }

    public String printToString(UnknownFieldSet fields) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.print(fields, (OutputStream)out, this.defaultCharset);
            out.flush();
            return out.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Writing to a StringBuilder threw an IOException (should never happen).", e);
        }
    }

    public abstract void merge(InputStream var1, Charset var2, ExtensionRegistry var3, Message.Builder var4) throws IOException;

    public void merge(InputStream input, Charset cs, Message.Builder builder) throws IOException {
        this.merge(input, cs, ExtensionRegistry.getEmptyRegistry(), builder);
    }

    public void merge(InputStream input, Message.Builder builder) throws IOException {
        this.merge(input, this.defaultCharset, ExtensionRegistry.getEmptyRegistry(), builder);
    }

    public void merge(InputStream input, ExtensionRegistry extensionRegistry, Message.Builder builder) throws IOException {
        this.merge(input, this.defaultCharset, extensionRegistry, builder);
    }

    public static class ParseException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public ParseException(String message) {
            super(message);
        }
    }
}

