/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.protobuf.format;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.Message;
import com.google.protobuf.UnknownFieldSet;
import com.googlecode.protobuf.format.AbstractCharBasedFormatter;
import com.googlecode.protobuf.format.util.TextUtils;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public final class HtmlFormat
extends AbstractCharBasedFormatter {
    private static final String META_CONTENT = "<meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\" />";
    private static final String MAIN_DIV_STYLE = "color: black; font-size: 14px; font-family: sans-serif; font-weight: bolder; margin-bottom: 10px;";
    private static final String FIELD_NAME_STYLE = "font-weight: bold; color: #669966;font-size: 14px; font-family: sans-serif;";
    private static final String FIELD_VALUE_STYLE = "color: #3300FF;font-size: 13px; font-family: sans-serif;";

    @Override
    public void print(Message message, Appendable output) throws IOException {
        HtmlGenerator generator = new HtmlGenerator(output);
        this.printTitle(message, generator);
        this.print(message, generator);
        generator.print("</body></html>");
    }

    @Override
    public void print(UnknownFieldSet fields, Appendable output) throws IOException {
        HtmlGenerator generator = new HtmlGenerator(output);
        generator.print("<html>");
        generator.print(META_CONTENT);
        generator.print("</head><body>");
        this.printUnknownFields(fields, generator);
        generator.print("</body></html>");
    }

    @Override
    public void merge(CharSequence input, ExtensionRegistry extensionRegistry, Message.Builder builder) throws IOException {
        throw new UnsupportedOperationException();
    }

    private void printTitle(Message message, HtmlGenerator generator) throws IOException {
        generator.print("<html><head>");
        generator.print(META_CONTENT);
        generator.print("<title>");
        generator.print(message.getDescriptorForType().getFullName());
        generator.print("</title></head><body>");
        generator.print("<div style=\"");
        generator.print(MAIN_DIV_STYLE);
        generator.print("\">message : ");
        generator.print(message.getDescriptorForType().getFullName());
        generator.print("</div>");
    }

    private void print(Message message, HtmlGenerator generator) throws IOException {
        for (Map.Entry field : message.getAllFields().entrySet()) {
            this.printField((Descriptors.FieldDescriptor)field.getKey(), field.getValue(), generator);
        }
        this.printUnknownFields(message.getUnknownFields(), generator);
    }

    public void printField(Descriptors.FieldDescriptor field, Object value, HtmlGenerator generator) throws IOException {
        if (field.isRepeated()) {
            for (Object element : (List)value) {
                this.printSingleField(field, element, generator);
            }
        } else {
            this.printSingleField(field, value, generator);
        }
    }

    private void printSingleField(Descriptors.FieldDescriptor field, Object value, HtmlGenerator generator) throws IOException {
        if (field.isExtension()) {
            generator.print("[<span style=\"");
            generator.print(FIELD_NAME_STYLE);
            generator.print("\">");
            if (field.getContainingType().getOptions().getMessageSetWireFormat() && field.getType() == Descriptors.FieldDescriptor.Type.MESSAGE && field.isOptional() && field.getExtensionScope() == field.getMessageType()) {
                generator.print(field.getMessageType().getFullName());
            } else {
                generator.print(field.getFullName());
            }
            generator.print("</span>]");
        } else {
            generator.print("<span style=\"");
            generator.print(FIELD_NAME_STYLE);
            generator.print("\">");
            if (field.getType() == Descriptors.FieldDescriptor.Type.GROUP) {
                generator.print(field.getMessageType().getName());
            } else {
                generator.print(field.getName());
            }
            generator.print("</span>");
        }
        if (field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
            generator.print(" <span style=\"color: red;\">{</span><br/>");
            generator.indent();
        } else {
            generator.print(": ");
        }
        this.printFieldValue(field, value, generator);
        if (field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
            generator.outdent();
            generator.print("<span style=\"color: red;\">}</span>");
        }
        generator.print("<br/>");
    }

    private void printFieldValue(Descriptors.FieldDescriptor field, Object value, HtmlGenerator generator) throws IOException {
        generator.print("<span style=\"");
        generator.print(FIELD_VALUE_STYLE);
        generator.print("\">");
        switch (field.getType()) {
            case INT32: 
            case INT64: 
            case SINT32: 
            case SINT64: 
            case SFIXED32: 
            case SFIXED64: 
            case FLOAT: 
            case DOUBLE: 
            case BOOL: {
                generator.print(value.toString());
                break;
            }
            case UINT32: 
            case FIXED32: {
                generator.print(TextUtils.unsignedToString((Integer)value));
                break;
            }
            case UINT64: 
            case FIXED64: {
                generator.print(TextUtils.unsignedToString((Long)value));
                break;
            }
            case STRING: {
                generator.print("\"");
                generator.print(value.toString());
                generator.print("\"");
                break;
            }
            case BYTES: {
                generator.print("\"");
                generator.print(HtmlFormat.escapeBytes((ByteString)value));
                generator.print("\"");
                break;
            }
            case ENUM: {
                generator.print(((Descriptors.EnumValueDescriptor)value).getName());
                break;
            }
            case MESSAGE: 
            case GROUP: {
                this.print((Message)value, generator);
            }
        }
        generator.print("</span>");
    }

    private void printUnknownFields(UnknownFieldSet unknownFields, HtmlGenerator generator) throws IOException {
        for (Map.Entry entry : unknownFields.asMap().entrySet()) {
            UnknownFieldSet.Field field = (UnknownFieldSet.Field)entry.getValue();
            Iterator iterator = field.getVarintList().iterator();
            while (iterator.hasNext()) {
                long value = (Long)iterator.next();
                generator.print(((Integer)entry.getKey()).toString());
                generator.print(": ");
                generator.print(TextUtils.unsignedToString(value));
                generator.print("<br/>");
            }
            iterator = field.getFixed32List().iterator();
            while (iterator.hasNext()) {
                int value = (Integer)iterator.next();
                generator.print(((Integer)entry.getKey()).toString());
                generator.print(": ");
                generator.print(String.format((Locale)null, "0x%08x", value));
                generator.print("<br/>");
            }
            iterator = field.getFixed64List().iterator();
            while (iterator.hasNext()) {
                long value = (Long)iterator.next();
                generator.print(((Integer)entry.getKey()).toString());
                generator.print(": ");
                generator.print(String.format((Locale)null, "0x%016x", value));
                generator.print("<br/>");
            }
            for (ByteString value : field.getLengthDelimitedList()) {
                generator.print(((Integer)entry.getKey()).toString());
                generator.print(": \"");
                generator.print(HtmlFormat.escapeBytes(value));
                generator.print("\"<br/>");
            }
            for (UnknownFieldSet value : field.getGroupList()) {
                generator.print(((Integer)entry.getKey()).toString());
                generator.print(" <span style=\"color: red;\">{</span><br/>");
                generator.indent();
                this.printUnknownFields(value, generator);
                generator.outdent();
                generator.print("<span style=\"color: red;\">}</span><br/>");
            }
        }
    }

    static String escapeBytes(ByteString input) {
        StringBuilder builder = new StringBuilder(input.size());
        block12: for (int i = 0; i < input.size(); ++i) {
            byte b = input.byteAt(i);
            switch (b) {
                case 7: {
                    builder.append("\\a");
                    continue block12;
                }
                case 8: {
                    builder.append("\\b");
                    continue block12;
                }
                case 12: {
                    builder.append("\\f");
                    continue block12;
                }
                case 10: {
                    builder.append("\\n");
                    continue block12;
                }
                case 13: {
                    builder.append("\\r");
                    continue block12;
                }
                case 9: {
                    builder.append("\\t");
                    continue block12;
                }
                case 11: {
                    builder.append("\\v");
                    continue block12;
                }
                case 92: {
                    builder.append("\\\\");
                    continue block12;
                }
                case 39: {
                    builder.append("\\'");
                    continue block12;
                }
                case 34: {
                    builder.append("\\\"");
                    continue block12;
                }
                default: {
                    if (b >= 32) {
                        builder.append((char)b);
                        continue block12;
                    }
                    builder.append('\\');
                    builder.append((char)(48 + (b >>> 6 & 3)));
                    builder.append((char)(48 + (b >>> 3 & 7)));
                    builder.append((char)(48 + (b & 7)));
                }
            }
        }
        return builder.toString();
    }

    static ByteString unescapeBytes(CharSequence input) throws InvalidEscapeSequence {
        byte[] result = new byte[input.length()];
        int pos = 0;
        block13: for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '\\') {
                if (i + 1 < input.length()) {
                    int code;
                    if (TextUtils.isOctal(c = input.charAt(++i))) {
                        code = TextUtils.digitValue(c);
                        if (i + 1 < input.length() && TextUtils.isOctal(input.charAt(i + 1))) {
                            code = code * 8 + TextUtils.digitValue(input.charAt(++i));
                        }
                        if (i + 1 < input.length() && TextUtils.isOctal(input.charAt(i + 1))) {
                            code = code * 8 + TextUtils.digitValue(input.charAt(++i));
                        }
                        result[pos++] = (byte)code;
                        continue;
                    }
                    switch (c) {
                        case 'a': {
                            result[pos++] = 7;
                            continue block13;
                        }
                        case 'b': {
                            result[pos++] = 8;
                            continue block13;
                        }
                        case 'f': {
                            result[pos++] = 12;
                            continue block13;
                        }
                        case 'n': {
                            result[pos++] = 10;
                            continue block13;
                        }
                        case 'r': {
                            result[pos++] = 13;
                            continue block13;
                        }
                        case 't': {
                            result[pos++] = 9;
                            continue block13;
                        }
                        case 'v': {
                            result[pos++] = 11;
                            continue block13;
                        }
                        case '\\': {
                            result[pos++] = 92;
                            continue block13;
                        }
                        case '\'': {
                            result[pos++] = 39;
                            continue block13;
                        }
                        case '\"': {
                            result[pos++] = 34;
                            continue block13;
                        }
                        case 'x': {
                            code = 0;
                            if (i + 1 >= input.length() || !TextUtils.isHex(input.charAt(i + 1))) {
                                throw new InvalidEscapeSequence("Invalid escape sequence: '\\x' with no digits");
                            }
                            code = TextUtils.digitValue(input.charAt(++i));
                            if (i + 1 < input.length() && TextUtils.isHex(input.charAt(i + 1))) {
                                code = code * 16 + TextUtils.digitValue(input.charAt(++i));
                            }
                            result[pos++] = (byte)code;
                            continue block13;
                        }
                        default: {
                            throw new InvalidEscapeSequence("Invalid escape sequence: '\\" + c + "'");
                        }
                    }
                }
                throw new InvalidEscapeSequence("Invalid escape sequence: '\\' at end of string.");
            }
            result[pos++] = (byte)c;
        }
        return ByteString.copyFrom((byte[])result, (int)0, (int)pos);
    }

    static String escapeText(String input) {
        return HtmlFormat.escapeBytes(ByteString.copyFromUtf8((String)input));
    }

    static String unescapeText(String input) throws InvalidEscapeSequence {
        return HtmlFormat.unescapeBytes(input).toStringUtf8();
    }

    static int parseInt32(String text) throws NumberFormatException {
        return (int)HtmlFormat.parseInteger(text, true, false);
    }

    static int parseUInt32(String text) throws NumberFormatException {
        return (int)HtmlFormat.parseInteger(text, false, false);
    }

    static long parseInt64(String text) throws NumberFormatException {
        return HtmlFormat.parseInteger(text, true, true);
    }

    static long parseUInt64(String text) throws NumberFormatException {
        return HtmlFormat.parseInteger(text, false, true);
    }

    private static long parseInteger(String text, boolean isSigned, boolean isLong) throws NumberFormatException {
        int pos = 0;
        boolean negative = false;
        if (text.startsWith("-", pos)) {
            if (!isSigned) {
                throw new NumberFormatException("Number must be positive: " + text);
            }
            ++pos;
            negative = true;
        }
        int radix = 10;
        if (text.startsWith("0x", pos)) {
            pos += 2;
            radix = 16;
        } else if (text.startsWith("0", pos)) {
            radix = 8;
        }
        String numberText = text.substring(pos);
        long result = 0L;
        if (numberText.length() < 16) {
            result = Long.parseLong(numberText, radix);
            if (negative) {
                result = -result;
            }
            if (!isLong) {
                if (isSigned) {
                    if (result > Integer.MAX_VALUE || result < Integer.MIN_VALUE) {
                        throw new NumberFormatException("Number out of range for 32-bit signed integer: " + text);
                    }
                } else if (result >= 0x100000000L || result < 0L) {
                    throw new NumberFormatException("Number out of range for 32-bit unsigned integer: " + text);
                }
            }
        } else {
            BigInteger bigValue = new BigInteger(numberText, radix);
            if (negative) {
                bigValue = bigValue.negate();
            }
            if (!isLong) {
                if (isSigned) {
                    if (bigValue.bitLength() > 31) {
                        throw new NumberFormatException("Number out of range for 32-bit signed integer: " + text);
                    }
                } else if (bigValue.bitLength() > 32) {
                    throw new NumberFormatException("Number out of range for 32-bit unsigned integer: " + text);
                }
            } else if (isSigned) {
                if (bigValue.bitLength() > 63) {
                    throw new NumberFormatException("Number out of range for 64-bit signed integer: " + text);
                }
            } else if (bigValue.bitLength() > 64) {
                throw new NumberFormatException("Number out of range for 64-bit unsigned integer: " + text);
            }
            result = bigValue.longValue();
        }
        return result;
    }

    static class InvalidEscapeSequence
    extends IOException {
        private static final long serialVersionUID = 1L;

        public InvalidEscapeSequence(String description) {
            super(description);
        }
    }

    private static final class HtmlGenerator {
        Appendable output;
        boolean atStartOfLine = true;

        public HtmlGenerator(Appendable output) {
            this.output = output;
        }

        public void indent() throws IOException {
            this.print("<div style=\"margin-left: 25px\">");
        }

        public void outdent() throws IOException {
            this.print("</div>");
        }

        public void print(CharSequence text) throws IOException {
            int size = text.length();
            int pos = 0;
            for (int i = 0; i < size; ++i) {
                if (text.charAt(i) != '\n') continue;
                this.write("<br/>", i - pos + 1);
                pos = i + 1;
                this.atStartOfLine = true;
            }
            this.write(text.subSequence(pos, size), size - pos);
        }

        private void write(CharSequence data, int size) throws IOException {
            if (size == 0) {
                return;
            }
            if (this.atStartOfLine) {
                this.atStartOfLine = false;
            }
            this.output.append(data);
        }
    }
}

