/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.protobuf.format;

import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.Message;
import com.google.protobuf.UnknownFieldSet;
import com.googlecode.protobuf.format.JsonFormat;
import java.io.IOException;

public class CouchDBFormat
extends JsonFormat {
    @Override
    public void print(Message message, Appendable output) throws IOException {
        CouchDBGenerator generator = new CouchDBGenerator(output);
        generator.print("{");
        this.print(message, generator);
        generator.print("}");
    }

    @Override
    public void print(UnknownFieldSet fields, Appendable output) throws IOException {
        CouchDBGenerator generator = new CouchDBGenerator(output);
        generator.print("{");
        this.printUnknownFields(fields, generator);
        generator.print("}");
    }

    @Override
    public void merge(CharSequence input, ExtensionRegistry extensionRegistry, Message.Builder builder) throws JsonFormat.ParseException {
        Tokenizer tokenizer = new Tokenizer(input);
        tokenizer.consume("{");
        while (!tokenizer.tryConsume("}")) {
            this.mergeField(tokenizer, extensionRegistry, builder);
        }
    }

    protected static class CouchDBGenerator
    extends JsonFormat.JsonGenerator {
        public CouchDBGenerator(Appendable output) {
            super(output);
        }

        @Override
        public void print(CharSequence text) throws IOException {
            if ("id".equals(text)) {
                super.print("_id");
            } else if ("rev".equals(text)) {
                super.print("_rev");
            } else {
                super.print(text);
            }
        }
    }

    protected static class Tokenizer
    extends JsonFormat.Tokenizer {
        public Tokenizer(CharSequence text) {
            super(text);
        }

        @Override
        public String consumeIdentifier() throws JsonFormat.ParseException {
            String id = super.consumeIdentifier();
            if ("_id".equals(id)) {
                return "id";
            }
            if ("_rev".equals(id)) {
                return "rev";
            }
            return id;
        }
    }
}

