/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnjava.command.diff;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.diff.AbstractDiffCommand;
import org.apache.maven.scm.command.diff.DiffScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.svn.command.SvnCommand;
import org.apache.maven.scm.provider.svn.command.diff.SvnDiffConsumer;
import org.apache.maven.scm.provider.svn.svnjava.repository.SvnJavaScmProviderRepository;
import org.apache.maven.scm.provider.svn.svnjava.util.ScmFileEventHandler;
import org.apache.maven.scm.provider.svn.svnjava.util.SvnJavaUtil;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class SvnJavaDiffCommand
extends AbstractDiffCommand
implements SvnCommand {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DiffScmResult executeDiffCommand(ScmProviderRepository repo, ScmFileSet fileSet, ScmVersion startRevision, ScmVersion endRevision) throws ScmException {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("SVN diff directory: " + fileSet.getBasedir().getAbsolutePath());
        }
        SvnJavaScmProviderRepository javaRepo = (SvnJavaScmProviderRepository)repo;
        ScmFileEventHandler handler = new ScmFileEventHandler(this.getLogger(), fileSet.getBasedir());
        try {
            javaRepo.getClientManager().getDiffClient().setEventHandler((ISVNEventHandler)handler);
            SVNRevision start = startRevision == null ? SVNRevision.COMMITTED : SVNRevision.parse((String)startRevision.getName());
            SVNRevision end = endRevision == null ? SVNRevision.WORKING : SVNRevision.parse((String)endRevision.getName());
            ByteArrayOutputStream out = SvnJavaUtil.diff(javaRepo.getClientManager(), fileSet.getBasedir(), start, end);
            SvnDiffConsumer consumer = new SvnDiffConsumer(this.getLogger(), fileSet.getBasedir());
            ByteArrayInputStream bis = new ByteArrayInputStream(out.toByteArray());
            BufferedReader in = new BufferedReader(new InputStreamReader(bis));
            String line = in.readLine();
            while (line != null) {
                consumer.consumeLine(line);
                line = in.readLine();
            }
            DiffScmResult diffScmResult = new DiffScmResult("JavaSVN Library", consumer.getChangedFiles(), consumer.getDifferences(), consumer.getPatch());
            return diffScmResult;
        }
        catch (IOException e) {
            DiffScmResult diffScmResult = new DiffScmResult("JavaSVN Library", "SVN diff failed.", e.getMessage(), false);
            return diffScmResult;
        }
        catch (SVNException e) {
            DiffScmResult diffScmResult = new DiffScmResult("JavaSVN Library", "SVN diff failed.", e.getMessage(), false);
            return diffScmResult;
        }
        finally {
            javaRepo.getClientManager().getDiffClient().setEventHandler(null);
        }
    }
}

