/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.github.zengfr.easymodbus4j.codec.rtu;

import com.github.zengfr.easymodbus4j.protocol.ModbusFunctionCode;
import com.github.zengfr.easymodbus4j.util.ModbusFunctionUtil;

import io.netty.buffer.ByteBuf;

/**
 * @author zengfr QQ:362505707/1163551688 Email:zengfr3000@qq.com
 *         https://github.com/zengfr/easymodbus4j
 */
public   class ModbusRtuCodecUtil  {
	
	private static final int MessageMinSize = 5;
	private static final int FunctionFieldIndex = 1;
	private static final int LengthFieldIndex = 2;

	public static int getMessageMinSize() {
		return MessageMinSize;
	}
	private static int getLength(ByteBuf in, int startIndex) {
		return in.getUnsignedByte(startIndex + LengthFieldIndex);
	}

	private static short getFunctionCode(ByteBuf in, int startIndex) {
		return in.getUnsignedByte(startIndex + FunctionFieldIndex);
	}

	public static int getMessageLength(ByteBuf in, int startIndex) {

		short functionCode = getFunctionCode(in, startIndex);

		if (ModbusFunctionUtil.isError(functionCode)) {
			// unitid , functioncode, errorcode, CRC
			return 1 + 1 + 1 + 2;
		}
		switch (functionCode) {
		case ModbusFunctionCode.READ_COILS:
		case ModbusFunctionCode.READ_DISCRETE_INPUTS:
		case ModbusFunctionCode.READ_HOLDING_REGISTERS:
		case ModbusFunctionCode.READ_INPUT_REGISTERS:
			int length = getLength(in, startIndex);
			// unitid, functioncode, length, length value, CRC
			return 1 + 1 + 1 + length + 2;
		case ModbusFunctionCode.WRITE_SINGLE_COIL:
		case ModbusFunctionCode.WRITE_SINGLE_REGISTER:
		case ModbusFunctionCode.WRITE_MULTIPLE_COILS:
		case ModbusFunctionCode.WRITE_MULTIPLE_REGISTERS:
			// unit id, functioncode , fix length, CRC
			return 1 + 1 + 4 + 2;
		// case ModbusFunctionCode.MaskWriteRegister:
		// unit id, functioncode, fix length, CRC
		// return 1 + 1 + 6 + 2;

		default:
			return 0;
		}
	}
}
