/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.github.zengfr.easymodbus4j.codec;

import com.github.zengfr.easymodbus4j.func.request.ReadCoilsRequest;
import com.github.zengfr.easymodbus4j.func.request.ReadDiscreteInputsRequest;
import com.github.zengfr.easymodbus4j.func.request.ReadHoldingRegistersRequest;
import com.github.zengfr.easymodbus4j.func.request.ReadInputRegistersRequest;
import com.github.zengfr.easymodbus4j.func.request.WriteMultipleCoilsRequest;
import com.github.zengfr.easymodbus4j.func.request.WriteMultipleRegistersRequest;
import com.github.zengfr.easymodbus4j.func.request.WriteSingleCoilRequest;
import com.github.zengfr.easymodbus4j.func.request.WriteSingleRegisterRequest;
import com.github.zengfr.easymodbus4j.protocol.ModbusFunction;
import com.github.zengfr.easymodbus4j.protocol.ModbusFunctionCode;
import io.netty.buffer.ByteBuf;
/**
 * @author zengfr QQ:362505707/1163551688 Email:zengfr3000@qq.com
 *         https://github.com/zengfr/easymodbus4j
 */
public   class ModbusPduReqCodec extends ModbusPduCodec {

	@Override
	public ModbusFunction decode(ByteBuf buffer) {
	 
		return decodeFunction( buffer);
	}
	public static ModbusFunction decodeFunction(ByteBuf buffer ) {
		 
		short functionCode = buffer.readUnsignedByte();
		ModbusFunction function =decodeReqFunction(functionCode);
		function.decode(buffer);
		//function.decode(buffer.readBytes(buffer.readableBytes()));
		return function;
	}

	protected static ModbusFunction decodeReqFunction(short functionCode) {
		ModbusFunction function = null;
		switch (functionCode) {
		case ModbusFunctionCode.READ_COILS:
			function = new ReadCoilsRequest();
			break;
		case ModbusFunctionCode.READ_DISCRETE_INPUTS:
			function = new ReadDiscreteInputsRequest();
			break;
		case ModbusFunctionCode.READ_INPUT_REGISTERS:
			function = new ReadInputRegistersRequest();
			break;
		case ModbusFunctionCode.READ_HOLDING_REGISTERS:
			function = new ReadHoldingRegistersRequest();
			break;
		case ModbusFunctionCode.WRITE_SINGLE_COIL:
			function = new WriteSingleCoilRequest();
			break;
		case ModbusFunctionCode.WRITE_SINGLE_REGISTER:
			function = new WriteSingleRegisterRequest();
			break;
		case ModbusFunctionCode.WRITE_MULTIPLE_COILS:
			function = new WriteMultipleCoilsRequest();
			break;
		case ModbusFunctionCode.WRITE_MULTIPLE_REGISTERS:
			function = new WriteMultipleRegistersRequest();
			break;
		}

		return function;
	}

}
