/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.sarif;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.stream.JsonWriter;
import edu.umd.cs.findbugs.BugCollectionBugReporter;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.ExitCodes;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.Version;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.sarif.BugCollectionAnalyser;
import edu.umd.cs.findbugs.sarif.Extension;
import edu.umd.cs.findbugs.sarif.Invocation;
import edu.umd.cs.findbugs.sarif.Level;
import edu.umd.cs.findbugs.sarif.Notification;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class SarifBugReporter
extends BugCollectionBugReporter {
    private final Gson gson = new Gson();

    public SarifBugReporter(Project project) {
        super(project);
    }

    @Override
    public void finish() {
        try {
            JsonWriter jsonWriter = new JsonWriter((Writer)this.outputStream);
            jsonWriter.beginObject();
            jsonWriter.name("version").value("2.1.0").name("$schema").value("https://raw.githubusercontent.com/oasis-tcs/sarif-spec/master/Schemata/sarif-schema-2.1.0.json");
            this.processRuns(jsonWriter);
            jsonWriter.endObject();
            this.getBugCollection().bugsPopulated();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error occurred while exporting to Sarif Json log.", e);
        }
        finally {
            this.outputStream.close();
        }
    }

    private void processRuns(@NonNull JsonWriter jsonWriter) throws IOException {
        jsonWriter.name("runs").beginArray().beginObject();
        BugCollectionAnalyser analyser = new BugCollectionAnalyser(this.getBugCollection());
        this.processTool(jsonWriter, analyser.getRules());
        this.processInvocations(jsonWriter, analyser.getBaseToId());
        jsonWriter.name("results").beginArray();
        analyser.getResults().forEach(result -> this.gson.toJson(result, jsonWriter));
        jsonWriter.endArray();
        jsonWriter.name("originalUriBaseIds");
        this.gson.toJson((JsonElement)analyser.getOriginalUriBaseIds(), jsonWriter);
        jsonWriter.endObject().endArray();
    }

    private void processInvocations(JsonWriter jsonWriter, @NonNull Map<URI, String> baseToId) throws IOException {
        ArrayList<Notification> configNotifications = new ArrayList<Notification>();
        Set<String> missingClasses = this.getMissingClasses();
        if (missingClasses == null) {
            missingClasses = Collections.emptySet();
        }
        if (!missingClasses.isEmpty()) {
            String message = String.format("Classes needed for analysis were missing: %s", missingClasses.toString());
            configNotifications.add(new Notification("spotbugs-missing-classes", message, Level.ERROR, null));
        }
        List<Notification> execNotifications = this.getQueuedErrors().stream().map(t -> Notification.fromError(t, this.getProject().getSourceFinder(), baseToId)).collect(Collectors.toList());
        int exitCode = ExitCodes.from(this.getQueuedErrors().size(), missingClasses.size(), this.getBugCollection().getCollection().size());
        Invocation invocation = new Invocation(exitCode, SarifBugReporter.getSignalName(exitCode), exitCode == 0, execNotifications, configNotifications);
        jsonWriter.name("invocations").beginArray();
        this.gson.toJson((JsonElement)invocation.toJsonObject(), jsonWriter);
        jsonWriter.endArray();
    }

    private void processTool(@NonNull JsonWriter jsonWriter, @NonNull JsonArray rules) throws IOException {
        jsonWriter.name("tool").beginObject();
        this.processExtensions(jsonWriter);
        jsonWriter.name("driver").beginObject();
        jsonWriter.name("name").value("SpotBugs");
        jsonWriter.name("version").value(Version.VERSION_STRING);
        jsonWriter.name("language").value(Locale.getDefault().getLanguage());
        jsonWriter.name("rules").beginArray();
        rules.forEach(rule -> this.gson.toJson(rule, jsonWriter));
        jsonWriter.endArray();
        jsonWriter.endObject().endObject();
    }

    private void processExtensions(@NonNull JsonWriter jsonWriter) throws IOException {
        jsonWriter.name("extensions").beginArray();
        DetectorFactoryCollection.instance().plugins().stream().map(Extension::fromPlugin).map(Extension::toJsonObject).forEach(jsonObject -> this.gson.toJson((JsonElement)jsonObject, jsonWriter));
        jsonWriter.endArray();
    }

    private static String getSignalName(int exitCode) {
        if (exitCode == 0) {
            return "SUCCESS";
        }
        ArrayList<String> list = new ArrayList<String>();
        if ((exitCode | 4) > 0) {
            list.add("ERROR");
        }
        if ((exitCode | 2) > 0) {
            list.add("MISSING CLASS");
        }
        if ((exitCode | 1) > 0) {
            list.add("BUGS FOUND");
        }
        return list.isEmpty() ? "UNKNOWN" : list.stream().collect(Collectors.joining(","));
    }
}

