/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.NonReportingDetector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

public class BuildStringPassthruGraph
extends OpcodeStackDetector
implements NonReportingDetector {
    private static final int PRIME = 31;
    private final StringPassthruDatabase cache = new StringPassthruDatabase();
    private int nArgs;
    private int[] argNums;
    private List<MethodParameter>[] passedParameters;

    public BuildStringPassthruGraph(BugReporter bugReporter) {
        Global.getAnalysisCache().eagerlyPutDatabase(StringPassthruDatabase.class, this.cache);
    }

    @Override
    public void visitMethod(Method obj) {
        this.argNums = null;
        Type[] argumentTypes = obj.getArgumentTypes();
        if (argumentTypes.length == 0) {
            return;
        }
        int lvNum = obj.isStatic() ? 0 : 1;
        this.nArgs = argumentTypes.length;
        int argCount = lvNum;
        for (Type type : argumentTypes) {
            argCount += type.getSize();
        }
        for (int i = 0; i < this.nArgs; ++i) {
            if (argumentTypes[i].getSignature().equals("Ljava/lang/String;")) {
                if (this.argNums == null) {
                    this.argNums = new int[argCount];
                    Arrays.fill(this.argNums, -1);
                }
                this.argNums[lvNum] = i;
            }
            lvNum += argumentTypes[i].getSize();
        }
        if (this.argNums != null) {
            this.passedParameters = new List[this.nArgs];
        }
        super.visitMethod(obj);
    }

    @Override
    public boolean shouldVisitCode(Code obj) {
        return this.argNums != null;
    }

    @Override
    public void visitAfter(Code obj) {
        super.visitAfter(obj);
        for (int i = 0; i < this.nArgs; ++i) {
            List<MethodParameter> list = this.passedParameters[i];
            if (list == null) continue;
            MethodParameter cur = new MethodParameter(this.getMethodDescriptor(), i);
            for (MethodParameter mp : list) {
                this.cache.addEdge(mp, cur);
            }
        }
    }

    @Override
    public void sawOpcode(int seen) {
        int param;
        if (this.isRegisterStore() && (param = this.getRegisterOperand()) < this.argNums.length) {
            int argNum = this.argNums[param];
            this.argNums[param] = -1;
            if (argNum >= 0) {
                this.passedParameters[argNum] = null;
            }
        }
        switch (seen) {
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                MethodDescriptor md = this.getMethodDescriptorOperand();
                int callArgs = BuildStringPassthruGraph.getNumberArguments(md.getSignature());
                for (int i = 0; i < callArgs; ++i) {
                    OpcodeStack.Item item = this.getStack().getStackItem(callArgs - 1 - i);
                    int param2 = item.getRegisterNumber();
                    if (param2 < 0 || param2 >= this.argNums.length || this.argNums[param2] == -1) continue;
                    List<MethodParameter> list = this.passedParameters[this.argNums[param2]];
                    if (list == null) {
                        this.passedParameters[this.argNums[param2]] = list = new ArrayList<MethodParameter>();
                    }
                    list.add(new MethodParameter(md, i));
                }
                break;
            }
        }
    }

    public static class StringPassthruDatabase {
        private static final List<MethodDescriptor> FILENAME_STRING_METHODS = Arrays.asList(new MethodDescriptor("java/io/File", "<init>", "(Ljava/lang/String;)V"), new MethodDescriptor("java/io/File", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V"), new MethodDescriptor("java/io/RandomAccessFile", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V"), new MethodDescriptor("java/nio/file/Paths", "get", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/nio/file/Path;", true), new MethodDescriptor("java/io/FileReader", "<init>", "(Ljava/lang/String;)V"), new MethodDescriptor("java/io/FileWriter", "<init>", "(Ljava/lang/String;)V"), new MethodDescriptor("java/io/FileWriter", "<init>", "(Ljava/lang/String;Z)V"), new MethodDescriptor("java/io/FileInputStream", "<init>", "(Ljava/lang/String;)V"), new MethodDescriptor("java/io/FileOutputStream", "<init>", "(Ljava/lang/String;)V"), new MethodDescriptor("java/io/FileOutputStream", "<init>", "(Ljava/lang/String;Z)V"), new MethodDescriptor("java/util/Formatter", "<init>", "(Ljava/lang/String;)V"), new MethodDescriptor("java/util/Formatter", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V"), new MethodDescriptor("java/util/Formatter", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Locale;)V"), new MethodDescriptor("java/util/jar/JarFile", "<init>", "(Ljava/lang/String;)V"), new MethodDescriptor("java/util/jar/JarFile", "<init>", "(Ljava/lang/String;Z)V"), new MethodDescriptor("java/util/zip/ZipFile", "<init>", "(Ljava/lang/String;)V"), new MethodDescriptor("java/util/zip/ZipFile", "<init>", "(Ljava/lang/String;Ljava/nio/charset/Charset;)V"), new MethodDescriptor("java/io/PrintStream", "<init>", "(Ljava/lang/String;)V"), new MethodDescriptor("java/io/PrintStream", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V"), new MethodDescriptor("java/io/PrintWriter", "<init>", "(Ljava/lang/String;)V"), new MethodDescriptor("java/io/PrintWriter", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V"));
        private final Map<MethodParameter, Set<MethodParameter>> graph = new HashMap<MethodParameter, Set<MethodParameter>>();

        void addEdge(MethodParameter in, MethodParameter out) {
            Set outs = this.graph.computeIfAbsent(in, k -> new HashSet());
            outs.add(out);
        }

        Set<MethodParameter> findLinked(Set<MethodParameter> inputs) {
            HashSet<MethodParameter> result = new HashSet<MethodParameter>(inputs);
            ArrayDeque<MethodParameter> toCheck = new ArrayDeque<MethodParameter>(inputs);
            while (!toCheck.isEmpty()) {
                MethodParameter in = (MethodParameter)toCheck.poll();
                Set<MethodParameter> outs = this.graph.get(in);
                if (outs == null) continue;
                for (MethodParameter out : outs) {
                    if (result.contains(out)) continue;
                    result.add(out);
                    toCheck.add(out);
                }
            }
            return result;
        }

        public Map<MethodDescriptor, int[]> findLinkedMethods(Set<MethodParameter> inputs) {
            HashMap<MethodDescriptor, int[]> result = new HashMap<MethodDescriptor, int[]>();
            for (MethodParameter found : this.findLinked(inputs)) {
                int[] params = (int[])result.get(found.getMethodDescriptor());
                if (params == null) {
                    params = new int[]{found.getParameterNumber()};
                    result.put(found.getMethodDescriptor(), params);
                    continue;
                }
                int[] newParams = new int[params.length + 1];
                System.arraycopy(params, 0, newParams, 0, params.length);
                newParams[params.length] = found.getParameterNumber();
                result.put(found.getMethodDescriptor(), newParams);
            }
            return result;
        }

        public Map<MethodDescriptor, int[]> getFileNameStringMethods() {
            HashSet<MethodParameter> fileNameStringMethods = new HashSet<MethodParameter>();
            for (MethodDescriptor md : FILENAME_STRING_METHODS) {
                fileNameStringMethods.add(new MethodParameter(md, 0));
            }
            return this.findLinkedMethods(fileNameStringMethods);
        }
    }

    public static class MethodParameter {
        final MethodDescriptor md;
        final int parameterNumber;

        public MethodParameter(MethodDescriptor md, int parameterNumber) {
            this.md = md;
            this.parameterNumber = parameterNumber;
        }

        public MethodDescriptor getMethodDescriptor() {
            return this.md;
        }

        public int getParameterNumber() {
            return this.parameterNumber;
        }

        public String toString() {
            return this.md + "[" + this.parameterNumber + "]";
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.md == null ? 0 : this.md.hashCode());
            result = 31 * result + this.parameterNumber;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MethodParameter other = (MethodParameter)obj;
            return Objects.equals(this.md, other.md) && this.parameterNumber == other.parameterNumber;
        }
    }
}

