/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.bytecode;

import edu.umd.cs.findbugs.ba.ClassMember;
import edu.umd.cs.findbugs.ba.XMethod;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Synthetic;
import org.apache.bcel.generic.FieldGenOrMethodGen;
import org.apache.bcel.generic.MethodGen;

public final class MemberUtils {
    private MemberUtils() {
        throw new AssertionError((Object)"Utility classes can't be instantiated");
    }

    private static boolean internalIsSynthetic(FieldOrMethod m) {
        if (m.isSynthetic()) {
            return true;
        }
        for (Attribute a : m.getAttributes()) {
            if (!(a instanceof Synthetic)) continue;
            return true;
        }
        return false;
    }

    private static boolean internalIsSynthetic(FieldGenOrMethodGen m) {
        if (m.isSynthetic()) {
            return true;
        }
        for (Attribute a : m.getAttributes()) {
            if (!(a instanceof Synthetic)) continue;
            return true;
        }
        return false;
    }

    public static boolean couldBeLambda(Method m) {
        return m.isPrivate() && MemberUtils.internalIsSynthetic((FieldOrMethod)m);
    }

    public static boolean couldBeLambda(XMethod m) {
        return m.isPrivate() && m.isSynthetic();
    }

    public static boolean couldBeLambda(MethodGen m) {
        return m.isPrivate() && MemberUtils.internalIsSynthetic((FieldGenOrMethodGen)m);
    }

    public static boolean isUserGenerated(FieldOrMethod m) {
        return !MemberUtils.internalIsSynthetic(m) || m instanceof Method && MemberUtils.couldBeLambda((Method)m);
    }

    public static boolean isUserGenerated(ClassMember m) {
        return !m.isSynthetic() || m instanceof XMethod && MemberUtils.couldBeLambda((XMethod)m);
    }

    public static boolean isUserGenerated(FieldGenOrMethodGen m) {
        return !MemberUtils.internalIsSynthetic(m) || m instanceof MethodGen && MemberUtils.couldBeLambda((MethodGen)m);
    }
}

