/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.ba.SourceFileDataSource;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.FileSystem;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipSourceFileDataSource
implements SourceFileDataSource {
    private final ZipFile zipFile;
    private final String entryName;
    private final URI entryURI;
    private final ZipEntry zipEntry;

    public ZipSourceFileDataSource(ZipFile zipFile, FileSystem zipFileSystem, String entryName) {
        this.zipFile = zipFile;
        this.entryName = entryName;
        this.entryURI = zipFileSystem.getPath(entryName, new String[0]).toUri();
        this.zipEntry = zipFile.getEntry(entryName);
    }

    @Override
    public InputStream open() throws IOException {
        if (this.zipEntry == null) {
            throw new FileNotFoundException("No zip entry for " + this.entryName);
        }
        return this.zipFile.getInputStream(this.zipEntry);
    }

    @Override
    public String getFullFileName() {
        return this.entryName;
    }

    @Override
    public URI getFullURI() {
        return this.entryURI;
    }

    @Override
    public long getLastModified() {
        long time = this.zipEntry.getTime();
        if (time < 0L) {
            return 0L;
        }
        return time;
    }
}

